/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.event;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.event.MobSpawnCache;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;

@EventBusSubscriber(modid="landfallessentials")
public class MobSpawnHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobSpawnHandler.class);
    private static final Set<String> regionsWithPeaceful = ConcurrentHashMap.newKeySet();
    private static final Set<String> regionsWithNoMobs = ConcurrentHashMap.newKeySet();
    private static boolean hasAnySpawnControl = false;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onMobSpawn(FinalizeSpawnEvent event) {
        if (!Config.mobSpawnControlEnabled) {
            return;
        }
        if (!hasAnySpawnControl) {
            return;
        }
        Mob entity = event.getEntity();
        if (entity == null) {
            return;
        }
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos spawnPos = entity.blockPosition();
        String dimension = serverLevel.dimension().location().toString();
        MobSpawnCache.SpawnRule rule = MobSpawnCache.getSpawnRule(spawnPos, dimension);
        if (rule == MobSpawnCache.SpawnRule.ALLOW_ALL) {
            return;
        }
        if (rule == MobSpawnCache.SpawnRule.NO_MOBS) {
            event.setSpawnCancelled(true);
            return;
        }
        if (rule == MobSpawnCache.SpawnRule.PEACEFUL && MobSpawnHandler.isHostileMob((Entity)entity)) {
            event.setSpawnCancelled(true);
        }
    }

    private static boolean isHostileMob(Entity entity) {
        if (entity instanceof Enemy) {
            return true;
        }
        MobCategory category = entity.getType().getCategory();
        return category == MobCategory.MONSTER;
    }

    public static void updateSpawnControlFlags() {
        regionsWithPeaceful.clear();
        regionsWithNoMobs.clear();
        hasAnySpawnControl = false;
        if (!Config.mobSpawnControlEnabled) {
            return;
        }
        ArrayList<Region> allRegions = new ArrayList<Region>(RegionManager.getAllRegions().values());
        for (Region region : allRegions) {
            Set<String> tags = region.getTags();
            if (tags.contains("nomobs")) {
                regionsWithNoMobs.add(region.getName());
                hasAnySpawnControl = true;
                continue;
            }
            if (!tags.contains("peaceful")) continue;
            regionsWithPeaceful.add(region.getName());
            hasAnySpawnControl = true;
        }
        if (hasAnySpawnControl) {
            LOGGER.info("Mob spawn control enabled - {} peaceful regions, {} no-mob regions", (Object)regionsWithPeaceful.size(), (Object)regionsWithNoMobs.size());
        }
    }

    public static boolean hasRegionSpawnControl(String regionName) {
        return regionsWithPeaceful.contains(regionName) || regionsWithNoMobs.contains(regionName);
    }

    public static MobSpawnCache.SpawnRule getRegionSpawnRule(String regionName) {
        if (regionsWithNoMobs.contains(regionName)) {
            return MobSpawnCache.SpawnRule.NO_MOBS;
        }
        if (regionsWithPeaceful.contains(regionName)) {
            return MobSpawnCache.SpawnRule.PEACEFUL;
        }
        return MobSpawnCache.SpawnRule.ALLOW_ALL;
    }

    public static void onRegionModified(String regionName) {
        Region region = RegionManager.getRegion(regionName);
        if (region == null) {
            regionsWithPeaceful.remove(regionName);
            regionsWithNoMobs.remove(regionName);
            MobSpawnCache.invalidateRegion(regionName);
            MobSpawnHandler.updateHasAnyFlag();
            return;
        }
        Set<String> tags = region.getTags();
        boolean hadPeaceful = regionsWithPeaceful.contains(regionName);
        boolean hadNoMobs = regionsWithNoMobs.contains(regionName);
        boolean hasPeaceful = tags.contains("peaceful");
        boolean hasNoMobs = tags.contains("nomobs");
        if (hadPeaceful != hasPeaceful || hadNoMobs != hasNoMobs) {
            if (hasNoMobs) {
                regionsWithNoMobs.add(regionName);
                regionsWithPeaceful.remove(regionName);
            } else if (hasPeaceful) {
                regionsWithPeaceful.add(regionName);
                regionsWithNoMobs.remove(regionName);
            } else {
                regionsWithPeaceful.remove(regionName);
                regionsWithNoMobs.remove(regionName);
            }
            MobSpawnCache.invalidateRegion(regionName);
            MobSpawnHandler.updateHasAnyFlag();
        }
    }

    private static void updateHasAnyFlag() {
        hasAnySpawnControl = !regionsWithPeaceful.isEmpty() || !regionsWithNoMobs.isEmpty();
    }
}

