/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.home;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.home.Home;
import world.landfall.landfallessentials.home.HomeData;

@EventBusSubscriber
public class BedDisplayManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BedDisplayManager.class);
    private static final double DISPLAY_RANGE = 2.5;
    private static final int CHECK_INTERVAL = 20;
    private static final double HOLOGRAM_Y_OFFSET = -1.5;
    private static final Map<UUID, Map<String, ArmorStand>> playerDisplays = new ConcurrentHashMap<UUID, Map<String, ArmorStand>>();

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            return;
        }
        UUID playerUUID = event.getEntity().getUUID();
        Map<String, ArmorStand> displays = playerDisplays.remove(playerUUID);
        if (displays != null) {
            for (ArmorStand display : displays.values()) {
                if (display == null || !display.isAlive()) continue;
                display.discard();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (FMLEnvironment.dist.isClient() || !Config.requireBedForHomes) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (player.tickCount % 20 != 0) {
            return;
        }
        BedDisplayManager.updateBedDisplays(player);
    }

    private static void updateBedDisplays(ServerPlayer player) {
        UUID playerUUID = player.getUUID();
        ServerLevel level = player.serverLevel();
        BlockPos playerPos = player.blockPosition();
        Map currentDisplays = playerDisplays.computeIfAbsent(playerUUID, k -> new HashMap());
        HashMap<String, ArmorStand> newDisplays = new HashMap<String, ArmorStand>();
        int x = -2;
        while ((double)x <= 2.5) {
            int y = -2;
            while ((double)y <= 2.5) {
                int z = -2;
                while ((double)z <= 2.5) {
                    BlockState state;
                    BlockPos checkPos = playerPos.offset(x, y, z);
                    double distance = Math.sqrt(checkPos.distSqr((Vec3i)playerPos));
                    if (!(distance > 2.5) && (state = level.getBlockState(checkPos)).getBlock() instanceof BedBlock) {
                        String bedKey;
                        ArmorStand alreadyCreatedThisTick;
                        BlockPos footPos = checkPos;
                        if (state.hasProperty((Property)BedBlock.PART) && state.getValue((Property)BedBlock.PART) == BedPart.HEAD) {
                            footPos = checkPos.relative(((Direction)state.getValue((Property)BedBlock.FACING)).getOpposite());
                        }
                        if ((alreadyCreatedThisTick = (ArmorStand)newDisplays.get(bedKey = BedDisplayManager.bedPosToString(footPos))) != null && alreadyCreatedThisTick.isAlive()) {
                            BedDisplayManager.updateDisplayText(alreadyCreatedThisTick, footPos, level, player);
                        } else {
                            ArmorStand existingDisplay = (ArmorStand)currentDisplays.get(bedKey);
                            if (existingDisplay != null && existingDisplay.isAlive()) {
                                BedDisplayManager.updateDisplayText(existingDisplay, footPos, level, player);
                                newDisplays.put(bedKey, existingDisplay);
                            } else {
                                ArmorStand newDisplay = BedDisplayManager.createBedDisplay(footPos, level, player);
                                if (newDisplay != null) {
                                    newDisplays.put(bedKey, newDisplay);
                                }
                            }
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        for (Map.Entry entry : currentDisplays.entrySet()) {
            if (newDisplays.containsKey(entry.getKey())) continue;
            ArmorStand display = (ArmorStand)entry.getValue();
            if (display != null && display.isAlive()) {
                LOGGER.debug("Removing bed hologram {} as player moved away", (Object)display.getStringUUID());
                display.setCustomNameVisible(false);
                display.remove(Entity.RemovalReason.DISCARDED);
                if (!display.isRemoved()) {
                    display.kill();
                }
                LOGGER.debug("Bed hologram removed? {} (removed flag={})", (Object)display.getStringUUID(), (Object)display.isRemoved());
                continue;
            }
            LOGGER.debug("Bed hologram {} was already dead/removed", entry.getKey());
        }
        playerDisplays.put(playerUUID, newDisplays);
    }

    private static ArmorStand createBedDisplay(BlockPos bedPos, ServerLevel level, ServerPlayer player) {
        try {
            ArmorStand stand = new ArmorStand(EntityType.ARMOR_STAND, (Level)level);
            Vec3 pos = Vec3.atCenterOf((Vec3i)bedPos).add(0.0, -1.5, 0.0);
            stand.moveTo(pos.x, pos.y, pos.z, 0.0f, 0.0f);
            stand.setInvisible(true);
            stand.setNoGravity(true);
            stand.setCustomNameVisible(true);
            BedDisplayManager.updateDisplayText(stand, bedPos, level, player);
            if (level.addFreshEntity((Entity)stand)) {
                LOGGER.debug("Created bed hologram {} at {} for player {}", new Object[]{stand.getStringUUID(), pos, player.getScoreboardName()});
                return stand;
            }
            LOGGER.error("Failed to spawn hologram armor stand at {}", (Object)pos);
            return null;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create bed display at {}", (Object)bedPos, (Object)e);
            return null;
        }
    }

    private static void updateDisplayText(ArmorStand display, BlockPos bedPos, ServerLevel level, ServerPlayer viewer) {
        MutableComponent text;
        HomeData data = HomeData.get(level);
        boolean isClaimed = data.isBedClaimed(bedPos, (ResourceKey<Level>)level.dimension());
        if (isClaimed) {
            Home home;
            UUID owner = data.getBedOwner(bedPos, (ResourceKey<Level>)level.dimension());
            String homeName = data.getBedHomeName(bedPos, (ResourceKey<Level>)level.dimension());
            text = owner != null && homeName != null ? (owner.equals(viewer.getUUID()) ? ((home = data.getHome(owner, homeName)) != null && home.isDisabled() ? Component.literal((String)("\u00a7c\u2717 Your Home: " + homeName + " (DISABLED)")) : Component.literal((String)("\u00a7a\u2713 Your Home: " + homeName))) : Component.literal((String)"\u00a7c\u2717 Claimed by another player")) : Component.literal((String)"\u00a7c\u2717 Claimed");
        } else {
            text = Component.literal((String)"\u00a7e\u25cb Available for home");
        }
        display.setCustomName((Component)text);
        display.setCustomNameVisible(true);
        LOGGER.debug("Updated bed hologram {} text to '{}'", (Object)display.getStringUUID(), (Object)text.getString());
    }

    private static String bedPosToString(BlockPos pos) {
        return pos.getX() + "," + pos.getY() + "," + pos.getZ();
    }

    public static void cleanup() {
        for (Map<String, ArmorStand> displays : playerDisplays.values()) {
            for (ArmorStand display : displays.values()) {
                if (display == null || !display.isAlive()) continue;
                display.discard();
            }
        }
        playerDisplays.clear();
    }
}

