/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.home;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.home.Home;
import world.landfall.landfallessentials.home.HomeLuckPermsIntegration;
import world.landfall.landfallessentials.home.HomeSystem;

@EventBusSubscriber
public class HomeCommands {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"home").executes(ctx -> HomeCommands.teleportToHome((CommandContext<CommandSourceStack>)ctx, "default"))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> HomeCommands.teleportToHome((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"homes").executes(HomeCommands::listHomes));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sethome").executes(ctx -> HomeCommands.setHome((CommandContext<CommandSourceStack>)ctx, "default"))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> HomeCommands.setHome((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delhome").executes(ctx -> HomeCommands.deleteHome((CommandContext<CommandSourceStack>)ctx, "default"))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> HomeCommands.deleteHome((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"clearhomes").executes(HomeCommands::clearHomes));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"homeinfo").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> HomeCommands.showHomeInfo((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
    }

    private static int teleportToHome(CommandContext<CommandSourceStack> ctx, String homeName) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Home home = HomeSystem.getHome(player, homeName);
            if (home == null) {
                if (homeName.equals("default")) {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7cYou don't have a default home set. Use \u00a76/sethome\u00a7c to create one."));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYou don't have a home named \"" + homeName + "\".")));
                }
                return 0;
            }
            if (home.isDisabled()) {
                if (Config.requireBedForHomes) {
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYour home \"" + homeName + "\" is disabled because its bed was destroyed.")));
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7ePlace a bed at the same location to re-enable this home."));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYour home \"" + homeName + "\" is currently disabled.")));
                }
                return 0;
            }
            if (!HomeSystem.isHomeAccessible(player, homeName)) {
                int maxHomes = HomeSystem.getMaxHomes(player);
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYou can't teleport to \"" + homeName + "\" as it exceeds your home limit.")));
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYour current limit allows " + maxHomes + " home" + (maxHomes != 1 ? "s" : "") + ".")));
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7eGet bonus homes through donations or delete other homes to access this home."));
                return 0;
            }
            HomeSystem.HomeTeleportResult result = HomeSystem.teleportToHome(player, homeName);
            switch (result) {
                case SUCCESS: {
                    if (homeName.equals("default")) {
                        player.sendSystemMessage((Component)Component.literal((String)"\u00a7aWelcome home!"));
                    } else {
                        player.sendSystemMessage((Component)Component.literal((String)("\u00a7aWelcome to your home \"" + homeName + "\"!")));
                    }
                    return 1;
                }
                case ON_COOLDOWN: {
                    long remaining = HomeSystem.getRemainingCooldown(player);
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYou must wait " + remaining + " second" + (remaining != 1L ? "s" : "") + " before teleporting to a home again.")));
                    return 0;
                }
                case HOME_NOT_FOUND: {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7cHome not found."));
                    return 0;
                }
                case HOME_DISABLED: {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7cThis home is disabled because its bed was destroyed."));
                    return 0;
                }
                case HOME_LOCKED: {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7cThis home is currently locked due to your home limit."));
                    return 0;
                }
                case DIMENSION_NOT_FOUND: {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7cThe dimension for this home no longer exists."));
                    return 0;
                }
                case TELEPORT_FAILED: {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7cTeleportation failed. Please try again."));
                    return 0;
                }
            }
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cAn error occurred while teleporting."));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cThis command can only be executed by a player."));
            return 0;
        }
    }

    private static int listHomes(CommandContext<CommandSourceStack> ctx) {
        try {
            int bonusHomes;
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Map<String, Home> allHomes = HomeSystem.getPlayerHomes(player);
            Map<String, Home> accessibleHomes = HomeSystem.getAccessibleHomes(player);
            int homeCount = allHomes.size();
            int maxHomes = HomeSystem.getMaxHomes(player);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7e--- \u00a76Home System Commands \u00a7e---"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76/home [name] \u00a77- Teleport to a home (default if no name)"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76/sethome [name] \u00a77- Set a home at your current location"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76/delhome [name] \u00a77- Delete a specific home"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76/homes \u00a77- List all your homes and show this help"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76/homeinfo <name> \u00a77- Get detailed info about a home"));
            if (Config.requireBedForHomes) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7eNote: Homes must be set within 2 blocks of a bed. One home per bed."));
            }
            if ((bonusHomes = HomeLuckPermsIntegration.getBonusHomes(player)) > 0) {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7eYou can set up to \u00a76" + maxHomes + " homes\u00a7e (\u00a7a" + Config.defaultMaxHomes + " base + " + bonusHomes + " bonus\u00a7e).")));
            } else {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7eYou can set up to \u00a76" + maxHomes + " homes\u00a7e.")));
            }
            long cooldownTime = HomeSystem.getCooldownTime(player);
            long defaultCooldown = Config.defaultHomeCooldown;
            if (cooldownTime != defaultCooldown) {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7eCooldown between teleports: \u00a76" + cooldownTime + " second" + (cooldownTime != 1L ? "s" : "") + "\u00a7e (\u00a7aoverride active\u00a7e)")));
            } else {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7eCooldown between teleports: \u00a76" + cooldownTime + " second" + (cooldownTime != 1L ? "s" : ""))));
            }
            if (HomeSystem.isOnCooldown(player)) {
                long remaining;
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7eYou can teleport to a home in: \u00a76" + remaining + " second" + ((remaining = HomeSystem.getRemainingCooldown(player)) != 1L ? "s" : ""))));
            }
            if (homeCount == 0) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7eYou don't have any homes set yet."));
                return 1;
            }
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eYour homes (\u00a76" + accessibleHomes.size() + "/" + maxHomes + "\u00a7e):")));
            Set<String> homeNames = allHomes.keySet();
            if (allHomes.containsKey("default")) {
                Home defaultHome = allHomes.get("default");
                String status = HomeCommands.getHomeStatusString(defaultHome, accessibleHomes.containsKey("default"));
                player.sendSystemMessage((Component)Component.literal((String)(status + "default\u00a7e: \u00a7a" + String.format("%.1f", defaultHome.getX()) + "\u00a7e, \u00a7a" + String.format("%.1f", defaultHome.getY()) + "\u00a7e, \u00a7a" + String.format("%.1f", defaultHome.getZ()) + "\u00a7e in \u00a7a" + defaultHome.getDimensionDisplayName() + HomeCommands.getHomeStatusSuffix(defaultHome, accessibleHomes.containsKey("default")))));
            }
            homeNames.stream().filter(name -> !name.equals("default")).sorted(String::compareToIgnoreCase).forEach(name -> {
                Home home = (Home)allHomes.get(name);
                boolean isAccessible = accessibleHomes.containsKey(name);
                String status = HomeCommands.getHomeStatusString(home, isAccessible);
                player.sendSystemMessage((Component)Component.literal((String)(status + name + "\u00a7e: \u00a7a" + String.format("%.1f", home.getX()) + "\u00a7e, \u00a7a" + String.format("%.1f", home.getY()) + "\u00a7e, \u00a7a" + String.format("%.1f", home.getZ()) + "\u00a7e in \u00a7a" + home.getDimensionDisplayName() + HomeCommands.getHomeStatusSuffix(home, isAccessible))));
            });
            int disabledCount = (int)allHomes.values().stream().filter(Home::isDisabled).count();
            int lockedCount = homeCount - accessibleHomes.size() - disabledCount;
            if (disabledCount > 0) {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7c" + disabledCount + " home" + (disabledCount != 1 ? "s are" : " is") + " disabled due to missing beds.")));
            }
            if (lockedCount > 0) {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a78" + lockedCount + " home" + (lockedCount != 1 ? "s are" : " is") + " locked because your current limit only allows " + maxHomes + " home" + (maxHomes != 1 ? "s" : "") + ".")));
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7eGet bonus homes through donations to access locked homes, or delete some to set new ones."));
            }
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cThis command can only be executed by a player."));
            return 0;
        }
    }

    private static String getHomeStatusString(Home home, boolean isAccessible) {
        if (home.isDisabled()) {
            return "\u00a7c";
        }
        if (!isAccessible) {
            return "\u00a78";
        }
        return "\u00a76";
    }

    private static String getHomeStatusSuffix(Home home, boolean isAccessible) {
        if (home.isDisabled()) {
            return " \u00a7c[DISABLED]";
        }
        if (!isAccessible) {
            return " \u00a78[LOCKED]";
        }
        return "";
    }

    private static int setHome(CommandContext<CommandSourceStack> ctx, String homeName) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            HomeSystem.HomeSetResult result = HomeSystem.setHome(player, homeName);
            switch (result) {
                case CREATED: {
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a7aHome \"" + homeName + "\" set at " + String.format("%.1f", player.getX()) + ", " + String.format("%.1f", player.getY()) + ", " + String.format("%.1f", player.getZ()) + " in " + player.level().dimension().location().getPath())));
                    int accessibleCount = HomeSystem.getAccessibleHomes(player).size();
                    int maxHomes = HomeSystem.getMaxHomes(player);
                    int remaining = maxHomes - accessibleCount;
                    if (remaining > 0) {
                        player.sendSystemMessage((Component)Component.literal((String)("\u00a7eYou can set " + remaining + " more home" + (remaining != 1 ? "s" : "") + ".")));
                    } else {
                        player.sendSystemMessage((Component)Component.literal((String)"\u00a7eYou've used all your available home slots."));
                    }
                    return 1;
                }
                case UPDATED: {
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a7aHome \"" + homeName + "\" updated at " + String.format("%.1f", player.getX()) + ", " + String.format("%.1f", player.getY()) + ", " + String.format("%.1f", player.getZ()) + " in " + player.level().dimension().location().getPath())));
                    return 1;
                }
                case INVALID_NAME: {
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a7cInvalid home name. Names must be 1-" + Config.maxHomeNameLength + " characters and contain only letters, numbers, underscores, and hyphens.")));
                    return 0;
                }
                case NO_BED_NEARBY: {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7cYou must be within 2 blocks of a bed to set a home."));
                    return 0;
                }
                case BED_ALREADY_CLAIMED: {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7cThis bed is already claimed by another player."));
                    return 0;
                }
                case BED_HAS_DIFFERENT_HOME: {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7cThis bed already has a different home associated with it."));
                    return 0;
                }
                case LIMIT_REACHED: {
                    int maxHomesLimit = HomeSystem.getMaxHomes(player);
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYou've reached your home limit (" + maxHomesLimit + "). Delete an existing home before creating a new one.")));
                    int bonusHomes = HomeLuckPermsIntegration.getBonusHomes(player);
                    if (bonusHomes == 0) {
                        player.sendSystemMessage((Component)Component.literal((String)"\u00a7eGet bonus homes through donations to increase your limit."));
                    }
                    return 0;
                }
            }
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cFailed to set home due to an error."));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cThis command can only be executed by a player."));
            return 0;
        }
    }

    private static int deleteHome(CommandContext<CommandSourceStack> ctx, String homeName) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            if (!HomeSystem.getPlayerHomes(player).containsKey(homeName)) {
                if (homeName.equals("default")) {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7cYou don't have a default home to delete."));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYou don't have a home named \"" + homeName + "\".")));
                }
                return 0;
            }
            boolean success = HomeSystem.deleteHome(player, homeName);
            if (success) {
                if (homeName.equals("default")) {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7aDeleted your default home."));
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)("\u00a7aDeleted home \"" + homeName + "\".")));
                }
                Map<String, Home> allHomes = HomeSystem.getPlayerHomes(player);
                Map<String, Home> accessibleHomes = HomeSystem.getAccessibleHomes(player);
                if (allHomes.size() > accessibleHomes.size()) {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7eYou still have locked homes. Use \u00a76/homes\u00a7e to see which ones are now accessible."));
                }
                return 1;
            }
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cFailed to delete home."));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cThis command can only be executed by a player."));
            return 0;
        }
    }

    private static int clearHomes(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            int homeCount = HomeSystem.getHomeCount(player);
            if (homeCount == 0) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7cYou don't have any homes to clear."));
                return 0;
            }
            HomeSystem.clearPlayerHomes(player);
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7aAll " + homeCount + " home" + (homeCount != 1 ? "s have" : " has") + " been cleared.")));
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cThis command can only be executed by a player."));
            return 0;
        }
    }

    private static int showHomeInfo(CommandContext<CommandSourceStack> ctx, String homeName) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Home home = HomeSystem.getHome(player, homeName);
            if (home == null) {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7cYou don't have a home named \"" + homeName + "\".")));
                return 0;
            }
            boolean isAccessible = HomeSystem.isHomeAccessible(player, homeName);
            String accessStatus = home.isDisabled() ? "\u00a7cDisabled (bed destroyed)" : (isAccessible ? "\u00a7aAccessible" : "\u00a78Locked (exceeds limit)");
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7e--- \u00a76Home Info: " + homeName + " \u00a7e---")));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eLocation: \u00a7a" + home.getLocationString())));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eDimension: \u00a7a" + home.getDimensionDisplayName())));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eStatus: " + accessStatus)));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eCreated: \u00a7a" + String.valueOf(new Date(home.getCreatedTime())))));
            if (home.isBedBased()) {
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7eBed Location: \u00a7a" + home.getBedPosition().getX() + ", " + home.getBedPosition().getY() + ", " + home.getBedPosition().getZ())));
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7eBed-based: \u00a7cNo"));
            }
            if (home.isDisabled()) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7cThis home is disabled because its bed was destroyed."));
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7ePlace a bed at the original location to re-enable it."));
            } else if (!isAccessible) {
                int maxHomes;
                player.sendSystemMessage((Component)Component.literal((String)("\u00a78This home is locked because your limit only allows " + maxHomes + " home" + ((maxHomes = HomeSystem.getMaxHomes(player)) != 1 ? "s" : "") + ".")));
            }
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cThis command can only be executed by a player."));
            return 0;
        }
    }
}

