/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.moderation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import world.landfall.landfallessentials.moderation.ModerationManager;

public record ModListPacket(List<ModInfo> mods, List<ResourcePackInfo> resourcePacks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ModListPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"landfallessentials", (String)"mod_list"));
    public static final StreamCodec<FriendlyByteBuf, ModListPacket> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ModListPacket>(){

        public ModListPacket decode(FriendlyByteBuf buffer) {
            int modCount = buffer.readVarInt();
            ArrayList<ModInfo> mods = new ArrayList<ModInfo>();
            for (int i = 0; i < modCount; ++i) {
                mods.add((ModInfo)ModInfo.STREAM_CODEC.decode((Object)buffer));
            }
            int packCount = buffer.readVarInt();
            ArrayList<ResourcePackInfo> resourcePacks = new ArrayList<ResourcePackInfo>();
            for (int i = 0; i < packCount; ++i) {
                resourcePacks.add((ResourcePackInfo)ResourcePackInfo.STREAM_CODEC.decode((Object)buffer));
            }
            return new ModListPacket(mods, resourcePacks);
        }

        public void encode(FriendlyByteBuf buffer, ModListPacket packet) {
            buffer.writeVarInt(packet.mods().size());
            for (ModInfo mod : packet.mods()) {
                ModInfo.STREAM_CODEC.encode((Object)buffer, (Object)mod);
            }
            buffer.writeVarInt(packet.resourcePacks().size());
            for (ResourcePackInfo pack : packet.resourcePacks()) {
                ResourcePackInfo.STREAM_CODEC.encode((Object)buffer, (Object)pack);
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ModListPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player() != null) {
                ModerationManager.updatePlayerModData(context.player().getUUID(), packet.mods(), packet.resourcePacks());
            }
        });
    }

    public record ResourcePackInfo(String id, String title, String description, String source) {
        public static final StreamCodec<FriendlyByteBuf, ResourcePackInfo> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ResourcePackInfo>(){

            public ResourcePackInfo decode(FriendlyByteBuf buffer) {
                return new ResourcePackInfo(buffer.readUtf(), buffer.readUtf(), buffer.readUtf(), buffer.readUtf());
            }

            public void encode(FriendlyByteBuf buffer, ResourcePackInfo packInfo) {
                buffer.writeUtf(packInfo.id());
                buffer.writeUtf(packInfo.title());
                buffer.writeUtf(packInfo.description());
                buffer.writeUtf(packInfo.source());
            }
        };
    }

    public record ModInfo(String modId, String displayName, String version, String description) {
        public static final StreamCodec<FriendlyByteBuf, ModInfo> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ModInfo>(){

            public ModInfo decode(FriendlyByteBuf buffer) {
                return new ModInfo(buffer.readUtf(), buffer.readUtf(), buffer.readUtf(), buffer.readUtf());
            }

            public void encode(FriendlyByteBuf buffer, ModInfo modInfo) {
                buffer.writeUtf(modInfo.modId());
                buffer.writeUtf(modInfo.displayName());
                buffer.writeUtf(modInfo.version());
                buffer.writeUtf(modInfo.description());
            }
        };
    }
}

