/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionUtil.class);
    private static LuckPerms luckPerms = null;
    private static boolean luckPermsAvailable = false;
    private static boolean initialized = false;

    private static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (FMLEnvironment.dist.isClient()) {
            LOGGER.debug("Skipping LuckPerms initialization on client side");
            luckPermsAvailable = false;
            return;
        }
        try {
            luckPerms = LuckPermsProvider.get();
            luckPermsAvailable = true;
            LOGGER.info("LuckPerms integration enabled for region permissions");
        }
        catch (IllegalStateException e) {
            LOGGER.warn("LuckPerms not available - region permissions will be disabled");
            luckPermsAvailable = false;
        }
    }

    public static boolean hasPermission(ServerPlayer player, String permission) {
        if (!initialized) {
            PermissionUtil.initialize();
        }
        if (!luckPermsAvailable || permission == null || permission.isBlank()) {
            return true;
        }
        try {
            UUID playerUUID = player.getUUID();
            User user = luckPerms.getUserManager().getUser(playerUUID);
            if (user == null) {
                LOGGER.warn("Could not find LuckPerms user data for player {}", (Object)player.getName().getString());
                return true;
            }
            boolean hasPermission = user.getCachedData().getPermissionData().checkPermission(permission).asBoolean();
            LOGGER.debug("Permission check for player {} with permission '{}': {}", new Object[]{player.getName().getString(), permission, hasPermission});
            return hasPermission;
        }
        catch (Exception e) {
            LOGGER.error("Error checking permission '{}' for player {}: {}", new Object[]{permission, player.getName().getString(), e.getMessage()});
            return true;
        }
    }

    public static boolean isLuckPermsAvailable() {
        if (!initialized) {
            PermissionUtil.initialize();
        }
        return luckPermsAvailable;
    }
}

