/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import world.landfall.landfallessentials.item.custom.RegionWandItem;
import world.landfall.landfallessentials.regions.Cuboid;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionBlockManager;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.RegionRental;
import world.landfall.landfallessentials.regions.RegionVisualizerNew;
import world.landfall.landfallessentials.regions.RegionWandData;
import world.landfall.landfallessentials.regions.RentableVisualization;
import world.landfall.landfallessentials.registry.ModItems;

@EventBusSubscriber(modid="landfallessentials")
public class RegionCommands {
    private static final int PERMISSION_LEVEL = 2;
    private static final String SUCCESS = "\u00a7a";
    private static final String ERROR = "\u00a7c";
    private static final String INFO = "\u00a7b";
    private static final String HIGHLIGHT = "\u00a7e";
    private static final String SECONDARY = "\u00a77";
    private static final String RESET = "\u00a7r";

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder regionCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"region").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"new").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"corner1", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"corner2", (ArgumentType)BlockPosArgument.blockPos()).executes(RegionCommands::executeAddRegionCurrentDim)).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(RegionCommands::executeAddRegionSpecificDim))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionCommands::suggestRegionNames).executes(RegionCommands::executeRemoveRegion)))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(RegionCommands::executeListRegions)).then(Commands.literal((String)"all").executes(RegionCommands::executeListAllRegions)))).then(((LiteralArgumentBuilder)Commands.literal((String)"info").executes(RegionCommands::executeInfoTopLevel)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionCommands::suggestRegionNames).executes(RegionCommands::executeInfoRegion)))).then(((LiteralArgumentBuilder)Commands.literal((String)"debug").executes(RegionCommands::executeDebugSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionCommands::executeDebugPlayer)))).then(Commands.literal((String)"edit").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionCommands::suggestRegionNames).then(((LiteralArgumentBuilder)Commands.literal((String)"messages").then(((LiteralArgumentBuilder)Commands.literal((String)"entry").then(((LiteralArgumentBuilder)Commands.literal((String)"chat").executes(ctx -> RegionCommands.executeClearMessage((CommandContext<CommandSourceStack>)ctx, MessageType.ENTRY, MessageSubType.CHAT))).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> RegionCommands.executeSetMessage((CommandContext<CommandSourceStack>)ctx, MessageType.ENTRY, MessageSubType.CHAT))))).then(((LiteralArgumentBuilder)Commands.literal((String)"actionbar").executes(ctx -> RegionCommands.executeClearMessage((CommandContext<CommandSourceStack>)ctx, MessageType.ENTRY, MessageSubType.ACTIONBAR))).then(Commands.argument((String)"actionbar_message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> RegionCommands.executeSetMessage((CommandContext<CommandSourceStack>)ctx, MessageType.ENTRY, MessageSubType.ACTIONBAR)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"exit").then(((LiteralArgumentBuilder)Commands.literal((String)"chat").executes(ctx -> RegionCommands.executeClearMessage((CommandContext<CommandSourceStack>)ctx, MessageType.EXIT, MessageSubType.CHAT))).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> RegionCommands.executeSetMessage((CommandContext<CommandSourceStack>)ctx, MessageType.EXIT, MessageSubType.CHAT))))).then(((LiteralArgumentBuilder)Commands.literal((String)"actionbar").executes(ctx -> RegionCommands.executeClearMessage((CommandContext<CommandSourceStack>)ctx, MessageType.EXIT, MessageSubType.ACTIONBAR))).then(Commands.argument((String)"actionbar_message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> RegionCommands.executeSetMessage((CommandContext<CommandSourceStack>)ctx, MessageType.EXIT, MessageSubType.ACTIONBAR))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"sound").executes(RegionCommands::executeClearSound)).then(Commands.argument((String)"sound_id", (ArgumentType)ResourceLocationArgument.id()).then(((RequiredArgumentBuilder)Commands.argument((String)"loop_delay_ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> RegionCommands.executeSetSound((CommandContext<CommandSourceStack>)ctx, "ambient", 1.0f, 1.0f))).then(((RequiredArgumentBuilder)Commands.argument((String)"category", (ArgumentType)StringArgumentType.string()).suggests(RegionCommands::suggestSoundCategories).executes(ctx -> RegionCommands.executeSetSound((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"category"), 1.0f, 1.0f))).then(((RequiredArgumentBuilder)Commands.argument((String)"volume", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(ctx -> RegionCommands.executeSetSound((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"category"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"volume"), 1.0f))).then(Commands.argument((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(ctx -> RegionCommands.executeSetSound((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"category"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"volume"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"pitch")))))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"gamemode").then(((LiteralArgumentBuilder)Commands.literal((String)"entry").executes(ctx -> RegionCommands.executeClearGamemode((CommandContext<CommandSourceStack>)ctx, GamemodeType.ENTRY))).then(Commands.argument((String)"gamemode", (ArgumentType)StringArgumentType.string()).suggests(RegionCommands::suggestGamemodes).executes(ctx -> RegionCommands.executeSetGamemode((CommandContext<CommandSourceStack>)ctx, GamemodeType.ENTRY))))).then(((LiteralArgumentBuilder)Commands.literal((String)"exit").executes(ctx -> RegionCommands.executeClearGamemode((CommandContext<CommandSourceStack>)ctx, GamemodeType.EXIT))).then(Commands.argument((String)"gamemode", (ArgumentType)StringArgumentType.string()).suggests(RegionCommands::suggestGamemodes).executes(ctx -> RegionCommands.executeSetGamemode((CommandContext<CommandSourceStack>)ctx, GamemodeType.EXIT)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tag").then(Commands.literal((String)"add").then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).executes(RegionCommands::executeAddTag)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).suggests(RegionCommands::suggestRegionTags).executes(RegionCommands::executeRemoveTag)))).then(Commands.literal((String)"clear").executes(RegionCommands::executeClearTags))).then(Commands.literal((String)"list").executes(RegionCommands::executeListTags)))).then(Commands.literal((String)"permission").then(Commands.literal((String)"info").executes(RegionCommands::executePermissionInfo)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"query").then(Commands.literal((String)"tag").then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).suggests(RegionCommands::suggestAllTags).executes(RegionCommands::executeQueryTag)))).then(((LiteralArgumentBuilder)Commands.literal((String)"player").executes(RegionCommands::executeQueryPlayerSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionCommands::executeQueryPlayer))))).then(Commands.literal((String)"cuboid").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionCommands::suggestRegionNames).then(Commands.literal((String)"add").then(Commands.argument((String)"corner1", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"corner2", (ArgumentType)BlockPosArgument.blockPos()).executes(RegionCommands::executeAddCuboid))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(RegionCommands::executeRemoveCuboid)))).then(Commands.literal((String)"list").executes(RegionCommands::executeListCuboids))).then(Commands.literal((String)"info").then(Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(RegionCommands::executeCuboidInfo)))))).then(Commands.literal((String)"visualize").executes(RegionCommands::executeToggleVisualization))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wand").requires(source -> source.hasPermission(2))).executes(RegionCommands::executeGiveWand)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionCommands::executeGiveWandToPlayer))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mode").then(Commands.literal((String)"new_cuboid").executes(RegionCommands::executeSetWandModeNewCuboid))).then(Commands.literal((String)"new_region").executes(RegionCommands::executeSetWandModeNewRegion))).then(Commands.literal((String)"copy_paste").executes(RegionCommands::executeSetWandModeCopyPaste))).then(Commands.literal((String)"delete").executes(RegionCommands::executeSetWandModeDelete)))).then(Commands.literal((String)"clear").executes(RegionCommands::executeClearWandSelection)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"admin").requires(source -> source.hasPermission(2))).executes(RegionCommands::executeAdminToggleSelf)).then(((LiteralArgumentBuilder)Commands.literal((String)"toggle").executes(RegionCommands::executeAdminToggleSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionCommands::executeAdminTogglePlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"status").executes(RegionCommands::executeAdminStatus)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionCommands::executeAdminStatusPlayer)))).then(Commands.literal((String)"list").executes(RegionCommands::executeAdminList))).then(((LiteralArgumentBuilder)Commands.literal((String)"enable").executes(RegionCommands::executeAdminEnableSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionCommands::executeAdminEnablePlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"disable").executes(RegionCommands::executeAdminDisableSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionCommands::executeAdminDisablePlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"performance").executes(RegionCommands::executeAdminPerformanceAll)).then(Commands.argument((String)"region", (ArgumentType)StringArgumentType.string()).executes(RegionCommands::executeAdminPerformanceRegion))));
        dispatcher.register(regionCommand);
        LiteralArgumentBuilder rentCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rent").requires(source -> source.hasPermission(0))).executes(RegionCommands::executeRentCurrent)).then(Commands.argument((String)"weeks", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5)).executes(RegionCommands::executeRentWeeks))).then(Commands.literal((String)"trust").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionCommands::executeRentTrust)))).then(Commands.literal((String)"untrust").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionCommands::executeRentUntrust)))).then(Commands.literal((String)"visualize").executes(RegionCommands::executeRentVisualize))).then(((LiteralArgumentBuilder)Commands.literal((String)"admin").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"unrent").then(Commands.argument((String)"region", (ArgumentType)StringArgumentType.string()).suggests(RegionCommands::suggestRentedRegions).executes(RegionCommands::executeAdminUnrent))));
        dispatcher.register(rentCommand);
    }

    private static CompletableFuture<Suggestions> suggestRegionNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(RegionManager.getRegionNames(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestSoundCategories(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(Arrays.stream(SoundSource.values()).map(s -> s.name().toLowerCase()), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestGamemodes(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(Arrays.stream(GameType.values()).map(GameType::getName), (SuggestionsBuilder)builder);
    }

    private static int executeAddRegionCurrentDim(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionCommands.executeAddRegion(ctx, StringArgumentType.getString(ctx, (String)"name"), ((CommandSourceStack)ctx.getSource()).getLevel().dimension().location().toString(), BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner1"), BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner2"));
    }

    private static int executeAddRegionSpecificDim(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionCommands.executeAddRegion(ctx, StringArgumentType.getString(ctx, (String)"name"), DimensionArgument.getDimension(ctx, (String)"dimension").dimension().location().toString(), BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner1"), BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner2"));
    }

    private static int executeAddRegion(CommandContext<CommandSourceStack> ctx, String name, String dimension, BlockPos c1, BlockPos c2) {
        if (RegionManager.getRegion(name) != null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' already exists.")));
            return 0;
        }
        Region region = new Region(name, dimension, c1, c2);
        if (RegionManager.addRegion(region)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Added region '\u00a7e" + name + "\u00a7a' in \u00a7b" + dimension + "\u00a7a from \u00a77" + RegionCommands.formatPos(c1) + "\u00a7a to \u00a77" + RegionCommands.formatPos(c2))), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cFailed to add region '\u00a7e" + name + "\u00a7c'.")));
        return 0;
    }

    private static int executeRemoveRegion(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        if (RegionManager.removeRegion(name)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Removed region '\u00a7e" + name + "\u00a7a'.")), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
        return 0;
    }

    private static int executeListRegions(CommandContext<CommandSourceStack> ctx) {
        List<String> topLevelRegions = RegionManager.getTopLevelRegions();
        Set<String> allRegions = RegionManager.getRegionNames();
        if (allRegions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77No regions defined."), false);
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(INFO).append("=== Region Hierarchy ===").append("\n");
        sb.append(SECONDARY).append("Total regions: ").append(HIGHLIGHT).append(allRegions.size());
        sb.append(SECONDARY).append(" (Top-level: ").append(HIGHLIGHT).append(topLevelRegions.size()).append(SECONDARY).append(")\n\n");
        String tree = RegionManager.buildRegionTree(null, "", "", false);
        sb.append(tree);
        if (allRegions.size() > topLevelRegions.size()) {
            sb.append("\n").append(SECONDARY).append("Use ").append(INFO).append("/region list all").append(SECONDARY).append(" to see all regions in a flat list");
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)sb.toString()), false);
        return topLevelRegions.size();
    }

    private static int executeListAllRegions(CommandContext<CommandSourceStack> ctx) {
        Set<String> regionNames = RegionManager.getRegionNames();
        if (regionNames.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77No regions defined."), false);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(INFO).append("All regions (").append(HIGHLIGHT).append(regionNames.size()).append(INFO).append("): ");
            boolean first = true;
            for (String name : regionNames) {
                if (!first) {
                    sb.append(SECONDARY).append(", ");
                }
                sb.append(HIGHLIGHT).append(name);
                first = false;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)sb.toString()), false);
        }
        return regionNames.size();
    }

    private static int executeInfoTopLevel(CommandContext<CommandSourceStack> ctx) {
        String[] lines;
        List<String> topLevelRegions = RegionManager.getTopLevelRegions();
        if (topLevelRegions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77No regions defined."), false);
            return 0;
        }
        StringBuilder info = new StringBuilder();
        info.append(INFO).append("=== Top-Level Regions ===").append("\n\n");
        for (String regionName : topLevelRegions) {
            String[] region = RegionManager.getRegion(regionName);
            if (region == null) continue;
            List<String> children = RegionManager.getChildRegions(regionName);
            info.append(HIGHLIGHT).append("[" + regionName + "]");
            info.append(" \u00a77(" + region.getVolume() + " blocks");
            if (!children.isEmpty()) {
                info.append(", " + children.size() + " subregions");
            }
            info.append(")\n");
            if (region.hasTags()) {
                info.append("  ").append(SECONDARY).append("Tags: ").append(String.join((CharSequence)", ", region.getTags())).append("\n");
            }
            info.append("\n");
        }
        info.append(SECONDARY).append("Click a region name or use ").append(INFO).append("/region info <name>").append(SECONDARY).append(" for details and subregions");
        MutableComponent message = Component.empty();
        for (String line : lines = info.toString().split("\n")) {
            if (line.contains("[") && line.contains("]")) {
                int start = line.indexOf("[");
                int end = line.indexOf("]");
                if (start >= 0 && end > start) {
                    String regionName = line.substring(start + 1, end);
                    String beforeBracket = line.substring(0, start);
                    String afterBracket = line.substring(end + 1);
                    message = message.append((Component)Component.literal((String)beforeBracket)).append((Component)Component.literal((String)("[" + regionName + "]")).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/region info " + regionName)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to view details for " + regionName)))))).append((Component)Component.literal((String)(afterBracket + "\n")));
                    continue;
                }
                message = message.append((Component)Component.literal((String)(line + "\n")));
                continue;
            }
            message = message.append((Component)Component.literal((String)(line + "\n")));
        }
        MutableComponent finalMessage = message;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> RegionCommands.lambda$executeInfoTopLevel$30((Component)finalMessage), false);
        return topLevelRegions.size();
    }

    private static int executeInfoRegion(CommandContext<CommandSourceStack> ctx) {
        String[] lines;
        List<String> children;
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        StringBuilder info = new StringBuilder();
        info.append(INFO).append("=== Region Info: ").append(HIGHLIGHT).append(name).append(INFO).append(" ===\n");
        String parent = RegionManager.getParentRegion(name);
        if (parent != null) {
            info.append(INFO).append("Parent Region: ").append(HIGHLIGHT).append(parent).append("\n");
        }
        info.append(INFO).append("Dimension: ").append(SECONDARY).append(region.getDimension()).append("\n");
        info.append(INFO).append("Cuboids: ").append(HIGHLIGHT).append(region.getCuboidCount()).append("\n");
        info.append(INFO).append("Overall bounds: ").append(SECONDARY).append(RegionCommands.formatPos(new BlockPos(region.getMinX(), region.getMinY(), region.getMinZ()))).append(" to ").append(RegionCommands.formatPos(new BlockPos(region.getMaxX(), region.getMaxY(), region.getMaxZ()))).append("\n");
        info.append(INFO).append("Volume: ").append(HIGHLIGHT).append(region.getVolume()).append(INFO).append(" blocks\n");
        Set<String> tags = region.getTags();
        if (!tags.isEmpty()) {
            info.append(INFO).append("Tags: ");
            boolean first = true;
            for (String tag : tags) {
                if (!first) {
                    info.append(", ");
                }
                if (tag.equals("explosion-protect")) {
                    info.append(ERROR).append(tag).append(INFO).append(" (inherited by subregions)");
                } else {
                    info.append(HIGHLIGHT).append(tag);
                }
                first = false;
            }
            info.append("\n");
        } else {
            info.append(SECONDARY).append("No tags\n");
        }
        if (region.hasAccessDeniedMessage()) {
            info.append(INFO).append("Access Denied Message: ").append(SECONDARY).append(region.getAccessDeniedMessage()).append("\n");
        }
        if (region.hasEntryMessage()) {
            info.append(INFO).append("Entry Message: ").append(SECONDARY).append(region.getEntryMessage()).append("\n");
        }
        if (region.hasExitMessage()) {
            info.append(INFO).append("Exit Message: ").append(SECONDARY).append(region.getExitMessage()).append("\n");
        }
        if (region.hasSound()) {
            info.append(INFO).append("Sound: ").append(SECONDARY).append(region.getSoundEventId()).append(" (").append(region.getSoundLoopDelayTicks()).append(" tick loop)\n");
        }
        if (region.hasGamemodeOnEntry()) {
            info.append(INFO).append("Entry Gamemode: ").append(HIGHLIGHT).append(region.getGamemodeOnEntry()).append("\n");
        }
        if (region.hasGamemodeOnExit()) {
            info.append(INFO).append("Exit Gamemode: ").append(HIGHLIGHT).append(region.getGamemodeOnExit()).append("\n");
        }
        if (!(children = RegionManager.getChildRegions(name)).isEmpty()) {
            info.append("\n").append(INFO).append("=== Subregions ===").append("\n");
            String tree = RegionManager.buildRegionTree(name, "", "", true);
            String[] treeLines = tree.split("\n");
            for (int i = 1; i < treeLines.length; ++i) {
                info.append(treeLines[i]).append("\n");
            }
        }
        MutableComponent message = Component.empty();
        for (String line : lines = info.toString().split("\n")) {
            if (line.contains("\u251c\u2500") || line.contains("\u2514\u2500") || line.contains("\u2502")) {
                int nameStart = line.indexOf(HIGHLIGHT);
                if (nameStart >= 0) {
                    int nameEnd = line.indexOf(" ", nameStart += 2);
                    if (nameEnd > nameStart) {
                        String childName = line.substring(nameStart, nameEnd);
                        String beforeName = line.substring(0, nameStart - 2);
                        String afterName = line.substring(nameEnd);
                        message = message.append((Component)Component.literal((String)beforeName)).append((Component)Component.literal((String)(HIGHLIGHT + childName)).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/region info " + childName)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to view details for " + childName)))))).append((Component)Component.literal((String)(afterName + "\n")));
                        continue;
                    }
                    message = message.append((Component)Component.literal((String)(line + "\n")));
                    continue;
                }
                message = message.append((Component)Component.literal((String)(line + "\n")));
                continue;
            }
            message = message.append((Component)Component.literal((String)(line + "\n")));
        }
        MutableComponent finalMessage = message;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> RegionCommands.lambda$executeInfoRegion$32((Component)finalMessage), false);
        return 1;
    }

    private static int executeSetMessage(CommandContext<CommandSourceStack> ctx, MessageType type, MessageSubType subType) throws CommandSyntaxException {
        return RegionCommands.executeSetMessage(ctx, type, subType, 0);
    }

    private static int executeSetMessage(CommandContext<CommandSourceStack> ctx, MessageType type, MessageSubType subType, int loopDelayTicks) throws CommandSyntaxException {
        String successMessage;
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        block0 : switch (type.ordinal()) {
            case 0: {
                switch (subType.ordinal()) {
                    case 0: {
                        String content = StringArgumentType.getString(ctx, (String)"message");
                        region.setEntryMessage(content);
                        successMessage = "Set entry chat message for region '" + name + "'.";
                        break block0;
                    }
                    case 1: {
                        String content = StringArgumentType.getString(ctx, (String)"actionbar_message");
                        region.setEntryActionbarMessage(content);
                        successMessage = "Set entry actionbar message for region '" + name + "'.";
                        break block0;
                    }
                }
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cUnknown entry message subtype."));
                return 0;
            }
            case 1: {
                switch (subType.ordinal()) {
                    case 0: {
                        String content = StringArgumentType.getString(ctx, (String)"message");
                        region.setExitMessage(content);
                        successMessage = "Set exit chat message for region '" + name + "'.";
                        break block0;
                    }
                    case 1: {
                        String content = StringArgumentType.getString(ctx, (String)"actionbar_message");
                        region.setExitActionbarMessage(content);
                        successMessage = "Set exit actionbar message for region '" + name + "'.";
                        break block0;
                    }
                }
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cUnknown exit message subtype."));
                return 0;
            }
            default: {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cUnknown message type."));
                return 0;
            }
        }
        RegionManager.saveRegions();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 " + successMessage)), true);
        return 1;
    }

    private static int executeClearMessage(CommandContext<CommandSourceStack> ctx, MessageType type, MessageSubType subType) throws CommandSyntaxException {
        String successMessage;
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        block0 : switch (type.ordinal()) {
            case 0: {
                switch (subType.ordinal()) {
                    case 0: {
                        region.clearEntryMessage();
                        successMessage = "Cleared entry chat message for region '" + name + "'.";
                        break block0;
                    }
                    case 1: {
                        region.clearEntryActionbarMessage();
                        successMessage = "Cleared entry actionbar message for region '" + name + "'.";
                        break block0;
                    }
                }
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cUnknown entry message subtype."));
                return 0;
            }
            case 1: {
                switch (subType.ordinal()) {
                    case 0: {
                        region.clearExitMessage();
                        successMessage = "Cleared exit chat message for region '" + name + "'.";
                        break block0;
                    }
                    case 1: {
                        region.clearExitActionbarMessage();
                        successMessage = "Cleared exit actionbar message for region '" + name + "'.";
                        break block0;
                    }
                }
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cUnknown exit message subtype."));
                return 0;
            }
            default: {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cUnknown message type."));
                return 0;
            }
        }
        RegionManager.saveRegions();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 " + successMessage)), true);
        return 1;
    }

    private static int executeSetSound(CommandContext<CommandSourceStack> ctx, String category, float volume, float pitch) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        ResourceLocation soundId = ResourceLocationArgument.getId(ctx, (String)"sound_id");
        int loopDelay = IntegerArgumentType.getInteger(ctx, (String)"loop_delay_ticks");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        region.setSound(soundId.toString(), category, volume, pitch, loopDelay);
        RegionManager.saveRegions();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Set sound for region '\u00a7e" + name + "\u00a7a': \u00a7b" + String.valueOf(soundId) + "\u00a7a (loop: \u00a7e" + loopDelay + "\u00a7a ticks, category: \u00a7e" + category + "\u00a7a, volume: \u00a7e" + volume + "\u00a7a, pitch: \u00a7e" + pitch + "\u00a7a)")), true);
        return 1;
    }

    private static int executeClearSound(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        region.clearSound();
        RegionManager.saveRegions();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Cleared sound for region '\u00a7e" + name + "\u00a7a'.")), true);
        return 1;
    }

    private static int executeSetGamemode(CommandContext<CommandSourceStack> ctx, GamemodeType type) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        String gamemode = StringArgumentType.getString(ctx, (String)"gamemode");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        try {
            GameType.byName((String)gamemode.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cInvalid gamemode: \u00a7e" + gamemode + "\u00a7c. Valid options: \u00a77survival, creative, adventure, spectator")));
            return 0;
        }
        switch (type.ordinal()) {
            case 0: {
                region.setGamemodeOnEntry(gamemode.toLowerCase());
                break;
            }
            case 1: {
                region.setGamemodeOnExit(gamemode.toLowerCase());
            }
        }
        RegionManager.saveRegions();
        String typeStr = type.name().toLowerCase();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Set " + typeStr + " gamemode for region '\u00a7e" + name + "\u00a7a' to \u00a7e" + gamemode.toLowerCase() + "\u00a7a.")), true);
        return 1;
    }

    private static int executeClearGamemode(CommandContext<CommandSourceStack> ctx, GamemodeType type) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        switch (type.ordinal()) {
            case 0: {
                region.setGamemodeOnEntry(null);
                break;
            }
            case 1: {
                region.setGamemodeOnExit(null);
            }
        }
        RegionManager.saveRegions();
        String typeStr = type.name().toLowerCase();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Cleared " + typeStr + " gamemode for region '\u00a7e" + name + "\u00a7a'.")), true);
        return 1;
    }

    private static int executeDebugSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)ctx.getSource()).getEntity();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cThis command can only be used by players."));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        return RegionCommands.executeDebugForPlayer(ctx, player);
    }

    private static int executeDebugPlayer(CommandContext<CommandSourceStack> ctx) {
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer player = server.getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cPlayer '\u00a7e" + playerName + "\u00a7c' not found.")));
            return 0;
        }
        return RegionCommands.executeDebugForPlayer(ctx, player);
    }

    private static int executeDebugForPlayer(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        String playerUUID = player.getUUID().toString();
        String regionInfo = RegionManager.getPlayerRegionInfo(playerUUID);
        BlockPos pos = player.blockPosition();
        Set<String> regions = RegionManager.getPlayerRegions(playerUUID);
        StringBuilder debug = new StringBuilder();
        debug.append(INFO).append("=== Debug Info for ").append(HIGHLIGHT).append(player.getName().getString()).append(INFO).append(" ===\n");
        debug.append(INFO).append("Position: ").append(SECONDARY).append(RegionCommands.formatPos(pos)).append("\n");
        debug.append(INFO).append("Dimension: ").append(SECONDARY).append(player.level().dimension().location()).append("\n");
        boolean hasAdminBypass = RegionManager.hasAdminBypass(playerUUID);
        if (hasAdminBypass) {
            debug.append(INFO).append("Admin Bypass: ").append(HIGHLIGHT).append("ENABLED").append("\n\n");
        } else {
            debug.append(INFO).append("Admin Bypass: ").append(ERROR).append("DISABLED").append("\n\n");
        }
        debug.append(SECONDARY).append(regionInfo);
        if (!regions.isEmpty()) {
            String[] permissionTags;
            debug.append("\n\n").append(INFO).append("Block Permissions at current position:\n");
            boolean canBuild = RegionBlockManager.canModifyBlock(player, pos, "build");
            boolean canInteract = RegionBlockManager.canInteractWithBlock(player, pos);
            debug.append("  ").append(HIGHLIGHT).append("build").append(INFO).append(": ").append(canBuild ? "\u00a7a\u2713 ALLOWED" : "\u00a7c\u2717 DENIED").append("\n");
            debug.append("  ").append(HIGHLIGHT).append("interact").append(INFO).append(": ").append(canInteract ? "\u00a7a\u2713 ALLOWED" : "\u00a7c\u2717 DENIED").append("\n");
            debug.append("\n").append(INFO).append("Active permission tags:\n");
            for (String tag : permissionTags = RegionBlockManager.getRequiredTags()) {
                boolean hasTag = false;
                for (String regionName : regions) {
                    if (!RegionManager.regionHasTag(regionName, tag)) continue;
                    hasTag = true;
                    break;
                }
                debug.append("  ").append(HIGHLIGHT).append(tag).append(INFO).append(": ").append(hasTag ? "\u00a7a\u2713 ACTIVE" : "\u00a77\u25cb INACTIVE").append("\n");
            }
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)debug.toString()), false);
        return 1;
    }

    private static String formatPos(BlockPos pos) {
        return pos.getX() + "," + pos.getY() + "," + pos.getZ();
    }

    private static CompletableFuture<Suggestions> suggestRegionTags(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        try {
            String regionName = StringArgumentType.getString(context, (String)"name");
            Set<String> tags = RegionManager.getRegionTags(regionName);
            return SharedSuggestionProvider.suggest(tags, (SuggestionsBuilder)builder);
        }
        catch (Exception e) {
            return SharedSuggestionProvider.suggest(Collections.emptyList(), (SuggestionsBuilder)builder);
        }
    }

    private static CompletableFuture<Suggestions> suggestAllTags(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Set<String> allTags = RegionManager.getAllTags();
        return SharedSuggestionProvider.suggest(allTags, (SuggestionsBuilder)builder);
    }

    private static int executeAddTag(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String regionName = StringArgumentType.getString(ctx, (String)"name");
        String tag = StringArgumentType.getString(ctx, (String)"tag");
        Region region = RegionManager.getRegion(regionName);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + regionName + "\u00a7c' not found.")));
            return 0;
        }
        if (RegionManager.addTagToRegion(regionName, tag)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Added tag '\u00a7e" + tag + "\u00a7a' to region '\u00a7e" + regionName + "\u00a7a'.")), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cTag '\u00a7e" + tag + "\u00a7c' already exists on region '\u00a7e" + regionName + "\u00a7c' or is invalid.")));
        return 0;
    }

    private static int executeRemoveTag(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String regionName = StringArgumentType.getString(ctx, (String)"name");
        String tag = StringArgumentType.getString(ctx, (String)"tag");
        Region region = RegionManager.getRegion(regionName);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + regionName + "\u00a7c' not found.")));
            return 0;
        }
        if (RegionManager.removeTagFromRegion(regionName, tag)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Removed tag '\u00a7e" + tag + "\u00a7a' from region '\u00a7e" + regionName + "\u00a7a'.")), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cTag '\u00a7e" + tag + "\u00a7c' not found on region '\u00a7e" + regionName + "\u00a7c'.")));
        return 0;
    }

    private static int executeClearTags(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String regionName = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionManager.getRegion(regionName);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + regionName + "\u00a7c' not found.")));
            return 0;
        }
        if (RegionManager.clearRegionTags(regionName)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Cleared all tags from region '\u00a7e" + regionName + "\u00a7a'.")), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a77Region '\u00a7e" + regionName + "\u00a77' has no tags to clear.")), false);
        return 1;
    }

    private static int executeListTags(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String regionName = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionManager.getRegion(regionName);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + regionName + "\u00a7c' not found.")));
            return 0;
        }
        Set<String> tags = region.getTags();
        if (tags.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a77Region '\u00a7e" + regionName + "\u00a77' has no tags.")), false);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(INFO).append("Tags for region '").append(HIGHLIGHT).append(regionName).append(INFO).append("' (").append(HIGHLIGHT).append(tags.size()).append(INFO).append("): ");
            boolean first = true;
            for (String tag : tags) {
                if (!first) {
                    sb.append(SECONDARY).append(", ");
                }
                sb.append(HIGHLIGHT).append(tag);
                first = false;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)sb.toString()), false);
        }
        return tags.size();
    }

    private static int executeQueryTag(CommandContext<CommandSourceStack> ctx) {
        String tag = StringArgumentType.getString(ctx, (String)"tag");
        List<String> regions = RegionManager.getRegionsWithTag(tag);
        if (regions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a77No regions found with tag '\u00a7e" + tag + "\u00a77'.")), false);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(INFO).append("Regions with tag '").append(HIGHLIGHT).append(tag).append(INFO).append("' (").append(HIGHLIGHT).append(regions.size()).append(INFO).append("): ");
            boolean first = true;
            for (String regionName : regions) {
                if (!first) {
                    sb.append(SECONDARY).append(", ");
                }
                sb.append(HIGHLIGHT).append(regionName);
                first = false;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)sb.toString()), false);
        }
        return regions.size();
    }

    private static int executeQueryPlayerSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        return RegionCommands.executeQueryForPlayer(ctx, player);
    }

    private static int executeQueryPlayer(CommandContext<CommandSourceStack> ctx) {
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer player = server.getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cPlayer '\u00a7e" + playerName + "\u00a7c' not found or not online.")));
            return 0;
        }
        return RegionCommands.executeQueryForPlayer(ctx, player);
    }

    private static int executeQueryForPlayer(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        Set<String> playerRegions = RegionManager.getPlayerRegions(player.getUUID().toString());
        Set<String> playerTags = RegionManager.getPlayerRegionTags((Player)player);
        StringBuilder info = new StringBuilder();
        info.append(INFO).append("=== Player Region Info: ").append(HIGHLIGHT).append(player.getName().getString()).append(INFO).append(" ===\n");
        if (playerRegions.isEmpty()) {
            info.append(SECONDARY).append("Player is not in any regions.");
        } else {
            info.append(INFO).append("Current regions (").append(HIGHLIGHT).append(playerRegions.size()).append(INFO).append("): ");
            boolean first = true;
            for (String regionName : playerRegions) {
                if (!first) {
                    info.append(SECONDARY).append(", ");
                }
                info.append(HIGHLIGHT).append(regionName);
                first = false;
            }
            info.append("\n");
            if (playerTags.isEmpty()) {
                info.append(SECONDARY).append("No tags from current regions.");
            } else {
                info.append(INFO).append("Active tags (").append(HIGHLIGHT).append(playerTags.size()).append(INFO).append("): ");
                first = true;
                for (String tag : playerTags) {
                    if (!first) {
                        info.append(SECONDARY).append(", ");
                    }
                    info.append(HIGHLIGHT).append(tag);
                    first = false;
                }
            }
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)info.toString()), false);
        return 1;
    }

    private static int executeAddCuboid(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos corner2;
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        BlockPos corner1 = BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner1");
        Cuboid newCuboid = new Cuboid(corner1, corner2 = BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner2"));
        if (region.addCuboid(newCuboid)) {
            RegionManager.saveRegions();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Added cuboid to region '\u00a7e" + name + "\u00a7a' from \u00a77" + RegionCommands.formatPos(corner1) + "\u00a7a to \u00a77" + RegionCommands.formatPos(corner2) + "\u00a7a. Region now has \u00a7e" + region.getCuboidCount() + "\u00a7a cuboid(s).")), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cFailed to add cuboid to region '\u00a7e" + name + "\u00a7c'. Cuboid may already exist.")));
        return 0;
    }

    private static int executeRemoveCuboid(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        int index = IntegerArgumentType.getInteger(ctx, (String)"index");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        if (region.removeCuboid(index)) {
            RegionManager.saveRegions();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Removed cuboid \u00a7e" + index + "\u00a7a from region '\u00a7e" + name + "\u00a7a'. Region now has \u00a7e" + region.getCuboidCount() + "\u00a7a cuboid(s).")), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cFailed to remove cuboid \u00a7e" + index + "\u00a7c from region '\u00a7e" + name + "\u00a7c'. Invalid index or cannot remove the last cuboid.")));
        return 0;
    }

    private static int executeListCuboids(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        List<Cuboid> cuboids = region.getCuboids();
        StringBuilder info = new StringBuilder();
        info.append(INFO).append("=== Cuboids for Region: ").append(HIGHLIGHT).append(name).append(INFO).append(" ===\n");
        info.append(INFO).append("Total cuboids: ").append(HIGHLIGHT).append(cuboids.size()).append("\n");
        for (int i = 0; i < cuboids.size(); ++i) {
            Cuboid cuboid = cuboids.get(i);
            info.append(INFO).append("[").append(HIGHLIGHT).append(i).append(INFO).append("] ").append(SECONDARY).append(cuboid.toDisplayString()).append(INFO).append(" (").append(HIGHLIGHT).append(cuboid.getVolume()).append(INFO).append(" blocks)\n");
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)info.toString()), false);
        return cuboids.size();
    }

    private static int executeCuboidInfo(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        int index = IntegerArgumentType.getInteger(ctx, (String)"index");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        Cuboid cuboid = region.getCuboid(index);
        if (cuboid == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cCuboid \u00a7e" + index + "\u00a7c not found in region '\u00a7e" + name + "\u00a7c'.")));
            return 0;
        }
        StringBuilder info = new StringBuilder();
        info.append(INFO).append("=== Cuboid Info: ").append(HIGHLIGHT).append(name).append(INFO).append("[").append(HIGHLIGHT).append(index).append(INFO).append("] ===\n");
        info.append(INFO).append("Bounds: ").append(SECONDARY).append(cuboid.toDisplayString()).append("\n");
        info.append(INFO).append("Volume: ").append(HIGHLIGHT).append(cuboid.getVolume()).append(INFO).append(" blocks\n");
        info.append(INFO).append("Min corner: ").append(SECONDARY).append(RegionCommands.formatPos(cuboid.getMinCorner())).append("\n");
        info.append(INFO).append("Max corner: ").append(SECONDARY).append(RegionCommands.formatPos(cuboid.getMaxCorner()));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)info.toString()), false);
        return 1;
    }

    private static int executeToggleVisualization(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        boolean enabled = RegionVisualizerNew.toggleVisualization(player);
        return enabled ? 1 : 0;
    }

    private static int executePermissionInfo(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String[] tags;
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + name + "\u00a7c' not found.")));
            return 0;
        }
        StringBuilder info = new StringBuilder();
        info.append(INFO).append("=== Block Permissions for Region: ").append(HIGHLIGHT).append(name).append(INFO).append(" ===\n");
        info.append(INFO).append("Available permission tags:\n");
        for (String tag : tags = RegionBlockManager.getRequiredTags()) {
            boolean hasTag = RegionManager.regionHasTag(name, tag);
            String status = hasTag ? "\u00a7a\u2713 ENABLED" : "\u00a7c\u2717 DISABLED";
            info.append("  ").append(HIGHLIGHT).append(tag).append(INFO).append(": ").append(status).append(INFO).append(" - ").append(SECONDARY).append(RegionBlockManager.getTagDescription(tag)).append("\n");
        }
        info.append("\n").append(INFO).append("To enable: ").append(SECONDARY).append("/region edit ").append(name).append(" tag add <tag>");
        info.append("\n").append(INFO).append("To disable: ").append(SECONDARY).append("/region edit ").append(name).append(" tag remove <tag>");
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)info.toString()), false);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestRentableRegions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List rentableRegions = RegionManager.getAllRegions().entrySet().stream().filter(entry -> RegionRental.isRentable((String)entry.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
        return SharedSuggestionProvider.suggest(rentableRegions, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestRentedRegions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        List<String> rentedRegions = RegionRental.getAllRentedRegions();
        return SharedSuggestionProvider.suggest(rentedRegions, (SuggestionsBuilder)builder);
    }

    private static int executeRentCurrent(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        Set<String> currentRegions = RegionManager.getPlayerRegions(player.getUUID().toString());
        if (currentRegions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cYou are not in any region."));
            return 0;
        }
        String rentableRegion = null;
        for (String regionName : currentRegions) {
            if (!RegionRental.isRentable(regionName)) continue;
            rentableRegion = regionName;
            break;
        }
        if (rentableRegion == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cNo rentable regions found in your current location."));
            return 0;
        }
        return RegionCommands.executeRentRegionInternal(ctx, rentableRegion, 1);
    }

    private static int executeRentWeeks(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        int weeks = IntegerArgumentType.getInteger(ctx, (String)"weeks");
        Set<String> currentRegions = RegionManager.getPlayerRegions(player.getUUID().toString());
        if (currentRegions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cYou are not in any region."));
            return 0;
        }
        String rentableRegion = null;
        for (String regionName : currentRegions) {
            if (!RegionRental.isRentable(regionName)) continue;
            rentableRegion = regionName;
            break;
        }
        if (rentableRegion == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cNo rentable regions found in your current location."));
            return 0;
        }
        return RegionCommands.executeRentRegionInternal(ctx, rentableRegion, weeks);
    }

    private static int executeRentTrust(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        String targetPlayerName = StringArgumentType.getString(ctx, (String)"player");
        Set<String> currentRegions = RegionManager.getPlayerRegions(player.getUUID().toString());
        if (currentRegions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cYou are not in any region."));
            return 0;
        }
        String ownedRegion = null;
        for (String regionName : currentRegions) {
            if (!RegionRental.isOwner(regionName, player.getUUID())) continue;
            ownedRegion = regionName;
            break;
        }
        if (ownedRegion == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cYou don't own any rented regions in your current location."));
            return 0;
        }
        RegionRental.TrustResult result = RegionRental.trustPlayer(ownedRegion, player.getUUID(), targetPlayerName);
        if (result.isSuccess()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(SUCCESS + result.getMessage())), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)(ERROR + result.getMessage())));
        return 0;
    }

    private static int executeRentUntrust(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        String targetPlayerName = StringArgumentType.getString(ctx, (String)"player");
        Set<String> currentRegions = RegionManager.getPlayerRegions(player.getUUID().toString());
        if (currentRegions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cYou are not in any region."));
            return 0;
        }
        String ownedRegion = null;
        for (String regionName : currentRegions) {
            if (!RegionRental.isOwner(regionName, player.getUUID())) continue;
            ownedRegion = regionName;
            break;
        }
        if (ownedRegion == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cYou don't own any rented regions in your current location."));
            return 0;
        }
        RegionRental.TrustResult result = RegionRental.untrustPlayer(ownedRegion, player.getUUID(), targetPlayerName);
        if (result.isSuccess()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(SUCCESS + result.getMessage())), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)(ERROR + result.getMessage())));
        return 0;
    }

    private static int executeAdminUnrent(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String regionName = StringArgumentType.getString(ctx, (String)"region");
        RegionRental.AdminResult result = RegionRental.adminUnrentRegion(regionName);
        if (result.isSuccess()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(SUCCESS + result.getMessage())), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)(ERROR + result.getMessage())));
        return 0;
    }

    private static int executeRentVisualize(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        boolean enabled = RentableVisualization.toggleRentableVisualization(player);
        return enabled ? 1 : 0;
    }

    private static int executeRentRegionInternal(CommandContext<CommandSourceStack> ctx, String regionName, int weeks) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        RegionRental.RentResult result = RegionRental.rentRegion(regionName, player, weeks);
        if (result.isSuccess()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(SUCCESS + result.getMessage())), true);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)(ERROR + result.getMessage())));
        return 0;
    }

    private static int executeAdminToggleSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        String playerUUID = player.getUUID().toString();
        boolean enabled = RegionManager.toggleAdminBypass(playerUUID);
        if (enabled) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7a\u2713 Admin bypass mode \u00a7eENABLED"), true);
            player.displayClientMessage((Component)Component.literal((String)"\u00a76[ADMIN BYPASS MODE ACTIVE]"), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7a\u2713 Admin bypass mode \u00a7cDISABLED"), true);
            player.displayClientMessage((Component)Component.literal((String)"\u00a7aAdmin bypass mode disabled"), true);
        }
        return 1;
    }

    private static int executeAdminTogglePlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetName);
        if (targetPlayer == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cPlayer '\u00a7e" + targetName + "\u00a7c' not found.")));
            return 0;
        }
        String targetUUID = targetPlayer.getUUID().toString();
        boolean enabled = RegionManager.toggleAdminBypass(targetUUID);
        if (enabled) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Admin bypass mode \u00a7eENABLED\u00a7a for \u00a7e" + targetName)), true);
            targetPlayer.displayClientMessage((Component)Component.literal((String)("\u00a76[ADMIN BYPASS MODE ACTIVE] - Granted by " + ((CommandSourceStack)ctx.getSource()).getTextName())), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Admin bypass mode \u00a7cDISABLED\u00a7a for \u00a7e" + targetName)), true);
            targetPlayer.displayClientMessage((Component)Component.literal((String)("\u00a7cAdmin bypass mode disabled by " + ((CommandSourceStack)ctx.getSource()).getTextName())), false);
        }
        return 1;
    }

    private static int executeAdminEnableSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        String playerUUID = player.getUUID().toString();
        if (RegionManager.hasAdminBypass(playerUUID)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7bAdmin bypass mode is already enabled."), false);
        } else {
            RegionManager.enableAdminBypass(playerUUID);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7a\u2713 Admin bypass mode \u00a7eENABLED"), true);
            player.displayClientMessage((Component)Component.literal((String)"\u00a76[ADMIN BYPASS MODE ACTIVE]"), true);
        }
        return 1;
    }

    private static int executeAdminEnablePlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetName);
        if (targetPlayer == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cPlayer '\u00a7e" + targetName + "\u00a7c' not found.")));
            return 0;
        }
        String targetUUID = targetPlayer.getUUID().toString();
        if (RegionManager.hasAdminBypass(targetUUID)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7bAdmin bypass mode is already enabled for \u00a7e" + targetName)), false);
        } else {
            RegionManager.enableAdminBypass(targetUUID);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Admin bypass mode \u00a7eENABLED\u00a7a for \u00a7e" + targetName)), true);
            targetPlayer.displayClientMessage((Component)Component.literal((String)("\u00a76[ADMIN BYPASS MODE ACTIVE] - Granted by " + ((CommandSourceStack)ctx.getSource()).getTextName())), false);
        }
        return 1;
    }

    private static int executeAdminDisableSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        String playerUUID = player.getUUID().toString();
        if (!RegionManager.hasAdminBypass(playerUUID)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7bAdmin bypass mode is already disabled."), false);
        } else {
            RegionManager.disableAdminBypass(playerUUID);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7a\u2713 Admin bypass mode \u00a7cDISABLED"), true);
            player.displayClientMessage((Component)Component.literal((String)"\u00a7aAdmin bypass mode disabled"), true);
        }
        return 1;
    }

    private static int executeAdminDisablePlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetName);
        if (targetPlayer == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cPlayer '\u00a7e" + targetName + "\u00a7c' not found.")));
            return 0;
        }
        String targetUUID = targetPlayer.getUUID().toString();
        if (!RegionManager.hasAdminBypass(targetUUID)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7bAdmin bypass mode is already disabled for \u00a7e" + targetName)), false);
        } else {
            RegionManager.disableAdminBypass(targetUUID);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Admin bypass mode \u00a7cDISABLED\u00a7a for \u00a7e" + targetName)), true);
            targetPlayer.displayClientMessage((Component)Component.literal((String)("\u00a7cAdmin bypass mode disabled by " + ((CommandSourceStack)ctx.getSource()).getTextName())), false);
        }
        return 1;
    }

    private static int executeAdminStatus(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        String playerUUID = player.getUUID().toString();
        boolean hasBypass = RegionManager.hasAdminBypass(playerUUID);
        if (hasBypass) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7bYour admin bypass mode is: \u00a7eENABLED"), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7bYour admin bypass mode is: \u00a7cDISABLED"), false);
        }
        return 1;
    }

    private static int executeAdminStatusPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetName);
        if (targetPlayer == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cPlayer '\u00a7e" + targetName + "\u00a7c' not found.")));
            return 0;
        }
        String targetUUID = targetPlayer.getUUID().toString();
        boolean hasBypass = RegionManager.hasAdminBypass(targetUUID);
        if (hasBypass) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7bAdmin bypass mode for \u00a7e" + targetName + "\u00a7b is: \u00a7eENABLED")), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7bAdmin bypass mode for \u00a7e" + targetName + "\u00a7b is: \u00a7cDISABLED")), false);
        }
        return 1;
    }

    private static int executeAdminList(CommandContext<CommandSourceStack> ctx) {
        Set<String> bypassPlayers = RegionManager.getAdminBypassPlayers();
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        if (bypassPlayers.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77No players have admin bypass mode enabled."), false);
            return 0;
        }
        StringBuilder info = new StringBuilder();
        info.append(INFO).append("=== Players with Admin Bypass ===\n");
        for (String uuid : bypassPlayers) {
            ServerPlayer player = server.getPlayerList().getPlayer(UUID.fromString(uuid));
            if (player != null) {
                info.append(HIGHLIGHT).append("\u2022 ").append(player.getName().getString());
                info.append(SECONDARY).append(" (online)\n");
                continue;
            }
            info.append(SECONDARY).append("\u2022 ").append(uuid).append(" (offline - will be cleared)\n");
            RegionManager.disableAdminBypass(uuid);
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)info.toString()), false);
        return bypassPlayers.size();
    }

    private static int executeGiveWand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        return RegionCommands.giveWandToPlayer(player, (CommandSourceStack)ctx.getSource());
    }

    private static int executeGiveWandToPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        ServerPlayer targetPlayer = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayerByName(targetName);
        if (targetPlayer == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cPlayer '" + targetName + "' not found!")));
            return 0;
        }
        return RegionCommands.giveWandToPlayer(targetPlayer, (CommandSourceStack)ctx.getSource());
    }

    private static int giveWandToPlayer(ServerPlayer player, CommandSourceStack source) {
        ItemStack wandStack = new ItemStack((ItemLike)ModItems.REGION_WAND.get());
        if (player.getInventory().add(wandStack)) {
            source.sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Gave region wand to \u00a7e" + player.getName().getString())), true);
            try {
                if (!source.isPlayer() || !source.getPlayerOrException().equals((Object)player)) {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7a\u2713 You received a region wand! Use it to create and manage regions."));
                }
            }
            catch (CommandSyntaxException e) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7a\u2713 You received a region wand! Use it to create and manage regions."));
            }
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)("\u00a7cCould not give wand to " + player.getName().getString() + " (inventory full)")));
        return 0;
    }

    private static int executeSetWandModeNewCuboid(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionCommands.setWandMode(ctx, RegionWandItem.WandMode.NEW_CUBOID);
    }

    private static int executeSetWandModeNewRegion(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionCommands.setWandMode(ctx, RegionWandItem.WandMode.NEW_REGION);
    }

    private static int executeSetWandModeCopyPaste(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionCommands.setWandMode(ctx, RegionWandItem.WandMode.COPY_PASTE);
    }

    private static int executeSetWandModeDelete(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionCommands.setWandMode(ctx, RegionWandItem.WandMode.DELETE);
    }

    private static int setWandMode(CommandContext<CommandSourceStack> ctx, RegionWandItem.WandMode mode) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(stack.getItem() instanceof RegionWandItem)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cYou must be holding a region wand!"));
            return 0;
        }
        RegionWandItem.setMode(stack, mode);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7a\u2713 Set wand mode to \u00a7e" + mode.getDisplayName())), true);
        return 1;
    }

    private static int executeClearWandSelection(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(stack.getItem() instanceof RegionWandItem)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cYou must be holding a region wand!"));
            return 0;
        }
        RegionWandItem.clearSelection(stack);
        RegionWandData.clearSelection((Player)player);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7a\u2713 Cleared wand selection"), true);
        return 1;
    }

    private static int executeAdminPerformanceAll(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.sendSuccess(() -> Component.literal((String)"\u00a7b===== Region Performance Statistics ====="), false);
        Map<String, Region> regionsMap = RegionManager.getAllRegions();
        Collection<Region> regions = regionsMap.values();
        if (regions.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7bNo regions found."), false);
            return 1;
        }
        int smallRegions = 0;
        int mediumRegions = 0;
        int largeRegions = 0;
        for (Region region : regions) {
            int cuboidCount = region.getCuboidCount();
            if (cuboidCount <= 3) {
                ++smallRegions;
                continue;
            }
            if (cuboidCount <= 10) {
                ++mediumRegions;
                continue;
            }
            ++largeRegions;
        }
        int finalSmallRegions = smallRegions;
        int finalMediumRegions = mediumRegions;
        int finalLargeRegions = largeRegions;
        source.sendSuccess(() -> Component.literal((String)("\u00a7bTotal Regions: \u00a7e" + regions.size() + "\u00a7b (Small: \u00a77" + finalSmallRegions + "\u00a7b, Medium: \u00a77" + finalMediumRegions + "\u00a7b, Large: \u00a77" + finalLargeRegions + "\u00a7b)")), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a7bPerformance optimizations:"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77\u2022 Bounding box optimization for regions with >3 cuboids"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77\u2022 Spatial indexing for regions with >10 cuboids"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77\u2022 Player cuboid caching for all regions"), false);
        if (finalLargeRegions > 0) {
            source.sendSuccess(() -> Component.literal((String)"\u00a7bShowing detailed stats for large regions:"), false);
            for (Region region : regions) {
                if (region.getCuboidCount() <= 10) continue;
                source.sendSuccess(() -> Component.literal((String)("\u00a77\u2022 " + region.getPerformanceInfo())), false);
            }
        }
        return 1;
    }

    private static int executeAdminPerformanceRegion(CommandContext<CommandSourceStack> ctx) {
        String regionName = StringArgumentType.getString(ctx, (String)"region");
        Region region = RegionManager.getRegion(regionName);
        if (region == null) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("\u00a7cRegion '\u00a7e" + regionName + "\u00a7c' not found.")));
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.sendSuccess(() -> Component.literal((String)("\u00a7b===== Performance Statistics for '\u00a7e" + regionName + "\u00a7b' =====")), false);
        source.sendSuccess(() -> Component.literal((String)(SECONDARY + region.getPerformanceInfo())), false);
        int cuboidCount = region.getCuboidCount();
        String optimizationLevel = cuboidCount <= 3 ? "Basic (using bounding box check only)" : (cuboidCount <= 10 ? "Medium (using bounding box + player caching)" : "Advanced (using all optimizations: bounding box, spatial indexing, player caching)");
        source.sendSuccess(() -> Component.literal((String)("\u00a7bOptimization Level: \u00a77" + optimizationLevel)), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7bVolume: \u00a7e" + String.format("%,d", region.getVolume()) + "\u00a7b blocks")), false);
        if (cuboidCount > 1) {
            source.sendSuccess(() -> Component.literal((String)("\u00a7bCuboids: \u00a7e" + cuboidCount)), false);
            for (int i = 0; i < Math.min(5, cuboidCount); ++i) {
                Cuboid cuboid = region.getCuboid(i);
                if (cuboid == null) continue;
                int finalI = i;
                Cuboid finalCuboid = cuboid;
                source.sendSuccess(() -> Component.literal((String)("\u00a77  " + (finalI + 1) + ". " + finalCuboid.toDisplayString() + " (" + String.format("%,d", finalCuboid.getVolume()) + " blocks)")), false);
            }
            if (cuboidCount > 5) {
                source.sendSuccess(() -> Component.literal((String)("\u00a77  ... and " + (cuboidCount - 5) + " more")), false);
            }
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$executeInfoRegion$32(Component finalMessage) {
        return finalMessage;
    }

    private static /* synthetic */ Component lambda$executeInfoTopLevel$30(Component finalMessage) {
        return finalMessage;
    }

    private static enum MessageType {
        ENTRY,
        EXIT;

    }

    private static enum MessageSubType {
        CHAT("chat"),
        ACTIONBAR("actionbar");

        private final String name;

        private MessageSubType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum GamemodeType {
        ENTRY,
        EXIT;

    }
}

