/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions.packets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import world.landfall.landfallessentials.regions.packets.RegionVisualizationClientHandler;

public record RegionVisualizationPacket(boolean enabled, List<RegionData> regions) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RegionVisualizationPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"landfallessentials", (String)"region_visualization"));
    public static final StreamCodec<FriendlyByteBuf, RegionVisualizationPacket> STREAM_CODEC = StreamCodec.of(RegionVisualizationPacket::write, RegionVisualizationPacket::read);

    private static void write(FriendlyByteBuf buf, RegionVisualizationPacket packet) {
        buf.writeBoolean(packet.enabled);
        buf.writeVarInt(packet.regions.size());
        for (RegionData region : packet.regions) {
            buf.writeUtf(region.name());
            buf.writeUtf(region.dimension());
            buf.writeVarInt(region.cuboids().size());
            for (CuboidData cuboid : region.cuboids()) {
                buf.writeBlockPos(cuboid.min());
                buf.writeBlockPos(cuboid.max());
                buf.writeVarInt(cuboid.color());
            }
        }
    }

    private static RegionVisualizationPacket read(FriendlyByteBuf buf) {
        boolean enabled = buf.readBoolean();
        int regionCount = buf.readVarInt();
        ArrayList<RegionData> regions = new ArrayList<RegionData>();
        for (int i = 0; i < regionCount; ++i) {
            String name = buf.readUtf();
            String dimension = buf.readUtf();
            int cuboidCount = buf.readVarInt();
            ArrayList<CuboidData> cuboids = new ArrayList<CuboidData>();
            for (int j = 0; j < cuboidCount; ++j) {
                BlockPos min = buf.readBlockPos();
                BlockPos max = buf.readBlockPos();
                int color = buf.readVarInt();
                cuboids.add(new CuboidData(min, max, color));
            }
            regions.add(new RegionData(name, dimension, cuboids));
        }
        return new RegionVisualizationPacket(enabled, regions);
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.flow().isClientbound()) {
                RegionVisualizationClientHandler.handleVisualizationPacket(this);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public record RegionData(String name, String dimension, List<CuboidData> cuboids) {
    }

    public record CuboidData(BlockPos min, BlockPos max, int color) {
    }
}

