/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.registry;

import java.util.List;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import world.landfall.landfallessentials.item.custom.ItemWithLore;
import world.landfall.landfallessentials.item.custom.RegionWandItem;

public class ModItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"landfallessentials");
    public static final DeferredItem<Item> REGION_WAND = ITEMS.register("region_wand", () -> new RegionWandItem());

    public static DeferredItem<Item> registerSimpleItem(String name) {
        return ITEMS.registerSimpleItem(name, new Item.Properties());
    }

    public static DeferredItem<Item> registerItem(String name, Item.Properties properties) {
        return ITEMS.registerSimpleItem(name, properties);
    }

    public static DeferredItem<Item> registerFoodItem(String name, int nutrition, float saturation) {
        return ITEMS.registerSimpleItem(name, new Item.Properties().food(new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturation).build()));
    }

    public static DeferredItem<Item> registerFoodItem(String name, FoodProperties foodProperties) {
        return ITEMS.registerSimpleItem(name, new Item.Properties().food(foodProperties));
    }

    public static DeferredItem<Item> registerToolItem(String name, int durability) {
        return ITEMS.registerSimpleItem(name, new Item.Properties().durability(durability));
    }

    public static DeferredItem<Item> registerItemWithLore(String name, String ... loreLines) {
        return ITEMS.register(name, () -> new ItemWithLore(new Item.Properties(), loreLines));
    }

    public static DeferredItem<Item> registerItemWithLore(String name, Item.Properties properties, String ... loreLines) {
        return ITEMS.register(name, () -> new ItemWithLore(properties, loreLines));
    }

    public static DeferredItem<Item> registerItemWithLore(String name, List<String> loreLines) {
        return ITEMS.register(name, () -> new ItemWithLore(new Item.Properties(), loreLines));
    }

    public static DeferredItem<Item> registerItemWithLore(String name, Item.Properties properties, List<String> loreLines) {
        return ITEMS.register(name, () -> new ItemWithLore(properties, loreLines));
    }
}

