/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.block.custom;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber
public class AsphaltBlock
extends Block {
    private static final ResourceLocation ASPHALT_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"landfallessentials", (String)"asphalt_speed_boost");
    private static final double SPEED_BOOST = 0.5;

    public AsphaltBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity) {
            boolean hasMovementInput;
            LivingEntity livingEntity = (LivingEntity)entity;
            boolean bl = hasMovementInput = livingEntity.xxa != 0.0f || livingEntity.zza != 0.0f;
            if (hasMovementInput) {
                return 0.98f;
            }
            return 0.1f;
        }
        return 0.6f;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!level.isClientSide() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            AsphaltBlock.addSpeedBoost(livingEntity);
        }
        super.stepOn(level, pos, state, entity);
    }

    private static void addSpeedBoost(LivingEntity entity) {
        AttributeInstance speedAttribute = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && !speedAttribute.hasModifier(ASPHALT_SPEED_ID)) {
            AttributeModifier speedModifier = new AttributeModifier(ASPHALT_SPEED_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            speedAttribute.addPermanentModifier(speedModifier);
        }
    }

    private static void removeSpeedBoost(LivingEntity entity) {
        AttributeInstance speedAttribute = entity.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && speedAttribute.hasModifier(ASPHALT_SPEED_ID)) {
            speedAttribute.removeModifier(ASPHALT_SPEED_ID);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        AttributeInstance speedAttribute;
        boolean hasSpeedBoost;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (entity2.level().isClientSide()) {
            return;
        }
        BlockPos entityPos = entity2.blockPosition();
        boolean onAsphalt = false;
        for (int i = 0; i <= 2; ++i) {
            BlockPos checkPos = entityPos.below(i);
            BlockState blockState = entity2.level().getBlockState(checkPos);
            if (!(blockState.getBlock() instanceof AsphaltBlock)) continue;
            onAsphalt = true;
            break;
        }
        boolean bl = hasSpeedBoost = (speedAttribute = entity2.getAttribute(Attributes.MOVEMENT_SPEED)) != null && speedAttribute.hasModifier(ASPHALT_SPEED_ID);
        if (onAsphalt && !hasSpeedBoost) {
            AsphaltBlock.addSpeedBoost(entity2);
        } else if (!onAsphalt && hasSpeedBoost) {
            AsphaltBlock.removeSpeedBoost(entity2);
        }
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)this));
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return true;
    }
}

