/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import world.landfall.landfallessentials.block.custom.ShonkBlock;
import world.landfall.landfallessentials.block.entity.BlueShonkBlockEntity;
import world.landfall.landfallessentials.block.entity.ShonkBlockEntity;
import world.landfall.landfallessentials.registry.ModBlockEntities;

public class BlueShonkBlock
extends ShonkBlock {
    public static final MapCodec<BlueShonkBlock> CODEC = BlueShonkBlock.simpleCodec(BlueShonkBlock::new);
    private static final double BLUE_SHONK_RANGE = 5.0;

    public BlueShonkBlock(BlockBehaviour.Properties properties) {
        super(properties, 5.0);
    }

    protected MapCodec<? extends ShonkBlock> codec() {
        return CODEC;
    }

    @Override
    protected void applyEffectToEntity(LivingEntity entity, Level level, BlockPos pos) {
        if (!entity.hasEffect(MobEffects.REGENERATION)) {
            entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 0, true, false));
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlueShonkBlockEntity(pos, state);
    }

    @Override
    protected BlockEntityType<? extends ShonkBlockEntity> getBlockEntityType() {
        return ModBlockEntities.BLUE_SHONK_BLOCK_ENTITY.get();
    }
}

