/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import world.landfall.landfallessentials.block.entity.SpookiestRockBlockEntity;
import world.landfall.landfallessentials.registry.ModBlockEntities;

public class SpookiestRockBlock
extends BaseEntityBlock {
    public static final MapCodec<SpookiestRockBlock> CODEC = SpookiestRockBlock.simpleCodec(SpookiestRockBlock::new);

    public SpookiestRockBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SpookiestRockBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : SpookiestRockBlock.createTickerHelper(blockEntityType, ModBlockEntities.SPOOKIEST_ROCK_BLOCK_ENTITY.get(), (level1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof SpookiestRockBlockEntity) {
                SpookiestRockBlockEntity spookiestRock = blockEntity;
                spookiestRock.tick();
            }
        });
    }
}

