/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import world.landfall.landfallessentials.registry.ModBlockEntities;

public class SpookiestRockBlockEntity
extends BlockEntity {
    private int tickCounter = 0;
    private int nextSoundDelay = 2400 + (int)(Math.random() * 3600.0);

    public SpookiestRockBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.SPOOKIEST_ROCK_BLOCK_ENTITY.get(), pos, blockState);
    }

    public void tick() {
        Level level = this.getLevel();
        if (level == null || level.isClientSide) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= this.nextSoundDelay) {
            this.playSpookySound(level);
            this.tickCounter = 0;
            this.nextSoundDelay = 2400 + (int)(Math.random() * 3600.0);
        }
    }

    private void playSpookySound(Level level) {
        BlockPos pos = this.getBlockPos();
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

