/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.client.screen.LowRAMWarningScreen;

@OnlyIn(value=Dist.CLIENT)
public class ClientStartupHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientStartupHandler.class);
    private static boolean hasShownWarning = false;

    @SubscribeEvent
    public void onScreenOpen(ScreenEvent.Opening event) {
        if (!hasShownWarning && event.getScreen() instanceof TitleScreen) {
            long maxMemoryBytes = Runtime.getRuntime().maxMemory();
            double maxMemoryGB = (double)maxMemoryBytes / 1.073741824E9;
            LOGGER.info("Checking RAM on title screen open: {} GB allocated", (Object)String.format("%.1f", maxMemoryGB));
            if (LowRAMWarningScreen.shouldShowWarning()) {
                LOGGER.info("Showing RAM warning screen - insufficient memory detected");
                hasShownWarning = true;
                event.setCanceled(true);
                Minecraft.getInstance().execute(() -> Minecraft.getInstance().setScreen((Screen)new LowRAMWarningScreen((Screen)new TitleScreen())));
            } else {
                LOGGER.info("RAM check passed - {} GB is sufficient", (Object)String.format("%.1f", maxMemoryGB));
            }
        }
    }
}

