/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.item.custom;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BucketOfSlagItem
extends Item {
    public BucketOfSlagItem() {
        super(new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        super.finishUsingItem(stack, level, entity);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        entity.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 0));
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.hasInfiniteMaterials()) {
                stack.shrink(1);
            }
            if (stack.isEmpty()) {
                return new ItemStack((ItemLike)Items.BUCKET);
            }
            player.getInventory().add(new ItemStack((ItemLike)Items.BUCKET));
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }
}

