/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RegionWandItem
extends Item {
    public RegionWandItem() {
        super(new Item.Properties().stacksTo(1).fireResistant());
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        if (context.getHand() == InteractionHand.MAIN_HAND) {
            this.handleRightClickBlock(player, stack, pos, level);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.cycleMode(stack, player, level);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private void handleRightClickBlock(Player player, ItemStack stack, BlockPos pos, Level level) {
        level.playSound(null, pos, SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, 0.3f, 1.0f);
    }

    private void cycleMode(ItemStack stack, Player player, Level level) {
        WandMode currentMode = RegionWandItem.getMode(stack);
        WandMode newMode = currentMode.next();
        RegionWandItem.setMode(stack, newMode);
        player.displayClientMessage((Component)Component.literal((String)"\u25c6 Wand Mode: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)newMode.getDisplayName()).withStyle(newMode.getColor())).append((Component)Component.literal((String)(" - " + newMode.getDescription())).withStyle(ChatFormatting.GRAY)), true);
        level.playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 0.8f + (float)newMode.ordinal() * 0.2f);
    }

    public static WandMode getMode(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.contains("WandMode")) {
            return WandMode.NEW_REGION;
        }
        try {
            return WandMode.valueOf(tag.getString("WandMode"));
        }
        catch (IllegalArgumentException e) {
            return WandMode.NEW_REGION;
        }
    }

    public static void setMode(ItemStack stack, WandMode mode) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        tag.putString("WandMode", mode.name());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static BlockPos getCorner1(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.contains("Corner1")) {
            return null;
        }
        CompoundTag corner = tag.getCompound("Corner1");
        return new BlockPos(corner.getInt("X"), corner.getInt("Y"), corner.getInt("Z"));
    }

    public static void setCorner1(ItemStack stack, BlockPos pos) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (pos == null) {
            tag.remove("Corner1");
        } else {
            CompoundTag corner = new CompoundTag();
            corner.putInt("X", pos.getX());
            corner.putInt("Y", pos.getY());
            corner.putInt("Z", pos.getZ());
            tag.put("Corner1", (Tag)corner);
        }
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static void clearSelection(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        tag.remove("Corner1");
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        WandMode mode = RegionWandItem.getMode(stack);
        tooltip.add((Component)Component.literal((String)"Mode: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)mode.getDisplayName()).withStyle(mode.getColor())));
        tooltip.add((Component)Component.literal((String)mode.getDescription()).withStyle(ChatFormatting.DARK_GRAY));
        BlockPos corner1 = RegionWandItem.getCorner1(stack);
        if (corner1 != null) {
            tooltip.add((Component)Component.literal((String)"Selection: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.format("%d, %d, %d", corner1.getX(), corner1.getY(), corner1.getZ())).withStyle(ChatFormatting.YELLOW)));
        }
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.literal((String)"Left-click block: Set first corner").withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.literal((String)"Right-click block: Set second corner").withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.literal((String)"Shift + Right-click air: Change mode").withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.literal((String)"Copy/Paste mode: Click regions to copy/paste").withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.literal((String)"Delete mode: Left-click cuboid, Shift+Left-click region").withStyle(ChatFormatting.DARK_GRAY));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public static enum WandMode {
        NEW_CUBOID("New Cuboid", "Add cuboid to existing region", ChatFormatting.GREEN),
        NEW_REGION("New Region", "Create a new region", ChatFormatting.BLUE),
        COPY_PASTE("Copy/Paste", "Copy and paste region properties", ChatFormatting.LIGHT_PURPLE),
        DELETE("Delete", "Delete cuboids and regions", ChatFormatting.RED);

        private final String displayName;
        private final String description;
        private final ChatFormatting color;

        private WandMode(String displayName, String description, ChatFormatting color) {
            this.displayName = displayName;
            this.description = description;
            this.color = color;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }

        public ChatFormatting getColor() {
            return this.color;
        }

        public WandMode next() {
            return WandMode.values()[(this.ordinal() + 1) % WandMode.values().length];
        }
    }
}

