/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.moderation;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.moderation.ModerationManager;

@EventBusSubscriber
public class ModerationEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModerationEventHandler.class);

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ModerationManager.requestModDataFromPlayer(player2);
            LOGGER.debug("Requested mod data from player {} upon login.", (Object)player2.getName().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            return;
        }
        ModerationManager.removePlayerModData(event.getEntity().getUUID());
        LOGGER.debug("Cleaned up mod data for player {}", (Object)event.getEntity().getUUID());
    }
}

