/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import world.landfall.landfallessentials.entity.ThrownSnowbreakerEntity;
import world.landfall.landfallessentials.item.custom.SnowbreakerItem;

public record ThrowSnowbreakerPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ThrowSnowbreakerPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"landfallessentials", (String)"throw_snowbreaker"));
    public static final StreamCodec<FriendlyByteBuf, ThrowSnowbreakerPacket> STREAM_CODEC = StreamCodec.unit((Object)new ThrowSnowbreakerPacket());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ThrowSnowbreakerPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer;
            ItemStack mainHand;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (mainHand = (serverPlayer = (ServerPlayer)patt0$temp).getMainHandItem()).getItem() instanceof SnowbreakerItem) {
                ThrownSnowbreakerEntity thrownHammer = new ThrownSnowbreakerEntity(serverPlayer.level(), (Player)serverPlayer);
                thrownHammer.shootFromRotation((Entity)serverPlayer, serverPlayer.getXRot(), serverPlayer.getYRot(), 0.0f, 2.0f, 1.0f);
                serverPlayer.level().addFreshEntity((Entity)thrownHammer);
                serverPlayer.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                serverPlayer.level().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                serverPlayer.getCooldowns().addCooldown(mainHand.getItem(), 30);
            }
        });
    }
}

