/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.RentableVisualization;

@EventBusSubscriber(modid="landfallessentials")
public class RegionPlayerEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionPlayerEventHandler.class);

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            String playerUUID = player2.getUUID().toString();
            RegionManager.cleanupPlayerData(playerUUID);
            RentableVisualization.onPlayerDisconnect(player2);
            LOGGER.debug("Player {} disconnected, cleaned up region tracking data", (Object)player2.getName().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            LOGGER.debug("Player {} connected, flight state will be evaluated on next tick", (Object)player2.getName().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.tickCount % 10 == 0) {
            RentableVisualization.onPlayerMove(player2);
        }
    }
}

