/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.util.CommandMessageBuilder;
import world.landfall.landfallessentials.regions.util.RegionCommandHelper;

public class RegionTagCommands {
    private static final int ADMIN_PERMISSION = 2;

    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"region").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"edit").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionTagCommands::suggestRegionNames).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tag").then(Commands.literal((String)"add").then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).executes(RegionTagCommands::executeAddTag)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).suggests(RegionTagCommands::suggestRegionTags).executes(RegionTagCommands::executeRemoveTag)))).then(Commands.literal((String)"clear").executes(RegionTagCommands::executeClearTags))).then(Commands.literal((String)"list").executes(RegionTagCommands::executeListTags)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"query").then(Commands.literal((String)"tag").then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).suggests(RegionTagCommands::suggestAllTags).executes(RegionTagCommands::executeQueryTag)))).then(((LiteralArgumentBuilder)Commands.literal((String)"player").executes(RegionTagCommands::executeQueryPlayerSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionTagCommands::executeQueryPlayer))));
    }

    private static CompletableFuture<Suggestions> suggestRegionNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(RegionManager.getRegionNames(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestRegionTags(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        try {
            String regionName = StringArgumentType.getString(context, (String)"name");
            Set<String> tags = RegionManager.getRegionTags(regionName);
            return SharedSuggestionProvider.suggest(tags, (SuggestionsBuilder)builder);
        }
        catch (Exception e) {
            return SharedSuggestionProvider.suggest(Collections.emptyList(), (SuggestionsBuilder)builder);
        }
    }

    private static CompletableFuture<Suggestions> suggestAllTags(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Set<String> allTags = RegionManager.getAllTags();
        return SharedSuggestionProvider.suggest(allTags, (SuggestionsBuilder)builder);
    }

    private static int executeAddTag(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String regionName = StringArgumentType.getString(ctx, (String)"name");
        String tag = StringArgumentType.getString(ctx, (String)"tag");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        if (RegionManager.addTagToRegion(regionName, tag)) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Added tag '").highlight(tag).success("' to region '").highlight(regionName).success("'.").build(), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Tag '").highlight(tag).error("' already exists on region '").highlight(regionName).error("' or is invalid.").build());
        return 0;
    }

    private static int executeRemoveTag(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String regionName = StringArgumentType.getString(ctx, (String)"name");
        String tag = StringArgumentType.getString(ctx, (String)"tag");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        if (RegionManager.removeTagFromRegion(regionName, tag)) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Removed tag '").highlight(tag).success("' from region '").highlight(regionName).success("'.").build(), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Tag '").highlight(tag).error("' not found on region '").highlight(regionName).error("'.").build());
        return 0;
    }

    private static int executeClearTags(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String regionName = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        if (RegionManager.clearRegionTags(regionName)) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Cleared all tags from region '").highlight(regionName).success("'.").build(), true);
            return 1;
        }
        RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().muted("Region '").highlight(regionName).muted("' has no tags to clear.").build());
        return 1;
    }

    private static int executeListTags(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String regionName = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        Set<String> tags = region.getTags();
        if (tags.isEmpty()) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().muted("Region '").highlight(regionName).muted("' has no tags.").build());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("\u00a7bTags for region '\u00a7e").append(regionName).append("\u00a7b' (\u00a7e").append(tags.size()).append("\u00a7b): ");
            boolean first = true;
            for (String tag : tags) {
                if (!first) {
                    sb.append("\u00a77, ");
                }
                sb.append("\u00a7e").append(tag);
                first = false;
            }
            RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)sb.toString()));
        }
        return tags.size();
    }

    private static int executeQueryTag(CommandContext<CommandSourceStack> ctx) {
        String tag = StringArgumentType.getString(ctx, (String)"tag");
        List<String> regions = RegionManager.getRegionsWithTag(tag);
        if (regions.isEmpty()) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().muted("No regions found with tag '").highlight(tag).muted("'.").build());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("\u00a7bRegions with tag '\u00a7e").append(tag).append("\u00a7b' (\u00a7e").append(regions.size()).append("\u00a7b): ");
            boolean first = true;
            for (String regionName : regions) {
                if (!first) {
                    sb.append("\u00a77, ");
                }
                sb.append("\u00a7e").append(regionName);
                first = false;
            }
            RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)sb.toString()));
        }
        return regions.size();
    }

    private static int executeQueryPlayerSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        return RegionTagCommands.executeQueryForPlayer(ctx, player);
    }

    private static int executeQueryPlayer(CommandContext<CommandSourceStack> ctx) {
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer player = server.getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Player '").highlight(playerName).error("' not found or not online.").build());
            return 0;
        }
        return RegionTagCommands.executeQueryForPlayer(ctx, player);
    }

    private static int executeQueryForPlayer(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        Set<String> playerRegions = RegionManager.getPlayerRegions(player.getUUID().toString());
        Set<String> playerTags = RegionManager.getPlayerRegionTags((Player)player);
        StringBuilder info = new StringBuilder();
        info.append("\u00a7b=== Player Region Info: \u00a7e").append(player.getName().getString()).append("\u00a7b ===\n");
        if (playerRegions.isEmpty()) {
            info.append("\u00a77Player is not in any regions.");
        } else {
            info.append("\u00a7bCurrent regions (\u00a7e").append(playerRegions.size()).append("\u00a7b): ");
            boolean first = true;
            for (String regionName : playerRegions) {
                if (!first) {
                    info.append("\u00a77, ");
                }
                info.append("\u00a7e").append(regionName);
                first = false;
            }
            info.append("\n");
            if (playerTags.isEmpty()) {
                info.append("\u00a77No tags from current regions.");
            } else {
                info.append("\u00a7bActive tags (\u00a7e").append(playerTags.size()).append("\u00a7b): ");
                first = true;
                for (String tag : playerTags) {
                    if (!first) {
                        info.append("\u00a77, ");
                    }
                    info.append("\u00a7e").append(tag);
                    first = false;
                }
            }
        }
        RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)info.toString()));
        return 1;
    }
}

