/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import world.landfall.landfallessentials.item.custom.RegionWandItem;
import world.landfall.landfallessentials.regions.RegionVisualizerNew;
import world.landfall.landfallessentials.regions.RegionWandData;
import world.landfall.landfallessentials.regions.util.CommandMessageBuilder;
import world.landfall.landfallessentials.regions.util.RegionCommandHelper;
import world.landfall.landfallessentials.registry.ModItems;

public class RegionVisualizationCommands {
    private static final int ADMIN_PERMISSION = 2;

    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"visualize").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"toggle").executes(RegionVisualizationCommands::executeToggleVisualization))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wand").then(((LiteralArgumentBuilder)Commands.literal((String)"give").executes(RegionVisualizationCommands::executeGiveWand)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionVisualizationCommands::executeGiveWandToPlayer)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mode").then(Commands.literal((String)"newcuboid").executes(RegionVisualizationCommands::executeSetWandModeNewCuboid))).then(Commands.literal((String)"newregion").executes(RegionVisualizationCommands::executeSetWandModeNewRegion))).then(Commands.literal((String)"copypaste").executes(RegionVisualizationCommands::executeSetWandModeCopyPaste))).then(Commands.literal((String)"delete").executes(RegionVisualizationCommands::executeSetWandModeDelete)))).then(Commands.literal((String)"clear").executes(RegionVisualizationCommands::executeClearWandSelection)));
    }

    private static int executeToggleVisualization(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        boolean enabled = RegionVisualizerNew.toggleVisualization(player);
        RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Region visualization ").highlight(enabled ? "enabled" : "disabled").build());
        return enabled ? 1 : 0;
    }

    private static int executeGiveWand(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        return RegionVisualizationCommands.giveWandToPlayer(player, (CommandSourceStack)ctx.getSource());
    }

    private static int executeGiveWandToPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        ServerPlayer targetPlayer = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayerByName(targetName);
        if (targetPlayer == null) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Player '").highlight(targetName).error("' not found.").build());
            return 0;
        }
        return RegionVisualizationCommands.giveWandToPlayer(targetPlayer, (CommandSourceStack)ctx.getSource());
    }

    private static int giveWandToPlayer(ServerPlayer player, CommandSourceStack source) {
        ItemStack wandStack = new ItemStack((ItemLike)ModItems.REGION_WAND.get());
        if (player.getInventory().add(wandStack)) {
            source.sendSuccess(() -> new CommandMessageBuilder().success("\u2713 Gave region wand to ").highlight(player.getName().getString()).build(), true);
            try {
                if (!source.isPlayer() || !source.getPlayerOrException().equals((Object)player)) {
                    player.sendSystemMessage(CommandMessageBuilder.successMsg("\u2713 You received a region wand! Use it to create and manage regions."));
                }
            }
            catch (CommandSyntaxException e) {
                player.sendSystemMessage(CommandMessageBuilder.successMsg("\u2713 You received a region wand! Use it to create and manage regions."));
            }
            return 1;
        }
        source.sendFailure(new CommandMessageBuilder().error("\u2717 Could not give wand to ").highlight(player.getName().getString()).error(" (inventory full)").build());
        return 0;
    }

    private static int executeSetWandModeNewCuboid(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionVisualizationCommands.setWandMode(ctx, RegionWandItem.WandMode.NEW_CUBOID);
    }

    private static int executeSetWandModeNewRegion(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionVisualizationCommands.setWandMode(ctx, RegionWandItem.WandMode.NEW_REGION);
    }

    private static int executeSetWandModeCopyPaste(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionVisualizationCommands.setWandMode(ctx, RegionWandItem.WandMode.COPY_PASTE);
    }

    private static int executeSetWandModeDelete(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionVisualizationCommands.setWandMode(ctx, RegionWandItem.WandMode.DELETE);
    }

    private static int setWandMode(CommandContext<CommandSourceStack> ctx, RegionWandItem.WandMode mode) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(stack.getItem() instanceof RegionWandItem)) {
            RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 You must be holding a region wand!"));
            return 0;
        }
        RegionWandItem.setMode(stack, mode);
        RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Set wand mode to ").highlight(mode.getDisplayName()).build(), true);
        return 1;
    }

    private static int executeClearWandSelection(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(stack.getItem() instanceof RegionWandItem)) {
            RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 You must be holding a region wand!"));
            return 0;
        }
        RegionWandItem.clearSelection(stack);
        RegionWandData.clearSelection((Player)player);
        RegionCommandHelper.sendSuccess(ctx, CommandMessageBuilder.successMsg("\u2713 Cleared wand selection"), true);
        return 1;
    }
}

