/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.tpa;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.util.LuckPermsUtil;

public class TPALuckPermsIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(TPALuckPermsIntegration.class);
    private static final String TPA_COOLDOWN_PERMISSION_PREFIX = "landfallessentials.tpa.cooldown.";
    private static final String TPA_COOLDOWN_META_KEY = "landfallessentials.tpa.cooldown";

    public static void initialize() {
        LuckPermsUtil.initialize();
        if (LuckPermsUtil.isAvailable()) {
            LOGGER.info("TPA LuckPerms integration: Cooldown overrides active.");
        } else {
            LOGGER.info("TPA LuckPerms integration: LuckPerms not available, cooldown overrides disabled.");
        }
    }

    public static long getCooldownOverride(ServerPlayer player) {
        if (player == null || player.getServer() == null || !LuckPermsUtil.isAvailable()) {
            return -1L;
        }
        try {
            Object user = LuckPermsUtil.getUser(player.getUUID());
            if (user == null) {
                return -1L;
            }
            long permissionCooldown = TPALuckPermsIntegration.getCooldownFromPermissions(user);
            if (permissionCooldown >= 0L) {
                return permissionCooldown;
            }
            return TPALuckPermsIntegration.getCooldownFromMeta(user, player.getUUID());
        }
        catch (Exception e) {
            LOGGER.warn("Error getting TPA cooldown override from LuckPerms for player " + player.getName().getString(), (Throwable)e);
            return -1L;
        }
    }

    private static long getCooldownFromPermissions(Object user) {
        long[] commonCooldowns;
        Object permissionData = LuckPermsUtil.getPermissionData(user);
        if (permissionData == null) {
            return -1L;
        }
        long lowestCooldown = -1L;
        for (long cooldown : commonCooldowns = new long[]{0L, 5L, 10L, 15L, 30L, 45L, 60L, 90L, 120L, 180L, 300L, 600L}) {
            String permissionNode = TPA_COOLDOWN_PERMISSION_PREFIX + cooldown;
            if (!LuckPermsUtil.checkPermission(permissionData, permissionNode) || lowestCooldown != -1L && cooldown >= lowestCooldown) continue;
            lowestCooldown = cooldown;
        }
        return lowestCooldown;
    }

    private static long getCooldownFromMeta(Object user, UUID playerUUID) {
        Object metaData = LuckPermsUtil.getMetaData(user);
        if (metaData == null) {
            return -1L;
        }
        String metaValue = LuckPermsUtil.getMetaValue(metaData, TPA_COOLDOWN_META_KEY);
        if (metaValue == null || metaValue.isEmpty()) {
            return -1L;
        }
        try {
            return Long.parseLong(metaValue);
        }
        catch (NumberFormatException e) {
            String forPlayerMessage = playerUUID != null ? " for player " + playerUUID.toString() : " for a player";
            LOGGER.warn("Invalid TPA cooldown meta value '{}'{}", (Object)metaValue, (Object)forPlayerMessage);
            return -1L;
        }
    }

    public static boolean isAvailable() {
        return LuckPermsUtil.isAvailable();
    }
}

