/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import world.landfall.landfallessentials.client.model.ModModelRegistry;

public class SnowbreakerItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation SNOWBREAKER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"landfallessentials", (String)"textures/item/snowbreaker_3d.png");
    private ModelPart hammerModel;

    public SnowbreakerItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack itemStack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (this.hammerModel == null) {
            this.hammerModel = Minecraft.getInstance().getEntityModels().bakeLayer(ModModelRegistry.SNOWBREAKER);
        }
        poseStack.pushPose();
        switch (displayContext) {
            case GROUND: {
                poseStack.translate(0.5f, 0.25f, 0.5f);
                Minecraft mc = Minecraft.getInstance();
                if (mc.level == null) break;
                long gameTime = mc.level.getGameTime();
                float partialTick = mc.getTimer().getGameTimeDeltaPartialTick(false);
                float rotation = ((float)gameTime + partialTick) / 20.0f * 57.295776f;
                poseStack.mulPose(Axis.YP.rotationDegrees(-rotation));
                break;
            }
            default: {
                poseStack.translate(0.5f, 0.0f, 0.5f);
            }
        }
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)SNOWBREAKER_TEXTURE));
        this.hammerModel.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.popPose();
    }
}

