/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import world.landfall.landfallessentials.client.model.ModModelRegistry;
import world.landfall.landfallessentials.entity.ThrownSnowbreakerEntity;

public class ThrownSnowbreakerRenderer
extends EntityRenderer<ThrownSnowbreakerEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"landfallessentials", (String)"textures/item/snowbreaker_3d.png");
    private ModelPart hammerModel;

    public ThrownSnowbreakerRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.hammerModel = context.bakeLayer(ModModelRegistry.SNOWBREAKER);
    }

    public void render(ThrownSnowbreakerEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(-((float)entity.tickCount + partialTicks) * 60.0f));
        poseStack.translate(0.0, 0.3, -0.3);
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE));
        this.hammerModel.render(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ThrownSnowbreakerEntity entity) {
        return TEXTURE;
    }
}

