/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.database.DatabaseSchema;

public class DatabaseManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseManager.class);
    private static String dbFilePath;
    private static HikariDataSource dataSource;
    private static boolean initialized;

    public static synchronized void initialize(File worldFolder) throws SQLException {
        if (initialized) {
            LOGGER.warn("DatabaseManager already initialized, skipping");
            return;
        }
        try {
            dbFilePath = new File(worldFolder, "data/landfallessentials/landfall.db").getAbsolutePath();
            File dbFile = new File(dbFilePath);
            File parentDir = dbFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
                LOGGER.info("Created database directory: {}", (Object)parentDir.getAbsolutePath());
            }
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:sqlite:" + dbFilePath);
            config.setDriverClassName("org.sqlite.JDBC");
            config.setMaximumPoolSize(10);
            config.setMinimumIdle(2);
            config.setConnectionTimeout(30000L);
            config.setIdleTimeout(600000L);
            config.setMaxLifetime(1800000L);
            config.setConnectionTestQuery("SELECT 1");
            config.setPoolName("LandfallEssentials-Pool");
            config.addDataSourceProperty("cachePrepStmts", (Object)"true");
            config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
            dataSource = new HikariDataSource(config);
            LOGGER.info("Database connection pool initialized at: {}", (Object)dbFilePath);
            try (Connection conn = dataSource.getConnection();){
                DatabaseSchema.createTables(conn);
                LOGGER.info("Database schema initialized successfully");
            }
            initialized = true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize database", (Throwable)e);
            throw new SQLException("Database initialization failed", e);
        }
    }

    public static Connection getConnection() throws SQLException {
        if (!initialized) {
            throw new IllegalStateException("DatabaseManager not initialized. Call initialize() first.");
        }
        if (dataSource == null || dataSource.isClosed()) {
            throw new IllegalStateException("Database connection pool is closed");
        }
        return dataSource.getConnection();
    }

    public static synchronized void shutdown() {
        if (dataSource != null && !dataSource.isClosed()) {
            LOGGER.info("Shutting down database connection pool...");
            dataSource.close();
            initialized = false;
            LOGGER.info("Database connection pool closed successfully");
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static String getDatabasePath() {
        return dbFilePath;
    }

    public static void executeTransaction(TransactionCallback transaction) throws SQLException {
        try (Connection conn = DatabaseManager.getConnection();){
            conn.setAutoCommit(false);
            try {
                transaction.execute(conn);
                conn.commit();
            }
            catch (Exception e) {
                conn.rollback();
                throw e;
            }
            finally {
                conn.setAutoCommit(true);
            }
        }
    }

    static {
        initialized = false;
    }

    @FunctionalInterface
    public static interface TransactionCallback {
        public void execute(Connection var1) throws SQLException;
    }
}

