/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.database.DatabaseManager;
import world.landfall.landfallessentials.regions.Cuboid;
import world.landfall.landfallessentials.regions.Region;

public class RegionDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionDAO.class);

    public static void saveRegion(Region region) throws SQLException {
        DatabaseManager.executeTransaction(conn -> {
            String sql = "    INSERT OR REPLACE INTO regions (\n        name, dimension, sound_event_id, sound_category, sound_volume, sound_pitch,\n        sound_loop_delay_ticks, entry_message, exit_message, entry_actionbar_message,\n        exit_actionbar_message, gamemode_on_entry, gamemode_on_exit, access_denied_message\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, region.getName());
                stmt.setString(2, region.getDimension());
                stmt.setString(3, region.getSoundEventId());
                stmt.setString(4, region.getSoundCategory());
                stmt.setFloat(5, region.getSoundVolume());
                stmt.setFloat(6, region.getSoundPitch());
                stmt.setInt(7, region.getSoundLoopDelayTicks());
                stmt.setString(8, region.getEntryMessage());
                stmt.setString(9, region.getExitMessage());
                stmt.setString(10, region.getEntryActionbarMessage());
                stmt.setString(11, region.getExitActionbarMessage());
                stmt.setString(12, region.getGamemodeOnEntry());
                stmt.setString(13, region.getGamemodeOnExit());
                stmt.setString(14, region.getAccessDeniedMessage());
                stmt.executeUpdate();
            }
            RegionDAO.deleteCuboids(conn, region.getName());
            RegionDAO.deleteTags(conn, region.getName());
            RegionDAO.saveCuboids(conn, region.getName(), region.getCuboids());
            RegionDAO.saveTags(conn, region.getName(), region.getTags());
        });
    }

    public static void saveRegions(Collection<Region> regions) throws SQLException {
        if (regions == null || regions.isEmpty()) {
            return;
        }
        DatabaseManager.executeTransaction(conn -> {
            for (Region region : regions) {
                String sql = "    INSERT OR REPLACE INTO regions (\n        name, dimension, sound_event_id, sound_category, sound_volume, sound_pitch,\n        sound_loop_delay_ticks, entry_message, exit_message, entry_actionbar_message,\n        exit_actionbar_message, gamemode_on_entry, gamemode_on_exit, access_denied_message\n    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
                try (PreparedStatement stmt = conn.prepareStatement(sql);){
                    stmt.setString(1, region.getName());
                    stmt.setString(2, region.getDimension());
                    stmt.setString(3, region.getSoundEventId());
                    stmt.setString(4, region.getSoundCategory());
                    stmt.setFloat(5, region.getSoundVolume());
                    stmt.setFloat(6, region.getSoundPitch());
                    stmt.setInt(7, region.getSoundLoopDelayTicks());
                    stmt.setString(8, region.getEntryMessage());
                    stmt.setString(9, region.getExitMessage());
                    stmt.setString(10, region.getEntryActionbarMessage());
                    stmt.setString(11, region.getExitActionbarMessage());
                    stmt.setString(12, region.getGamemodeOnEntry());
                    stmt.setString(13, region.getGamemodeOnExit());
                    stmt.setString(14, region.getAccessDeniedMessage());
                    stmt.executeUpdate();
                }
                RegionDAO.deleteCuboids(conn, region.getName());
                RegionDAO.deleteTags(conn, region.getName());
                RegionDAO.saveCuboids(conn, region.getName(), region.getCuboids());
                RegionDAO.saveTags(conn, region.getName(), region.getTags());
            }
        });
        LOGGER.info("Batch saved {} regions to database", (Object)regions.size());
    }

    public static Map<String, Region> loadAllRegions() throws SQLException {
        HashMap<String, Region> regions = new HashMap<String, Region>();
        try (Connection conn = DatabaseManager.getConnection();){
            String sql = "SELECT * FROM regions";
            try (Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery(sql);){
                while (rs.next()) {
                    String regionName = rs.getString("name");
                    List<Cuboid> cuboids = RegionDAO.loadCuboids(conn, regionName);
                    if (cuboids.isEmpty()) {
                        LOGGER.warn("Region '{}' has no cuboids, skipping", (Object)regionName);
                        continue;
                    }
                    Set<String> tags = RegionDAO.loadTags(conn, regionName);
                    Region region = RegionDAO.reconstructRegion(rs, cuboids, tags);
                    regions.put(regionName, region);
                }
            }
        }
        LOGGER.info("Loaded {} regions from database", (Object)regions.size());
        return regions;
    }

    public static Region loadRegion(String name) throws SQLException {
        block24: {
            try (Connection conn = DatabaseManager.getConnection();){
                String sql = "SELECT * FROM regions WHERE name = ?";
                PreparedStatement stmt = conn.prepareStatement(sql);
                stmt.setString(1, name);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) break block24;
                List<Cuboid> cuboids = RegionDAO.loadCuboids(conn, name);
                if (cuboids.isEmpty()) {
                    LOGGER.warn("Region '{}' has no cuboids", (Object)name);
                    Region region = null;
                    return region;
                }
                Set<String> tags = RegionDAO.loadTags(conn, name);
                Region region = RegionDAO.reconstructRegion(rs, cuboids, tags);
                return region;
                {
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
        }
        return null;
    }

    public static void deleteRegion(String regionName) throws SQLException {
        try (Connection conn = DatabaseManager.getConnection();){
            String sql = "DELETE FROM regions WHERE name = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, regionName);
                int deleted = stmt.executeUpdate();
                if (deleted > 0) {
                    LOGGER.info("Deleted region '{}' from database", (Object)regionName);
                }
            }
        }
    }

    public static boolean regionExists(String regionName) throws SQLException {
        try (Connection conn = DatabaseManager.getConnection();){
            String sql = "SELECT COUNT(*) FROM regions WHERE name = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, regionName);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        boolean bl = rs.getInt(1) > 0;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    private static void saveCuboids(Connection conn, String regionName, List<Cuboid> cuboids) throws SQLException {
        String sql = "    INSERT INTO region_cuboids (region_name, min_x, min_y, min_z, max_x, max_y, max_z)\n    VALUES (?, ?, ?, ?, ?, ?, ?)\n";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            for (Cuboid cuboid : cuboids) {
                stmt.setString(1, regionName);
                stmt.setInt(2, cuboid.getMinX());
                stmt.setInt(3, cuboid.getMinY());
                stmt.setInt(4, cuboid.getMinZ());
                stmt.setInt(5, cuboid.getMaxX());
                stmt.setInt(6, cuboid.getMaxY());
                stmt.setInt(7, cuboid.getMaxZ());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
    }

    private static List<Cuboid> loadCuboids(Connection conn, String regionName) throws SQLException {
        ArrayList<Cuboid> cuboids = new ArrayList<Cuboid>();
        String sql = "SELECT * FROM region_cuboids WHERE region_name = ? ORDER BY id";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, regionName);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    Cuboid cuboid = new Cuboid(rs.getInt("min_x"), rs.getInt("min_y"), rs.getInt("min_z"), rs.getInt("max_x"), rs.getInt("max_y"), rs.getInt("max_z"));
                    cuboids.add(cuboid);
                }
            }
        }
        return cuboids;
    }

    private static void deleteCuboids(Connection conn, String regionName) throws SQLException {
        String sql = "DELETE FROM region_cuboids WHERE region_name = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, regionName);
            stmt.executeUpdate();
        }
    }

    private static void saveTags(Connection conn, String regionName, Set<String> tags) throws SQLException {
        if (tags == null || tags.isEmpty()) {
            return;
        }
        String sql = "INSERT INTO region_tags (region_name, tag) VALUES (?, ?)";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            for (String tag : tags) {
                stmt.setString(1, regionName);
                stmt.setString(2, tag);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
    }

    private static Set<String> loadTags(Connection conn, String regionName) throws SQLException {
        HashSet<String> tags = new HashSet<String>();
        String sql = "SELECT tag FROM region_tags WHERE region_name = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, regionName);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    tags.add(rs.getString("tag"));
                }
            }
        }
        return tags;
    }

    private static void deleteTags(Connection conn, String regionName) throws SQLException {
        String sql = "DELETE FROM region_tags WHERE region_name = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, regionName);
            stmt.executeUpdate();
        }
    }

    private static Region reconstructRegion(ResultSet rs, List<Cuboid> cuboids, Set<String> tags) throws SQLException {
        String name = rs.getString("name");
        String dimension = rs.getString("dimension");
        Region region = new Region(name, dimension, cuboids);
        region.setSound(rs.getString("sound_event_id"), rs.getString("sound_category"), rs.getFloat("sound_volume"), rs.getFloat("sound_pitch"), rs.getInt("sound_loop_delay_ticks"));
        region.setEntryMessage(rs.getString("entry_message"));
        region.setExitMessage(rs.getString("exit_message"));
        region.setEntryActionbarMessage(rs.getString("entry_actionbar_message"));
        region.setExitActionbarMessage(rs.getString("exit_actionbar_message"));
        region.setGamemodeOnEntry(rs.getString("gamemode_on_entry"));
        region.setGamemodeOnExit(rs.getString("gamemode_on_exit"));
        region.setAccessDeniedMessage(rs.getString("access_denied_message"));
        for (String tag : tags) {
            region.addTag(tag);
        }
        return region;
    }
}

