/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.database.DatabaseManager;
import world.landfall.landfallessentials.regions.RegionRental;

public class RentalDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(RentalDAO.class);

    public static void saveRental(RegionRental.RentalInfo rental) throws SQLException {
        DatabaseManager.executeTransaction(conn -> {
            String sql = "    INSERT OR REPLACE INTO rentals (\n        region_name, renter_uuid, renter_name, expiration_time, karma_price, rented_at\n    ) VALUES (?, ?, ?, ?, ?, ?)\n";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, rental.getRegionName());
                stmt.setString(2, rental.getRenterUUID().toString());
                stmt.setString(3, rental.getRenterName());
                stmt.setLong(4, rental.getExpirationTime());
                stmt.setInt(5, rental.getKarmaPrice());
                stmt.setLong(6, rental.getRentedAt());
                stmt.executeUpdate();
            }
            RentalDAO.deleteTrustedPlayers(conn, rental.getRegionName());
            RentalDAO.saveTrustedPlayers(conn, rental.getRegionName(), rental.getTrustedPlayers());
        });
    }

    public static void saveRentals(Collection<RegionRental.RentalInfo> rentals) throws SQLException {
        if (rentals == null || rentals.isEmpty()) {
            return;
        }
        DatabaseManager.executeTransaction(conn -> {
            for (RegionRental.RentalInfo rental : rentals) {
                String sql = "    INSERT OR REPLACE INTO rentals (\n        region_name, renter_uuid, renter_name, expiration_time, karma_price, rented_at\n    ) VALUES (?, ?, ?, ?, ?, ?)\n";
                try (PreparedStatement stmt = conn.prepareStatement(sql);){
                    stmt.setString(1, rental.getRegionName());
                    stmt.setString(2, rental.getRenterUUID().toString());
                    stmt.setString(3, rental.getRenterName());
                    stmt.setLong(4, rental.getExpirationTime());
                    stmt.setInt(5, rental.getKarmaPrice());
                    stmt.setLong(6, rental.getRentedAt());
                    stmt.executeUpdate();
                }
                RentalDAO.deleteTrustedPlayers(conn, rental.getRegionName());
                RentalDAO.saveTrustedPlayers(conn, rental.getRegionName(), rental.getTrustedPlayers());
            }
        });
        LOGGER.info("Batch saved {} rentals to database", (Object)rentals.size());
    }

    public static Map<String, RegionRental.RentalInfo> loadAllRentals() throws SQLException {
        HashMap<String, RegionRental.RentalInfo> rentals = new HashMap<String, RegionRental.RentalInfo>();
        try (Connection conn = DatabaseManager.getConnection();){
            String sql = "SELECT * FROM rentals";
            try (Statement stmt = conn.createStatement();
                 ResultSet rs = stmt.executeQuery(sql);){
                while (rs.next()) {
                    String regionName = rs.getString("region_name");
                    Set<String> trustedPlayers = RentalDAO.loadTrustedPlayers(conn, regionName);
                    RegionRental.RentalInfo rental = RentalDAO.reconstructRental(rs, trustedPlayers);
                    rentals.put(regionName, rental);
                }
            }
        }
        LOGGER.info("Loaded {} rentals from database", (Object)rentals.size());
        return rentals;
    }

    public static RegionRental.RentalInfo loadRental(String regionName) throws SQLException {
        try (Connection conn = DatabaseManager.getConnection();){
            String sql = "SELECT * FROM rentals WHERE region_name = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, regionName);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        Set<String> trustedPlayers = RentalDAO.loadTrustedPlayers(conn, regionName);
                        RegionRental.RentalInfo rentalInfo = RentalDAO.reconstructRental(rs, trustedPlayers);
                        return rentalInfo;
                    }
                }
            }
        }
        return null;
    }

    public static void deleteRental(String regionName) throws SQLException {
        try (Connection conn = DatabaseManager.getConnection();){
            String sql = "DELETE FROM rentals WHERE region_name = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, regionName);
                int deleted = stmt.executeUpdate();
                if (deleted > 0) {
                    LOGGER.info("Deleted rental for region '{}' from database", (Object)regionName);
                }
            }
        }
    }

    public static List<String> getExpiredRentals(long currentTime) throws SQLException {
        ArrayList<String> expiredRegions = new ArrayList<String>();
        try (Connection conn = DatabaseManager.getConnection();){
            String sql = "SELECT region_name FROM rentals WHERE expiration_time < ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setLong(1, currentTime);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        expiredRegions.add(rs.getString("region_name"));
                    }
                }
            }
        }
        return expiredRegions;
    }

    public static List<String> getRentalsByPlayer(UUID renterUUID) throws SQLException {
        ArrayList<String> regions = new ArrayList<String>();
        try (Connection conn = DatabaseManager.getConnection();){
            String sql = "SELECT region_name FROM rentals WHERE renter_uuid = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, renterUUID.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        regions.add(rs.getString("region_name"));
                    }
                }
            }
        }
        return regions;
    }

    public static boolean rentalExists(String regionName) throws SQLException {
        try (Connection conn = DatabaseManager.getConnection();){
            String sql = "SELECT COUNT(*) FROM rentals WHERE region_name = ?";
            try (PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, regionName);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        boolean bl = rs.getInt(1) > 0;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    private static void saveTrustedPlayers(Connection conn, String regionName, Set<String> trustedPlayers) throws SQLException {
        if (trustedPlayers == null || trustedPlayers.isEmpty()) {
            return;
        }
        String sql = "INSERT INTO rental_trusted (region_name, player_name) VALUES (?, ?)";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            for (String playerName : trustedPlayers) {
                stmt.setString(1, regionName);
                stmt.setString(2, playerName);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
    }

    private static Set<String> loadTrustedPlayers(Connection conn, String regionName) throws SQLException {
        HashSet<String> trustedPlayers = new HashSet<String>();
        String sql = "SELECT player_name FROM rental_trusted WHERE region_name = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, regionName);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    trustedPlayers.add(rs.getString("player_name"));
                }
            }
        }
        return trustedPlayers;
    }

    private static void deleteTrustedPlayers(Connection conn, String regionName) throws SQLException {
        String sql = "DELETE FROM rental_trusted WHERE region_name = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, regionName);
            stmt.executeUpdate();
        }
    }

    private static RegionRental.RentalInfo reconstructRental(ResultSet rs, Set<String> trustedPlayers) throws SQLException {
        String regionName = rs.getString("region_name");
        UUID renterUUID = UUID.fromString(rs.getString("renter_uuid"));
        String renterName = rs.getString("renter_name");
        long expirationTime = rs.getLong("expiration_time");
        int karmaPrice = rs.getInt("karma_price");
        long rentedAt = rs.getLong("rented_at");
        RegionRental.RentalInfo rental = new RegionRental.RentalInfo(regionName, renterUUID, renterName, expirationTime, karmaPrice);
        for (String player : trustedPlayers) {
            rental.addTrustedPlayer(player);
        }
        return rental;
    }
}

