/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.event;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.event.MobSpawnHandler;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;

public class MobSpawnCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(MobSpawnCache.class);
    private static final Map<String, CacheEntry> chunkCache = new ConcurrentHashMap<String, CacheEntry>();
    private static long lastCleanup = System.currentTimeMillis();
    private static final long CLEANUP_INTERVAL = TimeUnit.MINUTES.toMillis(5L);

    public static SpawnRule getSpawnRule(BlockPos pos, String dimension) {
        return MobSpawnCache.computeSpawnRule(pos, dimension);
    }

    private static SpawnRule computeSpawnRule(BlockPos pos, String dimension) {
        List<Region> regions = RegionManager.getRegionsAt(pos, dimension);
        if (regions.isEmpty()) {
            return SpawnRule.ALLOW_ALL;
        }
        SpawnRule mostRestrictive = SpawnRule.ALLOW_ALL;
        for (Region region : regions) {
            SpawnRule regionRule = MobSpawnHandler.getRegionSpawnRule(region.getName());
            if (regionRule == SpawnRule.NO_MOBS) {
                return SpawnRule.NO_MOBS;
            }
            if (regionRule != SpawnRule.PEACEFUL || mostRestrictive != SpawnRule.ALLOW_ALL) continue;
            mostRestrictive = SpawnRule.PEACEFUL;
        }
        return mostRestrictive;
    }

    private static String getCacheKey(BlockPos pos, String dimension) {
        ChunkPos chunkPos = new ChunkPos(pos);
        return dimension + ":" + chunkPos.x + "," + chunkPos.z;
    }

    public static void invalidateRegion(String regionName) {
        Region region = RegionManager.getRegion(regionName);
        if (region == null) {
            return;
        }
        String dimension = region.getDimension();
        int minChunkX = region.getMinX() >> 4;
        int maxChunkX = region.getMaxX() >> 4;
        int minChunkZ = region.getMinZ() >> 4;
        int maxChunkZ = region.getMaxZ() >> 4;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                String cacheKey = dimension + ":" + cx + "," + cz;
                chunkCache.remove(cacheKey);
            }
        }
    }

    public static void clearCache() {
        chunkCache.clear();
    }

    private static void cleanupCache() {
        long now = System.currentTimeMillis();
        if (now - lastCleanup < CLEANUP_INTERVAL) {
            return;
        }
        chunkCache.entrySet().removeIf(entry -> ((CacheEntry)entry.getValue()).isExpired());
        lastCleanup = now;
        LOGGER.debug("Cleaned up expired cache entries, {} entries remaining", (Object)chunkCache.size());
    }

    public static int getCacheSize() {
        return chunkCache.size();
    }

    public static void onConfigReloaded() {
        MobSpawnCache.clearCache();
        MobSpawnHandler.updateSpawnControlFlags();
    }

    public static enum SpawnRule {
        ALLOW_ALL,
        PEACEFUL,
        NO_MOBS;

    }

    private static class CacheEntry {
        final SpawnRule rule;
        final long timestamp;

        CacheEntry(SpawnRule rule) {
            this.rule = rule;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > Config.mobSpawnControlCacheTTL;
        }
    }
}

