/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.home;

import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.util.LuckPermsUtil;

public class HomeLuckPermsIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(HomeLuckPermsIntegration.class);
    private static final String HOME_BONUS_PERMISSION_PREFIX = "landfallessentials.home.bonus.";
    private static final String HOME_COOLDOWN_PERMISSION_PREFIX = "landfallessentials.home.cooldown.";
    private static final String HOME_BONUS_META_KEY = "landfallessentials.home.bonus";
    private static final String HOME_COOLDOWN_META_KEY = "landfallessentials.home.cooldown";

    public static void initialize() {
        LuckPermsUtil.initialize();
        if (LuckPermsUtil.isAvailable()) {
            LOGGER.info("Home LuckPerms integration: Bonus homes and cooldown overrides active.");
        } else {
            LOGGER.info("Home LuckPerms integration: LuckPerms not available, bonuses/overrides disabled.");
        }
    }

    public static int getBonusHomes(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient() || player == null || player.getServer() == null || !LuckPermsUtil.isAvailable()) {
            return 0;
        }
        try {
            Object user = LuckPermsUtil.getUser(player.getUUID());
            if (user == null) {
                return 0;
            }
            int permissionBonus = HomeLuckPermsIntegration.getBonusHomesFromPermissions(user);
            if (permissionBonus > 0) {
                return permissionBonus;
            }
            return HomeLuckPermsIntegration.getBonusHomesFromMeta(user);
        }
        catch (Exception e) {
            LOGGER.warn("Error getting bonus homes from LuckPerms for player " + player.getName().getString(), (Throwable)e);
            return 0;
        }
    }

    public static long getCooldownOverride(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient() || player == null || player.getServer() == null || !LuckPermsUtil.isAvailable()) {
            return -1L;
        }
        try {
            Object user = LuckPermsUtil.getUser(player.getUUID());
            if (user == null) {
                return -1L;
            }
            long permissionCooldown = HomeLuckPermsIntegration.getCooldownFromPermissions(user);
            if (permissionCooldown >= 0L) {
                return permissionCooldown;
            }
            return HomeLuckPermsIntegration.getCooldownFromMeta(user);
        }
        catch (Exception e) {
            LOGGER.warn("Error getting cooldown override from LuckPerms for player " + player.getName().getString(), (Throwable)e);
            return -1L;
        }
    }

    private static int getBonusHomesFromPermissions(Object user) {
        int[] commonBonuses;
        Object permissionData = LuckPermsUtil.getPermissionData(user);
        if (permissionData == null) {
            return 0;
        }
        int highestBonus = 0;
        for (int bonus : commonBonuses = new int[]{1, 2, 3, 4, 5, 10, 15, 20, 25, 30, 50, 100}) {
            String permissionNode = HOME_BONUS_PERMISSION_PREFIX + bonus;
            if (!LuckPermsUtil.checkPermission(permissionData, permissionNode) || bonus <= highestBonus) continue;
            highestBonus = bonus;
        }
        return highestBonus;
    }

    private static long getCooldownFromPermissions(Object user) {
        long[] commonCooldowns;
        Object permissionData = LuckPermsUtil.getPermissionData(user);
        if (permissionData == null) {
            return -1L;
        }
        long lowestCooldown = -1L;
        for (long cooldown : commonCooldowns = new long[]{0L, 5L, 10L, 15L, 30L, 45L, 60L, 120L, 180L, 300L, 600L}) {
            String permissionNode = HOME_COOLDOWN_PERMISSION_PREFIX + cooldown;
            if (!LuckPermsUtil.checkPermission(permissionData, permissionNode) || lowestCooldown != -1L && cooldown >= lowestCooldown) continue;
            lowestCooldown = cooldown;
        }
        return lowestCooldown;
    }

    private static int getBonusHomesFromMeta(Object user) {
        Object metaData = LuckPermsUtil.getMetaData(user);
        if (metaData == null) {
            return 0;
        }
        String metaValue = LuckPermsUtil.getMetaValue(metaData, HOME_BONUS_META_KEY);
        if (metaValue == null || metaValue.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(metaValue);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid home bonus meta value '{}' for player {}", (Object)metaValue, (Object)"<UUID_UNAVAILABLE>");
            return 0;
        }
    }

    private static long getCooldownFromMeta(Object user) {
        Object metaData = LuckPermsUtil.getMetaData(user);
        if (metaData == null) {
            return -1L;
        }
        String metaValue = LuckPermsUtil.getMetaValue(metaData, HOME_COOLDOWN_META_KEY);
        if (metaValue == null || metaValue.isEmpty()) {
            return -1L;
        }
        try {
            return Long.parseLong(metaValue);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid home cooldown meta value '{}' for player {}", (Object)metaValue, (Object)"<UUID_UNAVAILABLE>");
            return -1L;
        }
    }

    public static boolean isAvailable() {
        return LuckPermsUtil.isAvailable();
    }

    public static String getStatus() {
        if (FMLEnvironment.dist.isClient()) {
            return "Client side";
        }
        return LuckPermsUtil.isAvailable() ? "Active" : "Disabled / Not Initialized";
    }
}

