/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.item.custom;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ItemWithLore
extends Item {
    private final List<Component> lore;

    public ItemWithLore(Item.Properties properties, List<String> loreLines) {
        super(properties);
        this.lore = loreLines.stream().map(Component::literal).collect(Collectors.toList());
    }

    public ItemWithLore(Item.Properties properties, String ... loreLines) {
        this(properties, Arrays.asList(loreLines));
    }

    public void appendHoverText(ItemStack pStack, @Nullable Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pIsAdvanced);
        if (this.lore != null && !this.lore.isEmpty()) {
            pTooltipComponents.addAll(this.lore);
        }
    }
}

