/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.karma;

import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueMapIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueMapIntegration.class);
    private static volatile boolean initialized = false;
    private static volatile boolean blueMapAvailable = false;
    private static volatile Object blueMapAPI = null;
    private static Consumer<Object> enableListener = null;
    private static Consumer<Object> disableListener = null;

    public static synchronized void initialize() {
        if (initialized) {
            return;
        }
        try {
            Class<?> blueMapAPIClass = Class.forName("de.bluecolored.bluemap.api.BlueMapAPI");
            enableListener = api -> {
                blueMapAPI = api;
                blueMapAvailable = true;
                LOGGER.info("BlueMap integration enabled");
            };
            disableListener = api -> {
                blueMapAPI = null;
                blueMapAvailable = false;
                LOGGER.info("BlueMap integration disabled");
            };
            blueMapAPIClass.getMethod("onEnable", Consumer.class).invoke(null, enableListener);
            blueMapAPIClass.getMethod("onDisable", Consumer.class).invoke(null, disableListener);
            LOGGER.debug("BlueMap integration listeners registered");
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("BlueMap not found, using fallback visibility");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to initialize BlueMap integration", (Throwable)e);
        }
        initialized = true;
    }

    public static synchronized void cleanup() {
        if (!initialized) {
            return;
        }
        try {
            if (enableListener != null || disableListener != null) {
                Class<?> blueMapAPIClass = Class.forName("de.bluecolored.bluemap.api.BlueMapAPI");
                if (enableListener != null) {
                    blueMapAPIClass.getMethod("unregisterListener", Consumer.class).invoke(null, enableListener);
                }
                if (disableListener != null) {
                    blueMapAPIClass.getMethod("unregisterListener", Consumer.class).invoke(null, disableListener);
                }
                LOGGER.debug("BlueMap integration listeners unregistered");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error during BlueMap integration cleanup", (Throwable)e);
        }
        blueMapAPI = null;
        blueMapAvailable = false;
        enableListener = null;
        disableListener = null;
        initialized = false;
    }

    public static boolean isPlayerVisible(ServerPlayer player) {
        if (!blueMapAvailable || blueMapAPI == null) {
            return true;
        }
        try {
            return BlueMapIntegration.getPlayerVisibility(player.getUUID());
        }
        catch (Exception e) {
            LOGGER.debug("Error checking player visibility, using fallback: {}", (Object)e.getMessage());
            return true;
        }
    }

    public static boolean setPlayerVisibility(ServerPlayer player, boolean visible) {
        if (!blueMapAvailable || blueMapAPI == null) {
            return false;
        }
        try {
            return BlueMapIntegration.updatePlayerVisibility(player.getUUID(), visible);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set player visibility: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean isAvailable() {
        return blueMapAvailable && blueMapAPI != null;
    }

    public static String getStatus() {
        if (!initialized) {
            return "Not initialized";
        }
        return blueMapAvailable ? "Active" : "Fallback";
    }

    private static boolean getPlayerVisibility(UUID playerUUID) throws Exception {
        Object webApp = BlueMapIntegration.getWebApp();
        if (webApp == null) {
            return true;
        }
        Boolean isVisible = (Boolean)webApp.getClass().getMethod("getPlayerVisibility", UUID.class).invoke(webApp, playerUUID);
        return isVisible != null ? isVisible : true;
    }

    private static boolean updatePlayerVisibility(UUID playerUUID, boolean visible) throws Exception {
        Object webApp = BlueMapIntegration.getWebApp();
        if (webApp == null) {
            return false;
        }
        webApp.getClass().getMethod("setPlayerVisibility", UUID.class, Boolean.TYPE).invoke(webApp, playerUUID, visible);
        return true;
    }

    private static Object getWebApp() throws Exception {
        if (blueMapAPI == null) {
            return null;
        }
        return blueMapAPI.getClass().getMethod("getWebApp", new Class[0]).invoke(blueMapAPI, new Object[0]);
    }
}

