/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.karma;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import world.landfall.landfallessentials.karma.BlueMapIntegration;
import world.landfall.landfallessentials.karma.KarmaSystem;
import world.landfall.landfallessentials.karma.LuckPermsIntegration;

@EventBusSubscriber
public class KarmaCommands {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"karma").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            int currentKarma = KarmaSystem.getKarma((Player)player);
            double totalKarma = KarmaSystem.getTotalKarma((Player)player);
            double fractionalPart = totalKarma - (double)currentKarma;
            String donorLevel = KarmaSystem.getDonorLevel((Player)player);
            boolean isVisible = KarmaSystem.isPlayerVisible(player);
            int nearbyPlayers = KarmaSystem.calculateGroupBonus(player, 50);
            double donorBonus = KarmaSystem.getDonorBonus((Player)player);
            String visibilityText = isVisible ? "\u00a7aActive" : "\u00a7cInactive";
            Object groupBonusText = nearbyPlayers > 0 ? "\u00a7aActive (+" + nearbyPlayers + ")" : "\u00a7cInactive";
            String donorText = donorBonus > 0.0 ? "\u00a7a" + donorLevel + " (+" + donorBonus + ")" : "\u00a7cNone";
            Object karmaDisplay = fractionalPart > 0.0 ? String.format("\u00a77%d\u00a78.%02d", currentKarma, (int)(fractionalPart * 100.0)) : "\u00a77" + currentKarma + "\u00a78.00";
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eYour current Karma: " + (String)karmaDisplay)));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eGroup Activity: " + (String)groupBonusText)));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a7eDonor Status: " + donorText)));
            return 1;
        })).then(Commands.literal((String)"info").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7e--- \u00a76Karma System Info \u00a7e---"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76How to Earn Karma:"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a77- \u00a7a+1 karma \u00a77every 60 seconds you are active (not AFK)."));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a77- \u00a7aGroup Activity Bonus: \u00a7e+n \u00a77, with n being other players within \u00a7a50 blocks."));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a77- \u00a7aDonor Bonus: \u00a77Additional karma to reward your contributions to server hosting costs."));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a77  \u00a78(Managed through LuckPerms permissions)"));
            player.sendSystemMessage((Component)Component.literal((String)" "));
            if (BlueMapIntegration.isAvailable()) {
                player.sendSystemMessage((Component)Component.literal((String)"\u00a76Map Visibility Commands:"));
                player.sendSystemMessage((Component)Component.literal((String)"\u00a77- \u00a7e/map \u00a77- Check your current visibility status"));
                player.sendSystemMessage((Component)Component.literal((String)"\u00a77- \u00a7e/map show \u00a77- Show yourself on the web map"));
                player.sendSystemMessage((Component)Component.literal((String)"\u00a77- \u00a7e/map hide \u00a77- Hide yourself from the web map"));
                player.sendSystemMessage((Component)Component.literal((String)"\u00a77- \u00a7e/map toggle \u00a77- Toggle your visibility"));
                player.sendSystemMessage((Component)Component.literal((String)" "));
            }
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76How to Use Karma \u00a77(Commands available to admins):"));
            MutableComponent karmaGetCmd = Component.literal((String)"\u00a7a/karma get <player>").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/karma get ")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Get a player's karma points"))));
            MutableComponent karmaSetCmd = Component.literal((String)"\u00a7a/karma set <player> <amount>").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/karma set ")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Set a player's karma points"))));
            MutableComponent karmaAddCmd = Component.literal((String)"\u00a7a/karma add <player> <amount>").withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/karma add ")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Add karma points to a player"))));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a77- ").append((Component)karmaGetCmd));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a77- ").append((Component)karmaSetCmd));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a77- ").append((Component)karmaAddCmd));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").requires(source -> source.hasPermission(2))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String blueMapStatus = KarmaSystem.getBlueMapStatus();
            String luckPermsStatus = KarmaSystem.getLuckPermsStatus();
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7e--- \u00a76Karma System Debug \u00a7e---"));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a76BlueMap Integration: \u00a77" + blueMapStatus)));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a76LuckPerms Integration: \u00a77" + luckPermsStatus)));
            boolean isVisible = KarmaSystem.isPlayerVisible(player);
            int nearbyPlayers = KarmaSystem.calculateGroupBonus(player, 50);
            String donorLevel = KarmaSystem.getDonorLevel((Player)player);
            double donorBonus = KarmaSystem.getDonorBonus((Player)player);
            double totalBonus = KarmaSystem.calculateTotalBonus(player);
            player.sendSystemMessage((Component)Component.literal((String)"\u00a76Current Bonuses:"));
            player.sendSystemMessage((Component)Component.literal((String)"\u00a77- Base: \u00a7a1.0"));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a77- Visibility: \u00a7c0.0 \u00a77(" + (isVisible ? "visible" : "hidden") + ")")));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a77- Group Activity: \u00a7a+" + nearbyPlayers + " \u00a77(" + nearbyPlayers + " nearby players)")));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a77- Donor: \u00a7a+" + donorBonus + " \u00a77(" + (donorLevel.isEmpty() ? "none" : donorLevel) + ")")));
            player.sendSystemMessage((Component)Component.literal((String)("\u00a76Total Bonus: \u00a7a" + String.format("%.2f", totalBonus) + " karma per minute")));
            return 1;
        })).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"target");
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String donorLevel = KarmaSystem.getDonorLevel((Player)target);
            double donorBonus = KarmaSystem.getDonorBonus((Player)target);
            sender.sendSystemMessage((Component)Component.literal((String)("\u00a7e--- \u00a76Debug for " + target.getName().getString() + " \u00a7e---")));
            sender.sendSystemMessage((Component)Component.literal((String)("\u00a76UUID: \u00a77" + String.valueOf(target.getUUID()))));
            sender.sendSystemMessage((Component)Component.literal((String)("\u00a76Donor Level: \u00a77" + (donorLevel.isEmpty() ? "none" : donorLevel))));
            sender.sendSystemMessage((Component)Component.literal((String)("\u00a76Donor Bonus: \u00a77" + donorBonus)));
            sender.sendSystemMessage((Component)Component.literal((String)("\u00a76LuckPerms Available: \u00a77" + LuckPermsIntegration.isAvailable())));
            sender.sendSystemMessage((Component)Component.literal((String)"\u00a7eCheck server console for detailed permission logs"));
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"get").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"target");
            int karma = KarmaSystem.getKarma((Player)target);
            double totalKarma = KarmaSystem.getTotalKarma((Player)target);
            double fractionalPart = totalKarma - (double)karma;
            Object karmaDisplay = fractionalPart > 0.0 ? String.format("\u00a77%d\u00a78.%02d", karma, (int)(fractionalPart * 100.0)) : "\u00a77" + karma + "\u00a78.00";
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> KarmaCommands.lambda$registerCommands$9(target, (String)karmaDisplay), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"target");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            KarmaSystem.setKarma((Player)target, amount);
            target.sendSystemMessage((Component)Component.literal((String)("\u00a7eYour Karma has been set to: \u00a7a" + amount)));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7eSet Karma for " + target.getName().getString() + " to \u00a7a" + amount)), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"target");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            KarmaSystem.addKarma((Player)target, amount);
            target.sendSystemMessage((Component)Component.literal((String)("\u00a7eYour Karma has been increased by: \u00a7a" + amount)));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7eAdded \u00a7a" + amount + " \u00a7eKarma to " + target.getName().getString())), true);
            return 1;
        })))).then(Commands.literal((String)"@a").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            List players = ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayers();
            for (ServerPlayer player : players) {
                KarmaSystem.addKarma((Player)player, amount);
                player.sendSystemMessage((Component)Component.literal((String)("\u00a7eYour Karma has been increased by: \u00a7a" + amount)));
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a7eAdded \u00a7a" + amount + " \u00a7eKarma to all players (" + players.size() + " players affected)")), true);
            return 1;
        })))));
    }

    private static /* synthetic */ Component lambda$registerCommands$9(ServerPlayer target, String karmaDisplay) {
        return Component.literal((String)("\u00a7e" + target.getName().getString() + "'s Karma: " + karmaDisplay));
    }
}

