/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.moderation;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.moderation.ModListPacket;
import world.landfall.landfallessentials.moderation.ModListRequestPacket;
import world.landfall.landfallessentials.moderation.ResourcePackListPacket;

@OnlyIn(value=Dist.CLIENT)
public class ModerationClientHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModerationClientHandler.class);
    private static final int MAX_DESCRIPTION_LENGTH = 200;
    private static final int TIMEOUT_SECONDS = 5;

    public static void handleModListRequest(ModListRequestPacket.RequestType requestType) {
        if (!Minecraft.getInstance().isRunning()) {
            LOGGER.warn("Received mod list request while game is not running");
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                switch (requestType) {
                    case MODS_ONLY: {
                        List<ModListPacket.ModInfo> mods = ModerationClientHandler.collectModInfo();
                        ModListPacket packet = new ModListPacket(mods, new ArrayList<ModListPacket.ResourcePackInfo>());
                        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                        LOGGER.debug("Sent mod data to server: {} mods", (Object)mods.size());
                        break;
                    }
                    case RESOURCE_PACKS_ONLY: {
                        List<ResourcePackListPacket.ResourcePackInfo> resourcePacks = ModerationClientHandler.collectResourcePackInfo();
                        ResourcePackListPacket packet = new ResourcePackListPacket(resourcePacks);
                        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                        LOGGER.debug("Sent resource pack data to server: {} resource packs", (Object)resourcePacks.size());
                        break;
                    }
                    case BOTH: {
                        List<ModListPacket.ModInfo> mods = ModerationClientHandler.collectModInfo();
                        List<ResourcePackListPacket.ResourcePackInfo> resourcePacks = ModerationClientHandler.collectResourcePackInfo();
                        List<ModListPacket.ResourcePackInfo> convertedPacks = ModerationClientHandler.convertResourcePackInfo(resourcePacks);
                        ModListPacket packet = new ModListPacket(mods, convertedPacks);
                        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
                        LOGGER.debug("Sent mod data to server: {} mods, {} resource packs", (Object)mods.size(), (Object)resourcePacks.size());
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to collect and send mod data", (Throwable)e);
            }
        }).orTimeout(5L, TimeUnit.SECONDS).exceptionally(throwable -> {
            LOGGER.error("Failed to process mod list request", throwable);
            return null;
        });
    }

    private static List<ModListPacket.ResourcePackInfo> convertResourcePackInfo(List<ResourcePackListPacket.ResourcePackInfo> resourcePacks) {
        if (resourcePacks == null) {
            return new ArrayList<ModListPacket.ResourcePackInfo>();
        }
        return resourcePacks.stream().map(rp -> new ModListPacket.ResourcePackInfo(ModerationClientHandler.sanitizeString(rp.id()), ModerationClientHandler.sanitizeString(rp.title()), ModerationClientHandler.sanitizeString(rp.description()), ModerationClientHandler.sanitizeString(rp.source()))).toList();
    }

    private static List<ModListPacket.ModInfo> collectModInfo() {
        ArrayList<ModListPacket.ModInfo> mods = new ArrayList<ModListPacket.ModInfo>();
        try {
            ModList modList = ModList.get();
            if (modList == null) {
                LOGGER.error("ModList is null");
                return mods;
            }
            modList.forEachModContainer((modId, container) -> {
                try {
                    if (container != null && container.getModInfo() != null) {
                        String displayName = ModerationClientHandler.sanitizeString(container.getModInfo().getDisplayName());
                        String version = ModerationClientHandler.sanitizeString(container.getModInfo().getVersion().toString());
                        Object description = ModerationClientHandler.sanitizeString(container.getModInfo().getDescription());
                        if (((String)description).length() > 200) {
                            description = ((String)description).substring(0, 197) + "...";
                        }
                        mods.add(new ModListPacket.ModInfo((String)modId, displayName, version, (String)description));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to collect info for mod {}", modId, (Object)e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to collect mod information", (Throwable)e);
        }
        return mods;
    }

    private static List<ResourcePackListPacket.ResourcePackInfo> collectResourcePackInfo() {
        ArrayList<ResourcePackListPacket.ResourcePackInfo> resourcePacks = new ArrayList<ResourcePackListPacket.ResourcePackInfo>();
        try {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft == null) {
                LOGGER.error("Minecraft instance is null");
                return resourcePacks;
            }
            PackRepository packRepository = minecraft.getResourcePackRepository();
            if (packRepository == null) {
                LOGGER.error("Pack repository is null");
                return resourcePacks;
            }
            for (Pack pack : packRepository.getAvailablePacks()) {
                try {
                    String id = pack.getId();
                    if (id.startsWith("mod/")) continue;
                    String title = ModerationClientHandler.sanitizeString(pack.getTitle().getString());
                    Object description = ModerationClientHandler.sanitizeString(pack.getDescription().getString());
                    Object source = "File";
                    String packSourceName = pack.getPackSource().toString();
                    if (packSourceName.contains("DEFAULT") || packSourceName.contains("BUILT_IN")) {
                        source = "Built-in";
                    } else if (packSourceName.contains("FEATURE")) {
                        source = "Feature";
                    } else if (packSourceName.contains("WORLD")) {
                        source = "World";
                    } else if (packSourceName.contains("SERVER") && id.startsWith("server/")) {
                        source = "Server";
                    } else if (id.equals("vanilla")) {
                        source = "Vanilla";
                    } else if (id.startsWith("file/")) {
                        source = "File";
                    }
                    boolean isActive = packRepository.getSelectedPacks().contains(pack);
                    if (isActive) {
                        source = (String)source + " (Active)";
                    }
                    if (((String)description).length() > 200) {
                        description = ((String)description).substring(0, 197) + "...";
                    }
                    resourcePacks.add(new ResourcePackListPacket.ResourcePackInfo(id, title, (String)description, (String)source));
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to collect info for resource pack {}", (Object)pack.getId(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to collect resource pack information", (Throwable)e);
        }
        return resourcePacks;
    }

    private static String sanitizeString(String input) {
        if (input == null) {
            return "";
        }
        return input.replaceAll("[\\p{C}]", "").trim();
    }
}

