/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.moderation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.moderation.ModListPacket;
import world.landfall.landfallessentials.moderation.ModListRequestPacket;
import world.landfall.landfallessentials.moderation.ResourcePackListPacket;
import world.landfall.landfallessentials.moderation.approval.ClientApprovalSystem;

public class ModerationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModerationManager.class);
    private static final Map<UUID, PlayerModData> playerModData = new ConcurrentHashMap<UUID, PlayerModData>();
    private static final Map<UUID, Long> lastRequestTime = new ConcurrentHashMap<UUID, Long>();
    private static final long REQUEST_COOLDOWN_MS = TimeUnit.SECONDS.toMillis(5L);

    public static void updatePlayerModData(UUID playerUUID, List<ModListPacket.ModInfo> mods, List<ModListPacket.ResourcePackInfo> resourcePacks) {
        if (playerUUID == null || mods == null || resourcePacks == null) {
            LOGGER.warn("Attempted to update player mod data with null values");
            return;
        }
        try {
            PlayerModData data = new PlayerModData(new ArrayList<ModListPacket.ModInfo>(mods), new ArrayList<ModListPacket.ResourcePackInfo>(resourcePacks), System.currentTimeMillis());
            playerModData.put(playerUUID, data);
            LOGGER.debug("Updated mod data for player {}: {} mods, {} resource packs", new Object[]{playerUUID, mods.size(), resourcePacks.size()});
            CompletableFuture.runAsync(() -> {
                try {
                    for (ModListPacket.ModInfo mod : mods) {
                        ClientApprovalSystem.evaluateModStatus(mod.modId(), mod.displayName());
                    }
                    for (ModListPacket.ResourcePackInfo pack : resourcePacks) {
                        ClientApprovalSystem.evaluateResourcepackStatus(pack.id(), pack.title());
                    }
                    LOGGER.debug("Logged {} mods and {} resourcepacks to database for player {}", new Object[]{mods.size(), resourcePacks.size(), playerUUID});
                }
                catch (Exception e) {
                    LOGGER.error("Failed to log mod/resourcepack data to database for player {}", (Object)playerUUID, (Object)e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to update player mod data for {}", (Object)playerUUID, (Object)e);
        }
    }

    public static void updatePlayerResourcePackData(UUID playerUUID, List<ResourcePackListPacket.ResourcePackInfo> resourcePacks) {
        if (playerUUID == null || resourcePacks == null) {
            LOGGER.warn("Attempted to update player resource pack data with null values");
            return;
        }
        try {
            PlayerModData existingData = playerModData.get(playerUUID);
            ArrayList<ModListPacket.ModInfo> existingMods = existingData != null ? new ArrayList<ModListPacket.ModInfo>(existingData.getMods()) : new ArrayList();
            List<ModListPacket.ResourcePackInfo> convertedResourcePacks = resourcePacks.stream().map(rp -> new ModListPacket.ResourcePackInfo(rp.id(), rp.title(), rp.description(), rp.source())).toList();
            PlayerModData data = new PlayerModData(existingMods, convertedResourcePacks, System.currentTimeMillis());
            playerModData.put(playerUUID, data);
            LOGGER.debug("Updated resource pack data for player {}: {} resource packs", (Object)playerUUID, (Object)resourcePacks.size());
            CompletableFuture.runAsync(() -> {
                try {
                    for (ResourcePackListPacket.ResourcePackInfo pack : resourcePacks) {
                        ClientApprovalSystem.evaluateResourcepackStatus(pack.id(), pack.title());
                    }
                    LOGGER.debug("Logged {} resourcepacks to database for player {}", (Object)resourcePacks.size(), (Object)playerUUID);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to log resourcepack data to database for player {}", (Object)playerUUID, (Object)e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to update player resource pack data for {}", (Object)playerUUID, (Object)e);
        }
    }

    public static PlayerModData getPlayerModData(UUID playerUUID) {
        if (playerUUID == null) {
            return null;
        }
        return playerModData.get(playerUUID);
    }

    public static void removePlayerModData(UUID playerUUID) {
        if (playerUUID == null) {
            return;
        }
        PlayerModData removedData = playerModData.remove(playerUUID);
        lastRequestTime.remove(playerUUID);
        if (removedData != null) {
            LOGGER.debug("Removed mod data for player {}", (Object)playerUUID);
        } else {
            LOGGER.debug("Attempted to remove mod data for player {}, but no data was found.", (Object)playerUUID);
        }
    }

    public static boolean requestModDataFromPlayer(ServerPlayer player) {
        if (player == null) {
            LOGGER.warn("Attempted to request mod data from null player");
            return false;
        }
        UUID playerUUID = player.getUUID();
        long now = System.currentTimeMillis();
        Long lastRequest = lastRequestTime.get(playerUUID);
        if (lastRequest != null && now - lastRequest < REQUEST_COOLDOWN_MS) {
            LOGGER.debug("Rate limited mod data request for player {}", (Object)player.getName().getString());
            return false;
        }
        try {
            ModListRequestPacket packet = new ModListRequestPacket(ModListRequestPacket.RequestType.BOTH);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            lastRequestTime.put(playerUUID, now);
            LOGGER.debug("Requested mod data from player {}", (Object)player.getName().getString());
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to send mod data request to player {}", (Object)player.getName().getString(), (Object)e);
            return false;
        }
    }

    public static boolean requestResourcePackDataFromPlayer(ServerPlayer player) {
        if (player == null) {
            LOGGER.warn("Attempted to request resource pack data from null player");
            return false;
        }
        UUID playerUUID = player.getUUID();
        long now = System.currentTimeMillis();
        Long lastRequest = lastRequestTime.get(playerUUID);
        if (lastRequest != null && now - lastRequest < REQUEST_COOLDOWN_MS) {
            LOGGER.debug("Rate limited resource pack data request for player {}", (Object)player.getName().getString());
            return false;
        }
        try {
            ModListRequestPacket packet = new ModListRequestPacket(ModListRequestPacket.RequestType.RESOURCE_PACKS_ONLY);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            lastRequestTime.put(playerUUID, now);
            LOGGER.debug("Requested resource pack data from player {}", (Object)player.getName().getString());
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to send resource pack data request to player {}", (Object)player.getName().getString(), (Object)e);
            return false;
        }
    }

    public static class PlayerModData {
        private final List<ModListPacket.ModInfo> mods;
        private final List<ModListPacket.ResourcePackInfo> resourcePacks;
        private final long timestamp;

        public PlayerModData(List<ModListPacket.ModInfo> mods, List<ModListPacket.ResourcePackInfo> resourcePacks, long timestamp) {
            this.mods = List.copyOf(mods);
            this.resourcePacks = List.copyOf(resourcePacks);
            this.timestamp = timestamp;
        }

        public List<ModListPacket.ModInfo> getMods() {
            return this.mods;
        }

        public List<ModListPacket.ResourcePackInfo> getResourcePacks() {
            return this.resourcePacks;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

