/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.moderation.approval;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class BanPattern {
    private final int id;
    private final String patternString;
    private final Pattern compiledPattern;
    private final String description;
    private final long created;

    public BanPattern(int id, String patternString, String description, long created) {
        this.id = id;
        this.patternString = patternString;
        this.description = description;
        this.created = created;
        this.compiledPattern = Pattern.compile(patternString, 2);
    }

    public int getId() {
        return this.id;
    }

    public String getPatternString() {
        return this.patternString;
    }

    public Pattern getCompiledPattern() {
        return this.compiledPattern;
    }

    public String getDescription() {
        return this.description;
    }

    public long getCreated() {
        return this.created;
    }

    public boolean matches(String text) {
        return this.compiledPattern.matcher(text).find();
    }

    public static boolean isValidPattern(String patternString) {
        try {
            Pattern.compile(patternString);
            return true;
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }
}

