/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.moderation.approval;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.neoforged.fml.ModList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.moderation.ModListPacket;
import world.landfall.landfallessentials.moderation.ModerationManager;
import world.landfall.landfallessentials.moderation.approval.BanPattern;
import world.landfall.landfallessentials.moderation.approval.ClientApprovalDAO;
import world.landfall.landfallessentials.moderation.approval.ModApprovalEntry;
import world.landfall.landfallessentials.moderation.approval.ModApprovalStatus;

public class ClientApprovalSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientApprovalSystem.class);
    private static final List<BanPattern> banPatterns = new ArrayList<BanPattern>();
    private static final Set<String> serverModIds = new HashSet<String>();
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            LOGGER.warn("ClientApprovalSystem already initialized");
            return;
        }
        try {
            LOGGER.info("Initializing client approval system...");
            List<BanPattern> loadedPatterns = ClientApprovalDAO.loadAllBanPatterns();
            banPatterns.addAll(loadedPatterns);
            LOGGER.info("Loaded {} ban patterns from database", (Object)loadedPatterns.size());
            ClientApprovalSystem.autoApproveServerMods();
            initialized = true;
            LOGGER.info("Client approval system initialized successfully");
        }
        catch (SQLException e) {
            LOGGER.error("Failed to initialize client approval system", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error during client approval system initialization", (Throwable)e);
        }
    }

    private static void autoApproveServerMods() {
        try {
            Map<String, ModApprovalEntry> existingApprovals = ClientApprovalDAO.loadAllModApprovals();
            ModList.get().forEachModContainer((modId, container) -> {
                serverModIds.add((String)modId);
                ModApprovalEntry existing = (ModApprovalEntry)existingApprovals.get(modId);
                if (existing == null) {
                    String displayName = container.getModInfo().getDisplayName();
                    long now = System.currentTimeMillis();
                    ModApprovalEntry entry = new ModApprovalEntry((String)modId, displayName, ModApprovalStatus.APPROVED, now, now, "Auto-approved (server-side mod)");
                    try {
                        ClientApprovalDAO.saveModApproval(entry);
                    }
                    catch (SQLException e) {
                        LOGGER.warn("Failed to save auto-approved mod {}", modId, (Object)e);
                    }
                } else if (existing.getStatus() == ModApprovalStatus.UNCLASSIFIED) {
                    existing.setStatus(ModApprovalStatus.APPROVED);
                    existing.setNotes("Auto-approved (server-side mod)");
                    existing.updateLastSeen();
                    try {
                        ClientApprovalDAO.saveModApproval(existing);
                    }
                    catch (SQLException e) {
                        LOGGER.warn("Failed to update auto-approved mod {}", modId, (Object)e);
                    }
                }
            });
            LOGGER.info("Auto-approved {} server-side mods", (Object)serverModIds.size());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to load existing approvals for auto-approval", (Throwable)e);
        }
    }

    public static ModApprovalStatus evaluateModStatus(String modId, String displayName) {
        try {
            for (BanPattern pattern : banPatterns) {
                if (!pattern.matches(modId) && !pattern.matches(displayName)) continue;
                ClientApprovalSystem.ensureModEntry(modId, displayName, ModApprovalStatus.BANNED);
                return ModApprovalStatus.BANNED;
            }
            Map<String, ModApprovalEntry> approvals = ClientApprovalDAO.loadAllModApprovals();
            ModApprovalEntry entry = approvals.get(modId);
            if (entry != null) {
                entry.updateLastSeen();
                ClientApprovalDAO.saveModApproval(entry);
                return entry.getStatus();
            }
            if (serverModIds.contains(modId)) {
                ClientApprovalSystem.ensureModEntry(modId, displayName, ModApprovalStatus.APPROVED);
                return ModApprovalStatus.APPROVED;
            }
            ClientApprovalSystem.ensureModEntry(modId, displayName, ModApprovalStatus.UNCLASSIFIED);
            return ModApprovalStatus.UNCLASSIFIED;
        }
        catch (SQLException e) {
            LOGGER.error("Failed to evaluate mod status for {}", (Object)modId, (Object)e);
            return ModApprovalStatus.UNCLASSIFIED;
        }
    }

    public static ModApprovalStatus evaluateResourcepackStatus(String packId, String displayName) {
        try {
            for (BanPattern pattern : banPatterns) {
                if (!pattern.matches(packId) && !pattern.matches(displayName)) continue;
                ClientApprovalSystem.ensureResourcepackEntry(packId, displayName, ModApprovalStatus.BANNED);
                return ModApprovalStatus.BANNED;
            }
            Map<String, ModApprovalEntry> approvals = ClientApprovalDAO.loadAllResourcepackApprovals();
            ModApprovalEntry entry = approvals.get(packId);
            if (entry != null) {
                entry.updateLastSeen();
                ClientApprovalDAO.saveResourcepackApproval(entry);
                return entry.getStatus();
            }
            ClientApprovalSystem.ensureResourcepackEntry(packId, displayName, ModApprovalStatus.UNCLASSIFIED);
            return ModApprovalStatus.UNCLASSIFIED;
        }
        catch (SQLException e) {
            LOGGER.error("Failed to evaluate resourcepack status for {}", (Object)packId, (Object)e);
            return ModApprovalStatus.UNCLASSIFIED;
        }
    }

    private static void ensureModEntry(String modId, String displayName, ModApprovalStatus status) {
        try {
            Map<String, ModApprovalEntry> existing = ClientApprovalDAO.loadAllModApprovals();
            if (!existing.containsKey(modId)) {
                long now = System.currentTimeMillis();
                ModApprovalEntry entry = new ModApprovalEntry(modId, displayName, status, now, now, null);
                ClientApprovalDAO.saveModApproval(entry);
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Failed to save mod entry {}", (Object)modId, (Object)e);
        }
    }

    private static void ensureResourcepackEntry(String packId, String displayName, ModApprovalStatus status) {
        try {
            Map<String, ModApprovalEntry> existing = ClientApprovalDAO.loadAllResourcepackApprovals();
            if (!existing.containsKey(packId)) {
                long now = System.currentTimeMillis();
                ModApprovalEntry entry = new ModApprovalEntry(packId, displayName, status, now, now, null);
                ClientApprovalDAO.saveResourcepackApproval(entry);
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Failed to save resourcepack entry {}", (Object)packId, (Object)e);
        }
    }

    public static PlayerApprovalStatus evaluatePlayerStatus(ModerationManager.PlayerModData playerData) {
        ModApprovalStatus status;
        if (playerData == null) {
            return new PlayerApprovalStatus(ModApprovalStatus.APPROVED, new ArrayList<FlaggedItem>(), new ArrayList<FlaggedItem>());
        }
        ModApprovalStatus worstStatus = ModApprovalStatus.APPROVED;
        ArrayList<FlaggedItem> flaggedMods = new ArrayList<FlaggedItem>();
        ArrayList<FlaggedItem> flaggedPacks = new ArrayList<FlaggedItem>();
        for (ModListPacket.ModInfo mod : playerData.getMods()) {
            status = ClientApprovalSystem.evaluateModStatus(mod.modId(), mod.displayName());
            if (status.getPriority() > worstStatus.getPriority()) {
                worstStatus = status;
            }
            if (status == ModApprovalStatus.APPROVED) continue;
            flaggedMods.add(new FlaggedItem(mod.modId(), mod.displayName(), status));
        }
        for (ModListPacket.ResourcePackInfo pack : playerData.getResourcePacks()) {
            status = ClientApprovalSystem.evaluateResourcepackStatus(pack.id(), pack.title());
            if (status.getPriority() > worstStatus.getPriority()) {
                worstStatus = status;
            }
            if (status == ModApprovalStatus.APPROVED) continue;
            flaggedPacks.add(new FlaggedItem(pack.id(), pack.title(), status));
        }
        return new PlayerApprovalStatus(worstStatus, flaggedMods, flaggedPacks);
    }

    public static void setModApprovalStatus(String modId, ModApprovalStatus status) throws SQLException {
        Map<String, ModApprovalEntry> approvals = ClientApprovalDAO.loadAllModApprovals();
        ModApprovalEntry entry = approvals.get(modId);
        if (entry == null) {
            LOGGER.info("Creating new mod entry '{}' with status {}", (Object)modId, (Object)status);
            long now = System.currentTimeMillis();
            entry = new ModApprovalEntry(modId, modId, status, now, now, null);
        } else {
            entry.setStatus(status);
            entry.updateLastSeen();
        }
        ClientApprovalDAO.saveModApproval(entry);
        LOGGER.info("Set mod '{}' status to {}", (Object)modId, (Object)status);
    }

    public static void setResourcepackApprovalStatus(String packId, ModApprovalStatus status) throws SQLException {
        Map<String, ModApprovalEntry> approvals = ClientApprovalDAO.loadAllResourcepackApprovals();
        ModApprovalEntry entry = approvals.get(packId);
        if (entry == null) {
            LOGGER.info("Creating new resourcepack entry '{}' with status {}", (Object)packId, (Object)status);
            long now = System.currentTimeMillis();
            entry = new ModApprovalEntry(packId, packId, status, now, now, null);
        } else {
            entry.setStatus(status);
            entry.updateLastSeen();
        }
        ClientApprovalDAO.saveResourcepackApproval(entry);
        LOGGER.info("Set resourcepack '{}' status to {}", (Object)packId, (Object)status);
    }

    public static int addBanPattern(String pattern, String description) throws SQLException {
        if (!BanPattern.isValidPattern(pattern)) {
            throw new IllegalArgumentException("Invalid regex pattern: " + pattern);
        }
        int id = ClientApprovalDAO.saveBanPattern(pattern, description);
        BanPattern banPattern = new BanPattern(id, pattern, description, System.currentTimeMillis());
        banPatterns.add(banPattern);
        LOGGER.info("Added ban pattern #{}: {}", (Object)id, (Object)description);
        return id;
    }

    public static void removeBanPattern(int patternId) throws SQLException {
        ClientApprovalDAO.deleteBanPattern(patternId);
        banPatterns.removeIf(p -> p.getId() == patternId);
        LOGGER.info("Removed ban pattern #{}", (Object)patternId);
    }

    public static Map<String, ModApprovalEntry> getModApprovals() {
        try {
            return ClientApprovalDAO.loadAllModApprovals();
        }
        catch (SQLException e) {
            LOGGER.error("Failed to load mod approvals", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static Map<String, ModApprovalEntry> getResourcepackApprovals() {
        try {
            return ClientApprovalDAO.loadAllResourcepackApprovals();
        }
        catch (SQLException e) {
            LOGGER.error("Failed to load resourcepack approvals", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static List<BanPattern> getBanPatterns() {
        return Collections.unmodifiableList(banPatterns);
    }

    public static class PlayerApprovalStatus {
        private final ModApprovalStatus overallStatus;
        private final List<FlaggedItem> flaggedMods;
        private final List<FlaggedItem> flaggedResourcepacks;

        public PlayerApprovalStatus(ModApprovalStatus overallStatus, List<FlaggedItem> flaggedMods, List<FlaggedItem> flaggedResourcepacks) {
            this.overallStatus = overallStatus;
            this.flaggedMods = List.copyOf(flaggedMods);
            this.flaggedResourcepacks = List.copyOf(flaggedResourcepacks);
        }

        public ModApprovalStatus getOverallStatus() {
            return this.overallStatus;
        }

        public List<FlaggedItem> getFlaggedMods() {
            return this.flaggedMods;
        }

        public List<FlaggedItem> getFlaggedResourcepacks() {
            return this.flaggedResourcepacks;
        }

        public boolean hasFlags() {
            return !this.flaggedMods.isEmpty() || !this.flaggedResourcepacks.isEmpty();
        }
    }

    public static class FlaggedItem {
        private final String id;
        private final String displayName;
        private final ModApprovalStatus status;

        public FlaggedItem(String id, String displayName, ModApprovalStatus status) {
            this.id = id;
            this.displayName = displayName;
            this.status = status;
        }

        public String getId() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public ModApprovalStatus getStatus() {
            return this.status;
        }
    }
}

