/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.RegionRental;
import world.landfall.landfallessentials.util.LuckPermsUtil;

@EventBusSubscriber(modid="landfallessentials")
public class RegionBlockManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionBlockManager.class);
    public static final String BUILD_TAG = "build";
    public static final String INTERACT_TAG = "interact";
    public static final String ADMIN_TAG = "admin";
    public static final String EXPLOSION_PROTECT_TAG = "explosion-protect";
    public static final String DELETE_LOCKED_TAG = "delete-locked";
    private static final Map<String, Long> permissionCache = new ConcurrentHashMap<String, Long>();
    private static final Map<String, Boolean> permissionResults = new ConcurrentHashMap<String, Boolean>();
    private static final long CACHE_DURATION = 5000L;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player;
        if (event.getLevel().isClientSide() || !((player = event.getPlayer()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        BlockPos pos = event.getPos();
        if (!RegionBlockManager.canModifyBlock(player2, pos, BUILD_TAG)) {
            event.setCanceled(true);
            RegionBlockManager.sendActionBarMessage(player2, "\u00a7cYou cannot break blocks in this region!");
            player2.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)event.getLevel(), pos));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity;
        if (event.getLevel().isClientSide() || !((entity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BlockPos pos = event.getPos();
        if (!RegionBlockManager.canModifyBlock(player, pos, BUILD_TAG)) {
            event.setCanceled(true);
            RegionBlockManager.sendActionBarMessage(player, "\u00a7cYou cannot place blocks in this region!");
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                player.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)serverLevel, pos));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player;
        if (event.getLevel().isClientSide() || !((player = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack heldItem = event.getItemStack();
        BlockPos clickedPos = event.getPos();
        if (!heldItem.isEmpty() && (heldItem.getItem() instanceof BlockItem || RegionBlockManager.isBlockModifyingItem(heldItem))) {
            boolean isBucket;
            boolean bl = isBucket = RegionBlockManager.isBlockModifyingItem(heldItem) && heldItem.getItem().toString().toLowerCase().contains("bucket");
            if (isBucket && !RegionBlockManager.canModifyBlock(player2, clickedPos, BUILD_TAG)) {
                event.setUseItem(TriState.FALSE);
                event.setUseBlock(TriState.FALSE);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.FAIL);
                RegionBlockManager.sendActionBarMessage(player2, "\u00a7cYou cannot use buckets in this region!");
                Level level = event.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    player2.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)serverLevel, clickedPos));
                    player2.inventoryMenu.sendAllDataToRemote();
                }
                return;
            }
            Direction face = event.getFace();
            BlockPos placePos = clickedPos.relative(face);
            BlockState clickedState = event.getLevel().getBlockState(clickedPos);
            if (clickedState.canBeReplaced()) {
                placePos = clickedPos;
            }
            if (!RegionBlockManager.canModifyBlock(player2, placePos, BUILD_TAG)) {
                event.setUseItem(TriState.FALSE);
                event.setUseBlock(TriState.FALSE);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.FAIL);
                RegionBlockManager.sendActionBarMessage(player2, "\u00a7cYou cannot place blocks in this region!");
                Level level = event.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    player2.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)serverLevel, clickedPos));
                    player2.connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)serverLevel, placePos));
                    player2.inventoryMenu.sendAllDataToRemote();
                }
                return;
            }
        } else if (!RegionBlockManager.canInteractWithBlock(player2, clickedPos)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
            RegionBlockManager.sendActionBarMessage(player2, "\u00a7cYou cannot interact with blocks in this region!");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        BlockPos playerPos;
        Player player;
        if (event.getLevel().isClientSide() || !((player = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack heldItem = event.getItemStack();
        if (!heldItem.isEmpty() && heldItem.getItem().toString().toLowerCase().contains("bucket") && !RegionBlockManager.canModifyBlock(player2, playerPos = player2.blockPosition(), BUILD_TAG)) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
            RegionBlockManager.sendActionBarMessage(player2, "\u00a7cYou cannot use buckets in this region!");
        }
    }

    public static boolean canModifyBlock(ServerPlayer player, BlockPos pos, String requiredTag) {
        return RegionBlockManager.hasRegionPermission(player, pos, requiredTag);
    }

    public static boolean canInteractWithBlock(ServerPlayer player, BlockPos pos) {
        if (RegionBlockManager.isBlockWhitelisted(player.serverLevel(), pos)) {
            return true;
        }
        return RegionBlockManager.hasRegionPermission(player, pos, INTERACT_TAG);
    }

    private static boolean isBlockWhitelisted(ServerLevel level, BlockPos pos) {
        if (Config.whitelistedInteractBlocks.isEmpty()) {
            return false;
        }
        BlockState blockState = level.getBlockState(pos);
        String blockId = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString();
        return Config.whitelistedInteractBlocks.contains(blockId);
    }

    private static boolean hasRegionPermission(ServerPlayer player, BlockPos pos, String requiredTag) {
        boolean hasEditPermission;
        Boolean cachedResult;
        if (RegionManager.hasAdminBypass(player.getUUID().toString())) {
            return true;
        }
        String cacheKey = String.valueOf(player.getUUID()) + ":" + pos.toShortString() + ":" + requiredTag;
        long currentTime = System.currentTimeMillis();
        Long cacheTime = permissionCache.get(cacheKey);
        if (cacheTime != null && currentTime - cacheTime < 5000L && (cachedResult = permissionResults.get(cacheKey)) != null) {
            return cachedResult;
        }
        Set<String> blockRegions = RegionBlockManager.getRegionsAtPosition(pos, player.serverLevel());
        if (blockRegions.isEmpty()) {
            RegionBlockManager.cacheResult(cacheKey, true, currentTime);
            return true;
        }
        if (RegionBlockManager.hasTagInAnyRegion(player, blockRegions, ADMIN_TAG)) {
            RegionBlockManager.cacheResult(cacheKey, true, currentTime);
            return true;
        }
        boolean hasTagPermission = RegionBlockManager.hasTagInAnyRegion(player, blockRegions, requiredTag);
        if (!hasTagPermission && (requiredTag.equals(BUILD_TAG) || requiredTag.equals(INTERACT_TAG)) && (hasEditPermission = RegionBlockManager.hasEditPermissionInAnyRegion(player, blockRegions))) {
            RegionBlockManager.cacheResult(cacheKey, true, currentTime);
            return true;
        }
        RegionBlockManager.cacheResult(cacheKey, hasTagPermission, currentTime);
        return hasTagPermission;
    }

    private static Set<String> getRegionsAtPosition(BlockPos pos, ServerLevel level) {
        HashSet<String> regionsAtPosition = new HashSet<String>();
        String dimension = level.dimension().location().toString();
        for (Map.Entry<String, Region> entry : RegionManager.getAllRegions().entrySet()) {
            Region region = entry.getValue();
            if (!region.getDimension().equals(dimension) || !region.contains(pos)) continue;
            regionsAtPosition.add(entry.getKey());
        }
        return regionsAtPosition;
    }

    private static boolean hasTagInAnyRegion(ServerPlayer player, Set<String> regions, String tag) {
        String playerName = player.getName().getString();
        for (String regionName : regions) {
            if (!RegionManager.regionHasTag(regionName, tag) && !RegionRental.isOwner(regionName, player.getUUID()) && !RegionRental.isTrustedInRegion(regionName, playerName)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasEditPermissionInAnyRegion(ServerPlayer player, Set<String> regions) {
        for (String regionName : regions) {
            Region region = RegionManager.getRegion(regionName);
            if (region == null) continue;
            for (String tag : region.getTags()) {
                if (!tag.startsWith("override:")) continue;
                String permissionNode = tag.substring(9);
                if (!LuckPermsUtil.hasPermission(player.getUUID(), permissionNode)) continue;
                return true;
            }
        }
        return false;
    }

    private static void cacheResult(String cacheKey, boolean result, long currentTime) {
        permissionCache.put(cacheKey, currentTime);
        permissionResults.put(cacheKey, result);
        if (permissionCache.size() > 1000) {
            RegionBlockManager.cleanCache(currentTime);
        }
    }

    private static void cleanCache(long currentTime) {
        permissionCache.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 10000L);
        permissionResults.entrySet().removeIf(entry -> !permissionCache.containsKey(entry.getKey()));
    }

    private static boolean isBlockModifyingItem(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        String itemName = itemStack.getItem().toString().toLowerCase();
        return itemName.contains("bone_meal") || itemName.contains("flint_and_steel") || itemName.contains("fire_charge") || itemName.contains("hoe") || itemName.contains("shovel") || itemName.contains("bucket") || itemName.contains("shears") || itemName.contains("spawn_egg");
    }

    private static void sendActionBarMessage(ServerPlayer player, String message) {
        player.displayClientMessage((Component)Component.literal((String)message), true);
    }

    public static void clearPermissionCache() {
        permissionCache.clear();
        permissionResults.clear();
        LOGGER.debug("Cleared region permission cache");
    }

    public static boolean canPlayerActInRegion(ServerPlayer player, BlockPos pos) {
        return RegionBlockManager.canModifyBlock(player, pos, BUILD_TAG) || RegionBlockManager.canInteractWithBlock(player, pos);
    }

    public static String[] getRequiredTags() {
        return new String[]{BUILD_TAG, INTERACT_TAG, ADMIN_TAG, EXPLOSION_PROTECT_TAG};
    }

    public static String getTagDescription(String tag) {
        return switch (tag) {
            case BUILD_TAG -> "Allows placing and breaking blocks";
            case INTERACT_TAG -> "Allows interacting with blocks (chests, buttons, etc.)";
            case ADMIN_TAG -> "Bypasses all region restrictions";
            case EXPLOSION_PROTECT_TAG -> "Protects region and subregions from explosion damage";
            default -> "Unknown tag";
        };
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Vec3 explosionPos = event.getExplosion().center();
        BlockPos explosionBlockPos = BlockPos.containing((double)explosionPos.x, (double)explosionPos.y, (double)explosionPos.z);
        String dimension = event.getLevel().dimension().location().toString();
        boolean explosionProtected = false;
        for (Map.Entry<String, Region> entry : RegionManager.getAllRegions().entrySet()) {
            Region region = entry.getValue();
            if (!region.getDimension().equals(dimension) || !region.contains(explosionBlockPos) || !RegionBlockManager.shouldProtectFromExplosions(entry.getKey(), region)) continue;
            explosionProtected = true;
            break;
        }
        if (explosionProtected) {
            event.getAffectedBlocks().clear();
            event.getAffectedEntities().clear();
            LOGGER.debug("Explosion at {} was prevented due to region protection", (Object)explosionBlockPos);
            return;
        }
        ArrayList<BlockPos> blocksToProtect = new ArrayList<BlockPos>();
        block1: for (BlockPos pos : event.getAffectedBlocks()) {
            for (Map.Entry<String, Region> entry : RegionManager.getAllRegions().entrySet()) {
                Region region = entry.getValue();
                if (!region.getDimension().equals(dimension) || !region.contains(pos) || !RegionBlockManager.shouldProtectFromExplosions(entry.getKey(), region)) continue;
                blocksToProtect.add(pos);
                continue block1;
            }
        }
        if (!blocksToProtect.isEmpty()) {
            event.getAffectedBlocks().removeAll(blocksToProtect);
            LOGGER.debug("Protected {} blocks from explosion", (Object)blocksToProtect.size());
        }
    }

    private static boolean shouldProtectFromExplosions(String regionName, Region region) {
        if (region.hasTag(EXPLOSION_PROTECT_TAG)) {
            return true;
        }
        String parentName = RegionManager.getParentRegion(regionName);
        while (parentName != null) {
            Region parentRegion = RegionManager.getRegion(parentName);
            if (parentRegion != null && parentRegion.hasTag(EXPLOSION_PROTECT_TAG)) {
                return true;
            }
            parentName = RegionManager.getParentRegion(parentName);
        }
        return false;
    }
}

