/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.regions.Cuboid;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.packets.RegionVisualizationPacket;

@EventBusSubscriber(modid="landfallessentials")
public class RegionVisualizerNew {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionVisualizerNew.class);
    private static final Set<UUID> playersWithVisualization = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, Integer> lastSentDataHash = new ConcurrentHashMap<UUID, Integer>();
    private static final int MAX_VISUALIZATION_DISTANCE = 128;
    private static final int UPDATE_INTERVAL_TICKS = 20;
    private static final int[] CUBOID_COLORS = new int[]{1073774847, 0x4000FF00, 0x40FFFF00, 1090486272, 0x40FF00FF, 1090486527, 0x4000FFFF, 1082130687, 0x40FF0000, 0x4000FF00, 0x400000FF, 0x40FFFFFF};

    public static boolean toggleVisualization(ServerPlayer player) {
        UUID playerUUID = player.getUUID();
        if (playersWithVisualization.contains(playerUUID)) {
            playersWithVisualization.remove(playerUUID);
            lastSentDataHash.remove(playerUUID);
            RegionVisualizerNew.sendVisualizationPacket(player, false, Collections.emptyList());
            player.sendSystemMessage((Component)Component.literal((String)"\u00a7cRegion visualization disabled."));
            return false;
        }
        playersWithVisualization.add(playerUUID);
        RegionVisualizerNew.updatePlayerVisualization(player);
        player.sendSystemMessage((Component)Component.literal((String)"\u00a7aRegion visualization enabled."));
        player.sendSystemMessage((Component)Component.literal((String)"\u00a77Showing regions within 128 blocks."));
        return true;
    }

    public static boolean hasVisualizationEnabled(ServerPlayer player) {
        return playersWithVisualization.contains(player.getUUID());
    }

    public static void updatePlayerVisualization(ServerPlayer player) {
        if (!playersWithVisualization.contains(player.getUUID())) {
            return;
        }
        List<RegionVisualizationPacket.RegionData> regionData = RegionVisualizerNew.getNearbyRegionData(player);
        int currentHash = regionData.hashCode();
        Integer lastHash = lastSentDataHash.get(player.getUUID());
        if (lastHash == null || !lastHash.equals(currentHash)) {
            RegionVisualizerNew.sendVisualizationPacket(player, true, regionData);
            lastSentDataHash.put(player.getUUID(), currentHash);
        }
    }

    private static void sendVisualizationPacket(ServerPlayer player, boolean enabled, List<RegionVisualizationPacket.RegionData> regions) {
        RegionVisualizationPacket packet = new RegionVisualizationPacket(enabled, regions);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static List<RegionVisualizationPacket.RegionData> getNearbyRegionData(ServerPlayer player) {
        ArrayList<RegionVisualizationPacket.RegionData> regionDataList = new ArrayList<RegionVisualizationPacket.RegionData>();
        BlockPos playerPos = player.blockPosition();
        String playerDimension = player.level().dimension().location().toString();
        for (Map.Entry<String, Region> entry : RegionManager.getAllRegions().entrySet()) {
            Region region = entry.getValue();
            if (!region.getDimension().equals(playerDimension)) continue;
            ArrayList<RegionVisualizationPacket.CuboidData> visibleCuboids = new ArrayList<RegionVisualizationPacket.CuboidData>();
            int cuboidIndex = 0;
            for (Cuboid cuboid : region.getCuboids()) {
                if (RegionVisualizerNew.isWithinVisualizationDistance(playerPos, cuboid)) {
                    BlockPos min = new BlockPos(cuboid.getMinX(), cuboid.getMinY(), cuboid.getMinZ());
                    BlockPos max = new BlockPos(cuboid.getMaxX(), cuboid.getMaxY(), cuboid.getMaxZ());
                    int color = CUBOID_COLORS[cuboidIndex % CUBOID_COLORS.length];
                    visibleCuboids.add(new RegionVisualizationPacket.CuboidData(min, max, color));
                }
                ++cuboidIndex;
            }
            if (visibleCuboids.isEmpty()) continue;
            regionDataList.add(new RegionVisualizationPacket.RegionData(entry.getKey(), region.getDimension(), visibleCuboids));
        }
        return regionDataList;
    }

    private static boolean isWithinVisualizationDistance(BlockPos pos, Cuboid cuboid) {
        int closestZ;
        int closestY;
        int closestX = Math.max(cuboid.getMinX(), Math.min(pos.getX(), cuboid.getMaxX()));
        double distanceSquared = pos.distSqr((Vec3i)new BlockPos(closestX, closestY = Math.max(cuboid.getMinY(), Math.min(pos.getY(), cuboid.getMaxY())), closestZ = Math.max(cuboid.getMinZ(), Math.min(pos.getZ(), cuboid.getMaxZ()))));
        return distanceSquared <= 16384.0;
    }

    public static void onRegionsChanged() {
        lastSentDataHash.clear();
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.tickCount % 20 != 0) {
            return;
        }
        if (playersWithVisualization.contains(player2.getUUID())) {
            RegionVisualizerNew.updatePlayerVisualization(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            UUID playerUUID = player2.getUUID();
            playersWithVisualization.remove(playerUUID);
            lastSentDataHash.remove(playerUUID);
        }
    }
}

