/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.GameType;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionBlockManager;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.util.CommandMessageBuilder;
import world.landfall.landfallessentials.regions.util.RegionCommandHelper;

public class RegionEditCommands {
    private static final int ADMIN_PERMISSION = 2;

    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return (LiteralArgumentBuilder)Commands.literal((String)"edit").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionEditCommands::suggestRegionNames).then(((LiteralArgumentBuilder)Commands.literal((String)"messages").then(((LiteralArgumentBuilder)Commands.literal((String)"entry").then(((LiteralArgumentBuilder)Commands.literal((String)"chat").executes(ctx -> RegionEditCommands.executeClearMessage((CommandContext<CommandSourceStack>)ctx, MessageType.ENTRY, MessageSubType.CHAT))).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> RegionEditCommands.executeSetMessage((CommandContext<CommandSourceStack>)ctx, MessageType.ENTRY, MessageSubType.CHAT))))).then(((LiteralArgumentBuilder)Commands.literal((String)"actionbar").executes(ctx -> RegionEditCommands.executeClearMessage((CommandContext<CommandSourceStack>)ctx, MessageType.ENTRY, MessageSubType.ACTIONBAR))).then(Commands.argument((String)"actionbar_message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> RegionEditCommands.executeSetMessage((CommandContext<CommandSourceStack>)ctx, MessageType.ENTRY, MessageSubType.ACTIONBAR)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"exit").then(((LiteralArgumentBuilder)Commands.literal((String)"chat").executes(ctx -> RegionEditCommands.executeClearMessage((CommandContext<CommandSourceStack>)ctx, MessageType.EXIT, MessageSubType.CHAT))).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> RegionEditCommands.executeSetMessage((CommandContext<CommandSourceStack>)ctx, MessageType.EXIT, MessageSubType.CHAT))))).then(((LiteralArgumentBuilder)Commands.literal((String)"actionbar").executes(ctx -> RegionEditCommands.executeClearMessage((CommandContext<CommandSourceStack>)ctx, MessageType.EXIT, MessageSubType.ACTIONBAR))).then(Commands.argument((String)"actionbar_message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> RegionEditCommands.executeSetMessage((CommandContext<CommandSourceStack>)ctx, MessageType.EXIT, MessageSubType.ACTIONBAR))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"sound").executes(RegionEditCommands::executeClearSound)).then(Commands.argument((String)"sound_id", (ArgumentType)ResourceLocationArgument.id()).then(((RequiredArgumentBuilder)Commands.argument((String)"loop_delay_ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> RegionEditCommands.executeSetSound((CommandContext<CommandSourceStack>)ctx, "ambient", 1.0f, 1.0f))).then(((RequiredArgumentBuilder)Commands.argument((String)"category", (ArgumentType)StringArgumentType.string()).suggests(RegionEditCommands::suggestSoundCategories).executes(ctx -> RegionEditCommands.executeSetSound((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"category"), 1.0f, 1.0f))).then(((RequiredArgumentBuilder)Commands.argument((String)"volume", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(ctx -> RegionEditCommands.executeSetSound((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"category"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"volume"), 1.0f))).then(Commands.argument((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(ctx -> RegionEditCommands.executeSetSound((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"category"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"volume"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"pitch")))))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"gamemode").then(((LiteralArgumentBuilder)Commands.literal((String)"entry").executes(ctx -> RegionEditCommands.executeClearGamemode((CommandContext<CommandSourceStack>)ctx, GamemodeType.ENTRY))).then(Commands.argument((String)"gamemode", (ArgumentType)StringArgumentType.string()).suggests(RegionEditCommands::suggestGamemodes).executes(ctx -> RegionEditCommands.executeSetGamemode((CommandContext<CommandSourceStack>)ctx, GamemodeType.ENTRY))))).then(((LiteralArgumentBuilder)Commands.literal((String)"exit").executes(ctx -> RegionEditCommands.executeClearGamemode((CommandContext<CommandSourceStack>)ctx, GamemodeType.EXIT))).then(Commands.argument((String)"gamemode", (ArgumentType)StringArgumentType.string()).suggests(RegionEditCommands::suggestGamemodes).executes(ctx -> RegionEditCommands.executeSetGamemode((CommandContext<CommandSourceStack>)ctx, GamemodeType.EXIT)))))).then(Commands.literal((String)"permission").then(Commands.literal((String)"info").executes(RegionEditCommands::executePermissionInfo))));
    }

    private static CompletableFuture<Suggestions> suggestRegionNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(RegionManager.getRegionNames(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestSoundCategories(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(Arrays.stream(SoundSource.values()).map(s -> s.name().toLowerCase()), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestGamemodes(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(Arrays.stream(GameType.values()).map(GameType::getName), (SuggestionsBuilder)builder);
    }

    private static int executeSetMessage(CommandContext<CommandSourceStack> ctx, MessageType type, MessageSubType subType) throws CommandSyntaxException {
        String successMessage;
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        block0 : switch (type.ordinal()) {
            case 0: {
                switch (subType.ordinal()) {
                    case 0: {
                        String content = StringArgumentType.getString(ctx, (String)"message");
                        region.setEntryMessage(content);
                        successMessage = "Set entry chat message for region '" + name + "'.";
                        break block0;
                    }
                    case 1: {
                        String content = StringArgumentType.getString(ctx, (String)"actionbar_message");
                        region.setEntryActionbarMessage(content);
                        successMessage = "Set entry actionbar message for region '" + name + "'.";
                        break block0;
                    }
                }
                RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 Unknown entry message subtype."));
                return 0;
            }
            case 1: {
                switch (subType.ordinal()) {
                    case 0: {
                        String content = StringArgumentType.getString(ctx, (String)"message");
                        region.setExitMessage(content);
                        successMessage = "Set exit chat message for region '" + name + "'.";
                        break block0;
                    }
                    case 1: {
                        String content = StringArgumentType.getString(ctx, (String)"actionbar_message");
                        region.setExitActionbarMessage(content);
                        successMessage = "Set exit actionbar message for region '" + name + "'.";
                        break block0;
                    }
                }
                RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 Unknown exit message subtype."));
                return 0;
            }
            default: {
                RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 Unknown message type."));
                return 0;
            }
        }
        RegionManager.saveRegions();
        RegionCommandHelper.sendSuccess(ctx, CommandMessageBuilder.successMsg("\u2713 " + successMessage), true);
        return 1;
    }

    private static int executeClearMessage(CommandContext<CommandSourceStack> ctx, MessageType type, MessageSubType subType) throws CommandSyntaxException {
        String successMessage;
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        block0 : switch (type.ordinal()) {
            case 0: {
                switch (subType.ordinal()) {
                    case 0: {
                        region.clearEntryMessage();
                        successMessage = "Cleared entry chat message for region '" + name + "'.";
                        break block0;
                    }
                    case 1: {
                        region.clearEntryActionbarMessage();
                        successMessage = "Cleared entry actionbar message for region '" + name + "'.";
                        break block0;
                    }
                }
                RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 Unknown entry message subtype."));
                return 0;
            }
            case 1: {
                switch (subType.ordinal()) {
                    case 0: {
                        region.clearExitMessage();
                        successMessage = "Cleared exit chat message for region '" + name + "'.";
                        break block0;
                    }
                    case 1: {
                        region.clearExitActionbarMessage();
                        successMessage = "Cleared exit actionbar message for region '" + name + "'.";
                        break block0;
                    }
                }
                RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 Unknown exit message subtype."));
                return 0;
            }
            default: {
                RegionCommandHelper.sendFailure(ctx, CommandMessageBuilder.errorMsg("\u2717 Unknown message type."));
                return 0;
            }
        }
        RegionManager.saveRegions();
        RegionCommandHelper.sendSuccess(ctx, CommandMessageBuilder.successMsg("\u2713 " + successMessage), true);
        return 1;
    }

    private static int executeSetSound(CommandContext<CommandSourceStack> ctx, String category, float volume, float pitch) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        ResourceLocation soundId = ResourceLocationArgument.getId(ctx, (String)"sound_id");
        int loopDelay = IntegerArgumentType.getInteger(ctx, (String)"loop_delay_ticks");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        region.setSound(soundId.toString(), category, volume, pitch, loopDelay);
        RegionManager.saveRegions();
        RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Set sound for region '").highlight(name).success("': ").info(soundId.toString()).success(" (loop: ").highlight(String.valueOf(loopDelay)).success(" ticks, category: ").highlight(category).success(", volume: ").highlight(String.valueOf(volume)).success(", pitch: ").highlight(String.valueOf(pitch)).success(")").build(), true);
        return 1;
    }

    private static int executeClearSound(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        region.clearSound();
        RegionManager.saveRegions();
        RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Cleared sound for region '").highlight(name).success("'.").build(), true);
        return 1;
    }

    private static int executeSetGamemode(CommandContext<CommandSourceStack> ctx, GamemodeType type) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        String gamemode = StringArgumentType.getString(ctx, (String)"gamemode");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        try {
            GameType.byName((String)gamemode.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Invalid gamemode: ").highlight(gamemode).error(". Valid options: ").value("survival, creative, adventure, spectator").build());
            return 0;
        }
        switch (type.ordinal()) {
            case 0: {
                region.setGamemodeOnEntry(gamemode.toLowerCase());
                break;
            }
            case 1: {
                region.setGamemodeOnExit(gamemode.toLowerCase());
            }
        }
        RegionManager.saveRegions();
        String typeStr = type.name().toLowerCase();
        RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Set " + typeStr + " gamemode for region '").highlight(name).success("' to ").highlight(gamemode.toLowerCase()).success(".").build(), true);
        return 1;
    }

    private static int executeClearGamemode(CommandContext<CommandSourceStack> ctx, GamemodeType type) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        switch (type.ordinal()) {
            case 0: {
                region.setGamemodeOnEntry(null);
                break;
            }
            case 1: {
                region.setGamemodeOnExit(null);
            }
        }
        RegionManager.saveRegions();
        String typeStr = type.name().toLowerCase();
        RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Cleared " + typeStr + " gamemode for region '").highlight(name).success("'.").build(), true);
        return 1;
    }

    private static int executePermissionInfo(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String[] tags;
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        StringBuilder info = new StringBuilder();
        info.append("\u00a7b=== Block Permissions for Region: \u00a7e").append(name).append("\u00a7b ===\n");
        info.append("\u00a7bAvailable permission tags:\n");
        for (String tag : tags = RegionBlockManager.getRequiredTags()) {
            boolean hasTag = RegionManager.regionHasTag(name, tag);
            String status = hasTag ? "\u00a7a\u2713 ENABLED" : "\u00a7c\u2717 DISABLED";
            info.append("  \u00a7e").append(tag).append("\u00a7b: ").append(status).append("\u00a7b - \u00a77").append(RegionBlockManager.getTagDescription(tag)).append("\n");
        }
        info.append("\n\u00a7bTo enable: \u00a77/region edit ").append(name).append(" tag add <tag>");
        info.append("\n\u00a7bTo disable: \u00a77/region edit ").append(name).append(" tag remove <tag>");
        RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)info.toString()));
        return 1;
    }

    private static enum MessageType {
        ENTRY,
        EXIT;

    }

    private static enum MessageSubType {
        CHAT("chat"),
        ACTIONBAR("actionbar");

        private final String name;

        private MessageSubType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum GamemodeType {
        ENTRY,
        EXIT;

    }
}

