/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionBlockManager;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.market.MarketManager;
import world.landfall.landfallessentials.regions.util.CommandMessageBuilder;
import world.landfall.landfallessentials.regions.util.RegionCommandHelper;

public class RegionManagementCommands {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionManagementCommands.class);
    private static final int ADMIN_PERMISSION = 2;

    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"region").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"new").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"corner1", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"corner2", (ArgumentType)BlockPosArgument.blockPos()).executes(RegionManagementCommands::executeAddRegionCurrentDim)).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(RegionManagementCommands::executeAddRegionSpecificDim))))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionManagementCommands::suggestRegionNames).executes(RegionManagementCommands::executeRemoveRegion)))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(RegionManagementCommands::executeListRegions)).then(Commands.literal((String)"all").executes(RegionManagementCommands::executeListAllRegions)))).then(((LiteralArgumentBuilder)Commands.literal((String)"info").executes(RegionManagementCommands::executeInfoTopLevel)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(RegionManagementCommands::suggestRegionNames).executes(RegionManagementCommands::executeInfoRegion)))).then(((LiteralArgumentBuilder)Commands.literal((String)"debug").executes(RegionManagementCommands::executeDebugSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionManagementCommands::executeDebugPlayer)));
    }

    private static CompletableFuture<Suggestions> suggestRegionNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(RegionManager.getRegionNames(), (SuggestionsBuilder)builder);
    }

    private static int executeAddRegionCurrentDim(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionManagementCommands.executeAddRegion(ctx, StringArgumentType.getString(ctx, (String)"name"), ((CommandSourceStack)ctx.getSource()).getLevel().dimension().location().toString(), BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner1"), BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner2"));
    }

    private static int executeAddRegionSpecificDim(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionManagementCommands.executeAddRegion(ctx, StringArgumentType.getString(ctx, (String)"name"), DimensionArgument.getDimension(ctx, (String)"dimension").dimension().location().toString(), BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner1"), BlockPosArgument.getLoadedBlockPos(ctx, (String)"corner2"));
    }

    private static int executeAddRegion(CommandContext<CommandSourceStack> ctx, String name, String dimension, BlockPos c1, BlockPos c2) {
        String originalName = name;
        String marketName = null;
        if (MarketManager.isMarketName(name)) {
            marketName = name;
            if ((name = MarketManager.getNextRegionName(marketName)) == null) {
                RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Failed to generate auto-incremented name for market '").highlight(originalName).error("'.").build());
                return 0;
            }
            LOGGER.info("Auto-incremented region name from '{}' to '{}'", (Object)originalName, (Object)name);
        } else if (!RegionCommandHelper.validateRegionName(ctx, name)) {
            return 0;
        }
        if (!RegionCommandHelper.ensureRegionDoesNotExist(ctx, name)) {
            return 0;
        }
        Region region = new Region(name, dimension, c1, c2);
        if (marketName != null) {
            region.addTag("rentable:" + marketName);
            LOGGER.info("Auto-added rentable tag for region '{}'", (Object)name);
        }
        if (RegionManager.addRegion(region)) {
            if (marketName != null) {
                MarketManager.addRegionToMarket(marketName, name);
                LOGGER.info("Added region '{}' to market '{}'", (Object)name, (Object)marketName);
            }
            CommandMessageBuilder msg = new CommandMessageBuilder().success("\u2713 Added region '").highlight(name).success("'");
            if (marketName != null) {
                msg.success(" (market: ").highlight(marketName).success(")");
            }
            msg.success(" in ").info(RegionCommandHelper.formatDimension(ResourceLocation.parse((String)dimension))).success(" from ").value(RegionCommandHelper.formatPos(c1)).success(" to ").value(RegionCommandHelper.formatPos(c2));
            RegionCommandHelper.sendSuccess(ctx, msg.build(), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Failed to add region '").highlight(name).error("'.").build());
        return 0;
    }

    private static int executeRemoveRegion(CommandContext<CommandSourceStack> ctx) {
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionManager.getRegion(name);
        if (region != null && region.hasTag("delete-locked")) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Region '").highlight(name).error("' is delete-locked!\n").info("Remove the '").highlight("delete-locked").info("' tag first.").build());
            return 0;
        }
        if (RegionManager.removeRegion(name)) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Removed region '").highlight(name).success("'.").build(), true);
            return 1;
        }
        RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Region '").highlight(name).error("' not found.").build());
        return 0;
    }

    private static int executeListRegions(CommandContext<CommandSourceStack> ctx) {
        List<String> topLevelRegions = RegionManager.getTopLevelRegions();
        Set<String> allRegions = RegionManager.getRegionNames();
        if (allRegions.isEmpty()) {
            RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)"\u00a77No regions defined."));
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a7b=== Region Hierarchy ===\n");
        sb.append("\u00a77Total regions: \u00a7e").append(allRegions.size());
        sb.append("\u00a77 (Top-level: \u00a7e").append(topLevelRegions.size()).append("\u00a77)\n\n");
        String tree = RegionManager.buildRegionTree(null, "", "", false);
        sb.append(tree);
        if (allRegions.size() > topLevelRegions.size()) {
            sb.append("\n\u00a77Use \u00a7b/region list all\u00a77 to see all regions in a flat list");
        }
        RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)sb.toString()));
        return topLevelRegions.size();
    }

    private static int executeListAllRegions(CommandContext<CommandSourceStack> ctx) {
        Set<String> regionNames = RegionManager.getRegionNames();
        if (regionNames.isEmpty()) {
            RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)"\u00a77No regions defined."));
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a7bAll regions (\u00a7e").append(regionNames.size()).append("\u00a7b): ");
        boolean first = true;
        for (String name : regionNames) {
            if (!first) {
                sb.append("\u00a77, ");
            }
            sb.append("\u00a7e").append(name);
            first = false;
        }
        RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)sb.toString()));
        return regionNames.size();
    }

    private static int executeInfoTopLevel(CommandContext<CommandSourceStack> ctx) {
        String[] lines;
        List<String> topLevelRegions = RegionManager.getTopLevelRegions();
        if (topLevelRegions.isEmpty()) {
            RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)"\u00a77No regions defined."));
            return 0;
        }
        StringBuilder info = new StringBuilder();
        info.append("\u00a7b=== Top-Level Regions ===\n\n");
        for (String regionName : topLevelRegions) {
            String[] region = RegionManager.getRegion(regionName);
            if (region == null) continue;
            List<String> children = RegionManager.getChildRegions(regionName);
            info.append("\u00a7e[").append(regionName).append("]");
            info.append(" \u00a77(").append(region.getVolume()).append(" blocks");
            if (!children.isEmpty()) {
                info.append(", ").append(children.size()).append(" subregions");
            }
            info.append(")\n");
            if (region.hasTags()) {
                info.append("  \u00a77Tags: ").append(String.join((CharSequence)", ", region.getTags())).append("\n");
            }
            info.append("\n");
        }
        info.append("\u00a77Click a region name or use \u00a7b/region info <name>\u00a77 for details and subregions");
        MutableComponent message = Component.empty();
        for (String line : lines = info.toString().split("\n")) {
            if (line.contains("[") && line.contains("]")) {
                int start = line.indexOf("[");
                int end = line.indexOf("]");
                if (start >= 0 && end > start) {
                    String regionName = line.substring(start + 1, end);
                    String beforeBracket = line.substring(0, start);
                    String afterBracket = line.substring(end + 1);
                    message = message.append((Component)Component.literal((String)beforeBracket)).append(RegionCommandHelper.createClickableRegionName(regionName, "/region info " + regionName)).append((Component)Component.literal((String)(afterBracket + "\n")));
                    continue;
                }
                message = message.append((Component)Component.literal((String)(line + "\n")));
                continue;
            }
            message = message.append((Component)Component.literal((String)(line + "\n")));
        }
        MutableComponent finalMessage = message;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> RegionManagementCommands.lambda$executeInfoTopLevel$1((Component)finalMessage), false);
        return topLevelRegions.size();
    }

    private static int executeInfoRegion(CommandContext<CommandSourceStack> ctx) {
        String[] lines;
        List<String> children;
        String name = StringArgumentType.getString(ctx, (String)"name");
        Region region = RegionCommandHelper.getRegionOrFail(ctx, "name");
        if (region == null) {
            return 0;
        }
        StringBuilder info = new StringBuilder();
        info.append("\u00a7b=== Region Info: \u00a7e").append(name).append("\u00a7b ===\n");
        String parent = RegionManager.getParentRegion(name);
        if (parent != null) {
            info.append("\u00a7bParent Region: \u00a7e").append(parent).append("\n");
        }
        info.append("\u00a7bDimension: \u00a77").append(RegionCommandHelper.formatDimension(ResourceLocation.parse((String)region.getDimension()))).append("\n");
        info.append("\u00a7bCuboids: \u00a7e").append(region.getCuboidCount()).append("\n");
        info.append("\u00a7bOverall bounds: \u00a77").append(RegionCommandHelper.formatPos(new BlockPos(region.getMinX(), region.getMinY(), region.getMinZ()))).append(" to ").append(RegionCommandHelper.formatPos(new BlockPos(region.getMaxX(), region.getMaxY(), region.getMaxZ()))).append("\n");
        info.append("\u00a7bVolume: \u00a7e").append(region.getVolume()).append("\u00a7b blocks\n");
        Set<String> tags = region.getTags();
        if (!tags.isEmpty()) {
            info.append("\u00a7bTags: ");
            boolean first = true;
            for (String tag : tags) {
                if (!first) {
                    info.append(", ");
                }
                if (tag.equals("explosion-protect")) {
                    info.append("\u00a7c").append(tag).append("\u00a7b (inherited by subregions)");
                } else {
                    info.append("\u00a7e").append(tag);
                }
                first = false;
            }
            info.append("\n");
        } else {
            info.append("\u00a77No tags\n");
        }
        if (region.hasAccessDeniedMessage()) {
            info.append("\u00a7bAccess Denied Message: \u00a77").append(region.getAccessDeniedMessage()).append("\n");
        }
        if (region.hasEntryMessage()) {
            info.append("\u00a7bEntry Message: \u00a77").append(region.getEntryMessage()).append("\n");
        }
        if (region.hasExitMessage()) {
            info.append("\u00a7bExit Message: \u00a77").append(region.getExitMessage()).append("\n");
        }
        if (region.hasSound()) {
            info.append("\u00a7bSound: \u00a77").append(region.getSoundEventId()).append(" (").append(region.getSoundLoopDelayTicks()).append(" tick loop)\n");
        }
        if (region.hasGamemodeOnEntry()) {
            info.append("\u00a7bEntry Gamemode: \u00a7e").append(region.getGamemodeOnEntry()).append("\n");
        }
        if (region.hasGamemodeOnExit()) {
            info.append("\u00a7bExit Gamemode: \u00a7e").append(region.getGamemodeOnExit()).append("\n");
        }
        if (!(children = RegionManager.getChildRegions(name)).isEmpty()) {
            info.append("\n\u00a7b=== Subregions ===\n");
            String tree = RegionManager.buildRegionTree(name, "", "", true);
            String[] treeLines = tree.split("\n");
            for (int i = 1; i < treeLines.length; ++i) {
                info.append(treeLines[i]).append("\n");
            }
        }
        MutableComponent message = Component.empty();
        for (String line : lines = info.toString().split("\n")) {
            if (line.contains("\u251c\u2500") || line.contains("\u2514\u2500") || line.contains("\u2502")) {
                int nameStart = line.indexOf("\u00a7e");
                if (nameStart >= 0) {
                    int nameEnd = line.indexOf(" ", nameStart += 2);
                    if (nameEnd > nameStart) {
                        String childName = line.substring(nameStart, nameEnd);
                        String beforeName = line.substring(0, nameStart - 2);
                        String afterName = line.substring(nameEnd);
                        message = message.append((Component)Component.literal((String)beforeName)).append(RegionCommandHelper.createClickableRegionName(childName, "/region info " + childName)).append((Component)Component.literal((String)(afterName + "\n")));
                        continue;
                    }
                    message = message.append((Component)Component.literal((String)(line + "\n")));
                    continue;
                }
                message = message.append((Component)Component.literal((String)(line + "\n")));
                continue;
            }
            message = message.append((Component)Component.literal((String)(line + "\n")));
        }
        MutableComponent finalMessage = message;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> RegionManagementCommands.lambda$executeInfoRegion$2((Component)finalMessage), false);
        return 1;
    }

    private static int executeDebugSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        return RegionManagementCommands.executeDebugForPlayer(ctx, player);
    }

    private static int executeDebugPlayer(CommandContext<CommandSourceStack> ctx) {
        String playerName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer player = server.getPlayerList().getPlayerByName(playerName);
        if (player == null) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Player '").highlight(playerName).error("' not found.").build());
            return 0;
        }
        return RegionManagementCommands.executeDebugForPlayer(ctx, player);
    }

    private static int executeDebugForPlayer(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        String playerUUID = player.getUUID().toString();
        String regionInfo = RegionManager.getPlayerRegionInfo(playerUUID);
        BlockPos pos = player.blockPosition();
        Set<String> regions = RegionManager.getPlayerRegions(playerUUID);
        StringBuilder debug = new StringBuilder();
        debug.append("\u00a7b=== Debug Info for \u00a7e").append(player.getName().getString()).append("\u00a7b ===\n");
        debug.append("\u00a7bPosition: \u00a77").append(RegionCommandHelper.formatPos(pos)).append("\n");
        debug.append("\u00a7bDimension: \u00a77").append(player.level().dimension().location()).append("\n");
        boolean hasAdminBypass = RegionManager.hasAdminBypass(playerUUID);
        if (hasAdminBypass) {
            debug.append("\u00a7bAdmin Bypass: \u00a7e").append("ENABLED").append("\n\n");
        } else {
            debug.append("\u00a7bAdmin Bypass: \u00a7c").append("DISABLED").append("\n\n");
        }
        debug.append("\u00a77").append(regionInfo);
        if (!regions.isEmpty()) {
            String[] permissionTags;
            debug.append("\n\n\u00a7bBlock Permissions at current position:\n");
            boolean canBuild = RegionBlockManager.canModifyBlock(player, pos, "build");
            boolean canInteract = RegionBlockManager.canInteractWithBlock(player, pos);
            debug.append("  \u00a7ebuild\u00a7b: ").append(canBuild ? "\u00a7a\u2713 ALLOWED" : "\u00a7c\u2717 DENIED").append("\n");
            debug.append("  \u00a7einteract\u00a7b: ").append(canInteract ? "\u00a7a\u2713 ALLOWED" : "\u00a7c\u2717 DENIED").append("\n");
            debug.append("\n\u00a7bActive permission tags:\n");
            for (String tag : permissionTags = RegionBlockManager.getRequiredTags()) {
                boolean hasTag = false;
                for (String regionName : regions) {
                    if (!RegionManager.regionHasTag(regionName, tag)) continue;
                    hasTag = true;
                    break;
                }
                debug.append("  \u00a7e").append(tag).append("\u00a7b: ").append(hasTag ? "\u00a7a\u2713 ACTIVE" : "\u00a77\u25cb INACTIVE").append("\n");
            }
        }
        RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)debug.toString()));
        return 1;
    }

    private static /* synthetic */ Component lambda$executeInfoRegion$2(Component finalMessage) {
        return finalMessage;
    }

    private static /* synthetic */ Component lambda$executeInfoTopLevel$1(Component finalMessage) {
        return finalMessage;
    }
}

