/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions.packets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import world.landfall.landfallessentials.regions.packets.RegionVisualizationPacket;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT}, modid="landfallessentials")
public class RegionVisualizationClientHandler {
    private static boolean visualizationEnabled = false;
    private static final List<RegionVisualizationPacket.RegionData> regions = new ArrayList<RegionVisualizationPacket.RegionData>();
    private static long lastUpdateTime = 0L;
    private static final int[] COLORS = new int[]{33023, 65280, 0xFFFF00, 0xFF8000, 0xFF00FF, 0xFF80FF, 65535, 0x8000FF, 0xFF0000, 65280, 255, 0xFFFFFF};

    public static void handleVisualizationPacket(RegionVisualizationPacket packet) {
        visualizationEnabled = packet.enabled();
        regions.clear();
        if (visualizationEnabled) {
            regions.addAll(packet.regions());
        }
        lastUpdateTime = System.currentTimeMillis();
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (!visualizationEnabled || regions.isEmpty()) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        String currentDimension = mc.level.dimension().location().toString();
        Vec3 cameraPos = event.getCamera().getPosition();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        for (RegionVisualizationPacket.RegionData region : regions) {
            if (!region.dimension().equals(currentDimension)) continue;
            int colorIndex = 0;
            for (RegionVisualizationPacket.CuboidData cuboid : region.cuboids()) {
                int baseColor = COLORS[colorIndex % COLORS.length];
                RegionVisualizationClientHandler.renderWireframeBox(poseStack, (MultiBufferSource)bufferSource, cuboid.min(), cuboid.max(), baseColor);
                ++colorIndex;
            }
        }
        poseStack.popPose();
        bufferSource.endBatch();
    }

    private static void renderWireframeBox(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos min, BlockPos max, int color) {
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = 1.0f;
        double x1 = min.getX();
        double y1 = min.getY();
        double z1 = min.getZ();
        double x2 = max.getX() + 1;
        double y2 = max.getY() + 1;
        double z2 = max.getZ() + 1;
        AABB box = new AABB(x1, y1, z1, x2, y2, z2);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)box, (float)red, (float)green, (float)blue, (float)alpha);
        if (max.getX() - min.getX() > 4 || max.getZ() - min.getZ() > 4) {
            float midX = (float)(x1 + x2) / 2.0f;
            float midZ = (float)(z1 + z2) / 2.0f;
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)new AABB(x1, y1, (double)midZ - 0.01, x2, y1 + 0.02, (double)midZ + 0.01), (float)red, (float)green, (float)blue, (float)(alpha * 0.5f));
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)new AABB((double)midX - 0.01, y1, z1, (double)midX + 0.01, y1 + 0.02, z2), (float)red, (float)green, (float)blue, (float)(alpha * 0.5f));
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)new AABB(x1, y2 - 0.02, (double)midZ - 0.01, x2, y2, (double)midZ + 0.01), (float)red, (float)green, (float)blue, (float)(alpha * 0.5f));
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)new AABB((double)midX - 0.01, y2 - 0.02, z1, (double)midX + 0.01, y2, z2), (float)red, (float)green, (float)blue, (float)(alpha * 0.5f));
        }
    }
}

