/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.seen;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import world.landfall.landfallessentials.seen.PlayerSeenEntry;

public class SeenPersistentState
extends SavedData {
    private final Map<UUID, PlayerSeenEntry> playerSeenData = new HashMap<UUID, PlayerSeenEntry>();
    private static final String DATA_NAME = "landfallessentials_seen_data";
    private static final SavedData.Factory<SeenPersistentState> FACTORY = new SavedData.Factory(SeenPersistentState::new, SeenPersistentState::load, null);

    public SeenPersistentState() {
    }

    private SeenPersistentState(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag playersTag = tag.getCompound("players");
        for (String uuidString : playersTag.getAllKeys()) {
            try {
                UUID uuid = UUID.fromString(uuidString);
                CompoundTag playerData = playersTag.getCompound(uuidString);
                String playerName = playerData.getString("playerName");
                long lastSeenTimestamp = playerData.getLong("lastSeenTimestamp");
                this.playerSeenData.put(uuid, new PlayerSeenEntry(playerName, lastSeenTimestamp));
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error loading seen data for UUID string: " + uuidString);
            }
        }
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        CompoundTag playersTag = new CompoundTag();
        for (Map.Entry<UUID, PlayerSeenEntry> entry : this.playerSeenData.entrySet()) {
            CompoundTag playerData = new CompoundTag();
            playerData.putString("playerName", entry.getValue().playerName());
            playerData.putLong("lastSeenTimestamp", entry.getValue().lastSeenTimestamp());
            playersTag.put(entry.getKey().toString(), (Tag)playerData);
        }
        nbt.put("players", (Tag)playersTag);
        return nbt;
    }

    public PlayerSeenEntry getPlayerSeenEntry(UUID playerUuid) {
        return this.playerSeenData.get(playerUuid);
    }

    public void updatePlayerSeenEntry(UUID playerUuid, String playerName, long lastSeenTimestamp) {
        this.playerSeenData.put(playerUuid, new PlayerSeenEntry(playerName, lastSeenTimestamp));
        this.setDirty();
    }

    public void updatePlayerName(UUID playerUuid, String newPlayerName) {
        PlayerSeenEntry entry = this.playerSeenData.get(playerUuid);
        if (entry != null) {
            this.playerSeenData.put(playerUuid, new PlayerSeenEntry(newPlayerName, entry.lastSeenTimestamp()));
            this.setDirty();
        }
    }

    public Map<UUID, PlayerSeenEntry> getAllSeenEntries() {
        return new HashMap<UUID, PlayerSeenEntry>(this.playerSeenData);
    }

    private static SeenPersistentState load(CompoundTag tag, HolderLookup.Provider registries) {
        return new SeenPersistentState(tag, registries);
    }

    public static SeenPersistentState getServerState(ServerLevel overworld) {
        return (SeenPersistentState)overworld.getDataStorage().computeIfAbsent(FACTORY, DATA_NAME);
    }
}

