/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.tpa.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.landfallessentials.tpa.TPAManager;

public class TPACommand {
    private static final SimpleCommandExceptionType CANNOT_TELEPORT_SELF = new SimpleCommandExceptionType((Message)Component.literal((String)"Cannot teleport to yourself"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"tpa").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(TPACommand::execute)));
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"tpahere").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(TPACommand::executeHere)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target;
        ServerPlayer source = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (source == (target = EntityArgument.getPlayer(context, (String)"target"))) {
            throw CANNOT_TELEPORT_SELF.create();
        }
        TPAManager.getInstance().createRequest(source, target, false);
        return 1;
    }

    private static int executeHere(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target;
        ServerPlayer source = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (source == (target = EntityArgument.getPlayer(context, (String)"target"))) {
            throw CANNOT_TELEPORT_SELF.create();
        }
        TPAManager.getInstance().createRequest(source, target, true);
        return 1;
    }
}

