/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.tpa.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.landfallessentials.tpa.TPAManager;
import world.landfall.landfallessentials.tpa.TPARequest;

public class TPAcceptCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"tpaccept").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(TPAcceptCommand::execute)));
    }

    private static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer acceptor = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerPlayer requester = EntityArgument.getPlayer(context, (String)"player");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        TPARequest request = TPAManager.getInstance().acceptRequest(acceptor, requester);
        if (request != null) {
            String commandToExecute = request.isTpaHere() ? String.format("tp %s %s", acceptor.getScoreboardName(), requester.getScoreboardName()) : String.format("tp %s %s", requester.getScoreboardName(), acceptor.getScoreboardName());
            server.getCommands().performPrefixedCommand(server.createCommandSourceStack(), commandToExecute);
        }
        return 1;
    }
}

