/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.client.screen;

import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowRAMWarningScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(LowRAMWarningScreen.class);
    private final Screen previousScreen;
    private final double totalMemoryGB;
    private static final long RECOMMENDED_RAM_GB = 8L;

    public LowRAMWarningScreen(Screen previousScreen) {
        super((Component)Component.literal((String)"Low RAM Warning"));
        this.previousScreen = previousScreen;
        long maxMemoryBytes = Runtime.getRuntime().maxMemory();
        this.totalMemoryGB = (double)maxMemoryBytes / 1.073741824E9;
        LOGGER.info("LowRAMWarningScreen created - Detected {} GB allocated RAM", (Object)String.format("%.1f", this.totalMemoryGB));
    }

    protected void init() {
        super.init();
        int buttonY = this.height / 2 + 60;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Continue Anyway").withStyle(ChatFormatting.YELLOW), button -> Minecraft.getInstance().setScreen(this.previousScreen)).pos(this.width / 2 - 155, buttonY).size(150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Exit Game").withStyle(ChatFormatting.RED), button -> Minecraft.getInstance().stop()).pos(this.width / 2 + 5, buttonY).size(150, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.fill(0, 0, this.width, this.height, -872415232);
        int borderWidth = 3;
        guiGraphics.fill(0, 0, this.width, borderWidth, -8388608);
        guiGraphics.fill(0, this.height - borderWidth, this.width, this.height, -8388608);
        guiGraphics.fill(0, 0, borderWidth, this.height, -8388608);
        guiGraphics.fill(this.width - borderWidth, 0, this.width, this.height, -8388608);
        int centerX = this.width / 2;
        int startY = this.height / 2 - 60;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"\u26a0 LOW RAM WARNING \u26a0").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), centerX, startY, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)String.format("Your system has only %.1f GB of allocated RAM", this.totalMemoryGB)).withStyle(ChatFormatting.YELLOW), centerX, startY + 20, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"This modpack requires at least 8 GB for optimal performance").withStyle(ChatFormatting.WHITE), centerX, startY + 35, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"You may experience:").withStyle(ChatFormatting.GRAY), centerX, startY + 55, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"\u2022 Frequent crashes and freezes").withStyle(ChatFormatting.RED), centerX, startY + 70, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"\u2022 Very long loading times").withStyle(ChatFormatting.RED), centerX, startY + 85, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"\u2022 Poor performance and low FPS").withStyle(ChatFormatting.RED), centerX, startY + 100, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)"To allocate more RAM, follow our guide:").withStyle(ChatFormatting.GRAY), centerX, this.height - 45, 0xFFFFFF);
        String url = "https://wiki.landfall.world/guides/changing-allocated-ram-in-modrinth-launcher";
        MutableComponent urlComponent = Component.literal((String)url).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE});
        int urlWidth = this.font.width((FormattedText)urlComponent);
        int urlX = centerX - urlWidth / 2;
        int urlY = this.height - 30;
        guiGraphics.drawString(this.font, (Component)urlComponent, urlX, urlY, 0xFFFFFF);
        if (mouseX >= urlX && mouseX <= urlX + urlWidth && mouseY >= urlY && mouseY <= urlY + 10) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"Click to open in browser"), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        String url = "https://wiki.landfall.world/guides/changing-allocated-ram-in-modrinth-launcher";
        MutableComponent urlComponent = Component.literal((String)url).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE});
        int urlWidth = this.font.width((FormattedText)urlComponent);
        int urlX = this.width / 2 - urlWidth / 2;
        int urlY = this.height - 30;
        if (mouseX >= (double)urlX && mouseX <= (double)(urlX + urlWidth) && mouseY >= (double)urlY && mouseY <= (double)(urlY + 10)) {
            Util.getPlatform().openUri(url);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public static boolean shouldShowWarning() {
        long maxMemoryBytes = Runtime.getRuntime().maxMemory();
        long maxMemoryGB = maxMemoryBytes / 0x40000000L;
        return maxMemoryGB < 8L;
    }
}

