/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.home;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.Config;
import world.landfall.landfallessentials.home.Home;
import world.landfall.landfallessentials.home.HomeData;
import world.landfall.landfallessentials.home.HomeLuckPermsIntegration;

@EventBusSubscriber
public class HomeSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(HomeSystem.class);
    private static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+$");
    private static boolean initialized = false;

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            return;
        }
        HomeSystem.initialize();
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (FMLEnvironment.dist.isClient() || !Config.requireBedForHomes) {
            return;
        }
        BlockState state = event.getState();
        if (state.getBlock() instanceof BedBlock) {
            BlockPos bedPos = event.getPos();
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                ResourceKey dimension = serverLevel.dimension();
                BlockPos footPos = bedPos;
                if (state.hasProperty((Property)BedBlock.PART) && state.getValue((Property)BedBlock.PART) == BedPart.HEAD) {
                    footPos = bedPos.relative(((Direction)state.getValue((Property)BedBlock.FACING)).getOpposite());
                }
                HomeData data = HomeData.get(serverLevel.getServer().overworld());
                data.disableHomeByBed(footPos, (ResourceKey<Level>)dimension);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (FMLEnvironment.dist.isClient() || !Config.requireBedForHomes) {
            return;
        }
        BlockState state = event.getPlacedBlock();
        if (state.getBlock() instanceof BedBlock) {
            BlockPos bedPos = event.getPos();
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                ResourceKey dimension = serverLevel.dimension();
                BlockPos footPos = bedPos;
                if (state.hasProperty((Property)BedBlock.PART) && state.getValue((Property)BedBlock.PART) == BedPart.HEAD) {
                    footPos = bedPos.relative(((Direction)state.getValue((Property)BedBlock.FACING)).getOpposite());
                }
                HomeData data = HomeData.get(serverLevel.getServer().overworld());
                data.enableHomeByBed(footPos, (ResourceKey<Level>)dimension);
            }
        }
    }

    public static void initialize() {
        if (initialized) {
            LOGGER.debug("HomeSystem already initialized.");
            return;
        }
        if (FMLEnvironment.dist.isClient()) {
            LOGGER.warn("HomeSystem.initialize() called on client. Skipping.");
            return;
        }
        LOGGER.info("Initializing HomeSystem...");
        HomeLuckPermsIntegration.initialize();
        initialized = true;
        LOGGER.info("HomeSystem initialized successfully. Bed requirement: {}", (Object)Config.requireBedForHomes);
    }

    private static HomeData getHomeData(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return null;
        }
        ServerLevel level = player.getServer().overworld();
        return HomeData.get(level);
    }

    private static BlockPos findNearbyBed(ServerPlayer player) {
        BlockPos playerPos = player.blockPosition();
        ServerLevel level = player.serverLevel();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos checkPos = playerPos.offset(x, y, z);
                    BlockState state = level.getBlockState(checkPos);
                    if (!(state.getBlock() instanceof BedBlock)) continue;
                    BlockPos footPos = checkPos;
                    if (state.hasProperty((Property)BedBlock.PART) && state.getValue((Property)BedBlock.PART) == BedPart.HEAD) {
                        footPos = checkPos.relative(((Direction)state.getValue((Property)BedBlock.FACING)).getOpposite());
                    }
                    return footPos;
                }
            }
        }
        return null;
    }

    public static Map<String, Home> getPlayerHomes(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return new HashMap<String, Home>();
        }
        HomeData data = HomeSystem.getHomeData(player);
        return data != null ? data.getPlayerHomes(player.getUUID()) : new HashMap();
    }

    public static Home getHome(ServerPlayer player, String homeName) {
        if (FMLEnvironment.dist.isClient()) {
            return null;
        }
        HomeData data = HomeSystem.getHomeData(player);
        return data != null ? data.getHome(player.getUUID(), homeName) : null;
    }

    public static int getMaxHomes(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return Config.defaultMaxHomes;
        }
        int baseHomes = Config.defaultMaxHomes;
        int bonusHomes = HomeLuckPermsIntegration.getBonusHomes(player);
        return baseHomes + bonusHomes;
    }

    public static long getCooldownTime(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return Config.defaultHomeCooldown;
        }
        long override = HomeLuckPermsIntegration.getCooldownOverride(player);
        return override >= 0L ? override : Config.defaultHomeCooldown;
    }

    public static boolean isOnCooldown(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return false;
        }
        HomeData data = HomeSystem.getHomeData(player);
        if (data == null) {
            return false;
        }
        long cooldownTime = HomeSystem.getCooldownTime(player);
        return data.isOnCooldown(player.getUUID(), cooldownTime);
    }

    public static long getRemainingCooldown(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return 0L;
        }
        HomeData data = HomeSystem.getHomeData(player);
        if (data == null) {
            return 0L;
        }
        long cooldownTime = HomeSystem.getCooldownTime(player);
        return data.getRemainingCooldown(player.getUUID(), cooldownTime);
    }

    public static boolean isValidHomeName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (name.length() > Config.maxHomeNameLength) {
            return false;
        }
        return VALID_NAME_PATTERN.matcher(name).matches();
    }

    public static HomeSetResult setHome(ServerPlayer player, String homeName) {
        int maxHomes;
        int currentHomes;
        boolean homeExists;
        if (FMLEnvironment.dist.isClient()) {
            return HomeSetResult.CLIENT_SIDE;
        }
        if (!HomeSystem.isValidHomeName(homeName)) {
            return HomeSetResult.INVALID_NAME;
        }
        HomeData data = HomeSystem.getHomeData(player);
        if (data == null) {
            return HomeSetResult.DATA_ERROR;
        }
        BlockPos bedPosition = null;
        if (Config.requireBedForHomes) {
            bedPosition = HomeSystem.findNearbyBed(player);
            if (bedPosition == null) {
                return HomeSetResult.NO_BED_NEARBY;
            }
            UUID bedOwner = data.getBedOwner(bedPosition, (ResourceKey<Level>)player.level().dimension());
            if (bedOwner != null && !bedOwner.equals(player.getUUID())) {
                return HomeSetResult.BED_ALREADY_CLAIMED;
            }
            String existingHomeName = data.getBedHomeName(bedPosition, (ResourceKey<Level>)player.level().dimension());
            if (existingHomeName != null && !existingHomeName.equals(homeName)) {
                return HomeSetResult.BED_HAS_DIFFERENT_HOME;
            }
        }
        if (!(homeExists = data.hasHome(player.getUUID(), homeName)) && (currentHomes = data.getHomeCount(player.getUUID())) >= (maxHomes = HomeSystem.getMaxHomes(player))) {
            return HomeSetResult.LIMIT_REACHED;
        }
        ResourceKey dimension = player.level().dimension();
        Home home = bedPosition != null ? new Home(homeName, player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot(), (ResourceKey<Level>)dimension, bedPosition) : new Home(homeName, player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot(), (ResourceKey<Level>)dimension);
        data.setHome(player.getUUID(), homeName, home);
        return homeExists ? HomeSetResult.UPDATED : HomeSetResult.CREATED;
    }

    public static boolean deleteHome(ServerPlayer player, String homeName) {
        if (FMLEnvironment.dist.isClient()) {
            return false;
        }
        HomeData data = HomeSystem.getHomeData(player);
        if (data == null) {
            return false;
        }
        return data.deleteHome(player.getUUID(), homeName);
    }

    public static void clearPlayerHomes(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return;
        }
        HomeData data = HomeSystem.getHomeData(player);
        if (data != null) {
            data.clearPlayerHomes(player.getUUID());
        }
    }

    public static HomeTeleportResult teleportToHome(ServerPlayer player, String homeName) {
        if (FMLEnvironment.dist.isClient()) {
            return HomeTeleportResult.CLIENT_SIDE;
        }
        if (HomeSystem.isOnCooldown(player)) {
            return HomeTeleportResult.ON_COOLDOWN;
        }
        HomeData data = HomeSystem.getHomeData(player);
        if (data == null) {
            return HomeTeleportResult.DATA_ERROR;
        }
        Home home = data.getHome(player.getUUID(), homeName);
        if (home == null) {
            return HomeTeleportResult.HOME_NOT_FOUND;
        }
        if (home.isDisabled()) {
            return HomeTeleportResult.HOME_DISABLED;
        }
        if (!HomeSystem.isHomeAccessible(player, homeName)) {
            return HomeTeleportResult.HOME_LOCKED;
        }
        ServerLevel targetLevel = player.getServer().getLevel(home.getDimension());
        if (targetLevel == null) {
            return HomeTeleportResult.DIMENSION_NOT_FOUND;
        }
        try {
            if (player.level() != targetLevel) {
                player.teleportTo(targetLevel, home.getX(), home.getY(), home.getZ(), home.getYaw(), home.getPitch());
            } else {
                player.teleportTo(home.getX(), home.getY(), home.getZ());
                player.setYRot(home.getYaw());
                player.setXRot(home.getPitch());
            }
            data.setLastTeleportTime(player.getUUID(), System.currentTimeMillis());
            return HomeTeleportResult.SUCCESS;
        }
        catch (Exception e) {
            LOGGER.warn("Error teleporting player {} to home {}", new Object[]{player.getName().getString(), homeName, e});
            return HomeTeleportResult.TELEPORT_FAILED;
        }
    }

    public static boolean isHomeAccessible(ServerPlayer player, String homeName) {
        if (FMLEnvironment.dist.isClient()) {
            return true;
        }
        Home home = HomeSystem.getHome(player, homeName);
        if (home == null || home.isDisabled()) {
            return false;
        }
        Map<String, Home> accessibleHomes = HomeSystem.getAccessibleHomes(player);
        return accessibleHomes.containsKey(homeName);
    }

    public static Map<String, Home> getAccessibleHomes(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return new HashMap<String, Home>();
        }
        Map<String, Home> allHomes = HomeSystem.getPlayerHomes(player);
        int maxHomes = HomeSystem.getMaxHomes(player);
        LinkedHashMap<String, Home> enabledHomes = new LinkedHashMap<String, Home>();
        for (Map.Entry<String, Home> entry : allHomes.entrySet()) {
            if (entry.getValue().isDisabled()) continue;
            enabledHomes.put(entry.getKey(), entry.getValue());
        }
        if (enabledHomes.size() <= maxHomes) {
            return enabledHomes;
        }
        LinkedHashMap<String, Home> accessibleHomes = new LinkedHashMap<String, Home>();
        if (enabledHomes.containsKey("default")) {
            accessibleHomes.put("default", (Home)enabledHomes.get("default"));
            if (maxHomes == 1) {
                return accessibleHomes;
            }
        }
        ArrayList<String> otherNames = new ArrayList<String>();
        for (String name : enabledHomes.keySet()) {
            if (name.equals("default")) continue;
            otherNames.add(name);
        }
        otherNames.sort(String::compareToIgnoreCase);
        int remainingSlots = maxHomes - accessibleHomes.size();
        for (int i = 0; i < Math.min(remainingSlots, otherNames.size()); ++i) {
            String name = (String)otherNames.get(i);
            accessibleHomes.put(name, (Home)enabledHomes.get(name));
        }
        return accessibleHomes;
    }

    public static int getHomeCount(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return 0;
        }
        HomeData data = HomeSystem.getHomeData(player);
        return data != null ? data.getHomeCount(player.getUUID()) : 0;
    }

    public static Set<String> getHomeNames(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient()) {
            return new HashSet<String>();
        }
        HomeData data = HomeSystem.getHomeData(player);
        return data != null ? data.getHomeNames(player.getUUID()) : new HashSet();
    }

    public static boolean isBedClaimed(ServerPlayer player, BlockPos bedPos) {
        if (FMLEnvironment.dist.isClient()) {
            return false;
        }
        HomeData data = HomeSystem.getHomeData(player);
        return data != null && data.isBedClaimed(bedPos, (ResourceKey<Level>)player.level().dimension());
    }

    public static UUID getBedOwner(ServerPlayer player, BlockPos bedPos) {
        if (FMLEnvironment.dist.isClient()) {
            return null;
        }
        HomeData data = HomeSystem.getHomeData(player);
        return data != null ? data.getBedOwner(bedPos, (ResourceKey<Level>)player.level().dimension()) : null;
    }

    public static String getLuckPermsStatus() {
        if (FMLEnvironment.dist.isClient()) {
            return "Client side";
        }
        if (!initialized) {
            return "Not initialized";
        }
        return HomeLuckPermsIntegration.getStatus();
    }

    public static enum HomeSetResult {
        CREATED,
        UPDATED,
        INVALID_NAME,
        LIMIT_REACHED,
        NO_BED_NEARBY,
        BED_ALREADY_CLAIMED,
        BED_HAS_DIFFERENT_HOME,
        DATA_ERROR,
        CLIENT_SIDE;

    }

    public static enum HomeTeleportResult {
        SUCCESS,
        HOME_NOT_FOUND,
        HOME_LOCKED,
        HOME_DISABLED,
        ON_COOLDOWN,
        DIMENSION_NOT_FOUND,
        TELEPORT_FAILED,
        DATA_ERROR,
        CLIENT_SIDE;

    }
}

