/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.karma;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class KarmaData
extends SavedData {
    private static final String DATA_NAME = "landfallessentials_karma";
    private final Map<UUID, Integer> karmaMap = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, String> donorMap = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Double> fractionalKarmaMap = new ConcurrentHashMap<UUID, Double>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public KarmaData() {
    }

    public KarmaData(CompoundTag tag, HolderLookup.Provider provider) {
        this();
        CompoundTag karmaTag = tag.getCompound("karma");
        for (Object key : karmaTag.getAllKeys()) {
            try {
                UUID uuid = UUID.fromString((String)key);
                int karma = karmaTag.getInt((String)key);
                this.karmaMap.put(uuid, karma);
            }
            catch (IllegalArgumentException uuid) {}
        }
        CompoundTag donorTag = tag.getCompound("donors");
        for (String key : donorTag.getAllKeys()) {
            try {
                UUID uuid = UUID.fromString(key);
                String donorLevel = donorTag.getString(key);
                this.donorMap.put(uuid, donorLevel);
            }
            catch (IllegalArgumentException uuid) {}
        }
        CompoundTag fractionalTag = tag.getCompound("fractional_karma");
        for (String key : fractionalTag.getAllKeys()) {
            try {
                UUID uuid = UUID.fromString(key);
                double fractionalKarma = fractionalTag.getDouble(key);
                this.fractionalKarmaMap.put(uuid, fractionalKarma);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag karmaTag = new CompoundTag();
        for (Map.Entry<UUID, Integer> entry : this.karmaMap.entrySet()) {
            karmaTag.putInt(entry.getKey().toString(), entry.getValue().intValue());
        }
        tag.put("karma", (Tag)karmaTag);
        CompoundTag donorTag = new CompoundTag();
        for (Map.Entry<UUID, String> entry : this.donorMap.entrySet()) {
            donorTag.putString(entry.getKey().toString(), entry.getValue());
        }
        tag.put("donors", (Tag)donorTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<UUID, Double> entry : this.fractionalKarmaMap.entrySet()) {
            compoundTag.putDouble(entry.getKey().toString(), entry.getValue().doubleValue());
        }
        tag.put("fractional_karma", (Tag)compoundTag);
        return tag;
    }

    public static KarmaData get(ServerLevel level) {
        DimensionDataStorage storage = level.getDataStorage();
        return (KarmaData)storage.computeIfAbsent(new SavedData.Factory(KarmaData::new, KarmaData::new, null), DATA_NAME);
    }

    public int getKarma(UUID playerUUID) {
        this.lock.readLock().lock();
        try {
            int n = this.karmaMap.getOrDefault(playerUUID, 0);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setKarma(UUID playerUUID, int karma) {
        this.lock.writeLock().lock();
        try {
            this.karmaMap.put(playerUUID, Math.max(0, karma));
            this.setDirty();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKarma(UUID playerUUID, int amount) {
        if (amount <= 0) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            int currentKarma = this.karmaMap.getOrDefault(playerUUID, 0);
            this.karmaMap.put(playerUUID, currentKarma + amount);
            this.setDirty();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKarma(UUID playerUUID, int amount) {
        if (amount <= 0) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            int currentKarma = this.karmaMap.getOrDefault(playerUUID, 0);
            this.karmaMap.put(playerUUID, Math.max(0, currentKarma - amount));
            this.setDirty();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFractionalKarma(UUID playerUUID) {
        this.lock.readLock().lock();
        try {
            double d = this.fractionalKarmaMap.getOrDefault(playerUUID, 0.0);
            return d;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFractionalKarma(UUID playerUUID, double amount) {
        if (amount <= 0.0) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            double currentFractional = this.fractionalKarmaMap.getOrDefault(playerUUID, 0.0);
            double newFractional = currentFractional + amount;
            int wholeKarma = (int)Math.floor(newFractional);
            double remainingFractional = newFractional - (double)wholeKarma;
            if (wholeKarma > 0) {
                int currentKarma = this.karmaMap.getOrDefault(playerUUID, 0);
                this.karmaMap.put(playerUUID, currentKarma + wholeKarma);
            }
            this.fractionalKarmaMap.put(playerUUID, remainingFractional);
            this.setDirty();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String getDonorLevel(UUID playerUUID) {
        this.lock.readLock().lock();
        try {
            String string = this.donorMap.getOrDefault(playerUUID, "");
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDonorLevel(UUID playerUUID, String level) {
        this.lock.writeLock().lock();
        try {
            if (level == null || level.isEmpty()) {
                this.donorMap.remove(playerUUID);
            } else {
                this.donorMap.put(playerUUID, level);
            }
            this.setDirty();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean hasDonorLevel(UUID playerUUID) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.donorMap.containsKey(playerUUID) && !this.donorMap.get(playerUUID).isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<UUID, Integer> getAllKarma() {
        this.lock.readLock().lock();
        try {
            HashMap<UUID, Integer> hashMap = new HashMap<UUID, Integer>(this.karmaMap);
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<UUID, String> getAllDonors() {
        this.lock.readLock().lock();
        try {
            HashMap<UUID, String> hashMap = new HashMap<UUID, String>(this.donorMap);
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<UUID, Double> getAllFractionalKarma() {
        this.lock.readLock().lock();
        try {
            HashMap<UUID, Double> hashMap = new HashMap<UUID, Double>(this.fractionalKarmaMap);
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

