/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.karma;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.landfall.landfallessentials.util.LuckPermsUtil;

public class LuckPermsIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuckPermsIntegration.class);
    private static final String KARMA_PERK_PERMISSION_PREFIX = "landfallessentials.karma.donorperk.";
    private static final String KARMA_PERK_META_KEY = "landfallessentials.karma.donorperk";

    public static void initialize() {
        LuckPermsUtil.initialize();
        if (LuckPermsUtil.isAvailable()) {
            LOGGER.info("Karma LuckPerms integration: Donor perk detection active.");
        } else {
            LOGGER.info("Karma LuckPerms integration: LuckPerms not available, donor perks disabled.");
        }
    }

    public static double getDonorBonus(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient() || player == null || player.getServer() == null || !LuckPermsUtil.isAvailable()) {
            return 0.0;
        }
        try {
            Object user = LuckPermsUtil.getUser(player.getUUID());
            if (user == null) {
                return 0.0;
            }
            double permissionBonus = LuckPermsIntegration.getDonorBonusFromPermissions(user, player.getUUID());
            if (permissionBonus > 0.0) {
                return permissionBonus;
            }
            return LuckPermsIntegration.getDonorBonusFromMeta(user, player.getUUID());
        }
        catch (Exception e) {
            LOGGER.warn("Error getting donor bonus from LuckPerms for player " + player.getName().getString(), (Throwable)e);
            return 0.0;
        }
    }

    public static String getDonorLevel(ServerPlayer player) {
        if (FMLEnvironment.dist.isClient() || player == null || player.getServer() == null || !LuckPermsUtil.isAvailable()) {
            return "";
        }
        try {
            Object user = LuckPermsUtil.getUser(player.getUUID());
            if (user == null) {
                return "";
            }
            return LuckPermsIntegration.getDonorLevelInternal(user);
        }
        catch (Exception e) {
            LOGGER.warn("Error getting donor level from LuckPerms for player " + player.getName().getString(), (Throwable)e);
            return "";
        }
    }

    private static double getDonorBonusFromPermissions(Object user, UUID playerUUID) {
        Object permissionData = LuckPermsUtil.getPermissionData(user);
        if (permissionData == null) {
            return 0.0;
        }
        int[] commonPercentages = new int[]{5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 60, 70, 75, 80, 90, 100, 125, 150, 200};
        double highestBonus = 0.0;
        LOGGER.debug("Checking karma donor permissions for player {}", (Object)playerUUID);
        for (int percentage : commonPercentages) {
            String permissionNode = KARMA_PERK_PERMISSION_PREFIX + percentage;
            if (!LuckPermsUtil.checkPermission(permissionData, permissionNode)) continue;
            double bonus = (double)percentage / 100.0;
            LOGGER.debug("Found karma donor perk: {}% for player {}", (Object)percentage, (Object)playerUUID);
            if (!(bonus > highestBonus)) continue;
            highestBonus = bonus;
        }
        LOGGER.debug("Final donor bonus from permissions: {} for player {}", (Object)highestBonus, (Object)playerUUID);
        return highestBonus;
    }

    private static double getDonorBonusFromMeta(Object user, UUID playerUUID) {
        Object metaData = LuckPermsUtil.getMetaData(user);
        if (metaData == null) {
            return 0.0;
        }
        String metaValue = LuckPermsUtil.getMetaValue(metaData, KARMA_PERK_META_KEY);
        if (metaValue == null || metaValue.isEmpty()) {
            return 0.0;
        }
        try {
            double percentage = Double.parseDouble(metaValue);
            return percentage / 100.0;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid karma perk meta value '{}' for player {}", (Object)metaValue, (Object)playerUUID);
            return 0.0;
        }
    }

    private static String getDonorLevelInternal(Object user) throws Exception {
        String[] possibleKeys;
        Object metaData = LuckPermsUtil.getMetaData(user);
        if (metaData == null) {
            return "";
        }
        for (String key : possibleKeys = new String[]{"displayname", "donor-level", "rank", "group"}) {
            String value = LuckPermsUtil.getMetaValue(metaData, key);
            if (value == null || value.isEmpty()) continue;
            return value;
        }
        if (user != null) {
            try {
                String primaryGroup = (String)user.getClass().getMethod("getPrimaryGroup", new Class[0]).invoke(user, new Object[0]);
                if (primaryGroup != null && !primaryGroup.equals("default")) {
                    return primaryGroup;
                }
            }
            catch (Exception ignored) {
                LOGGER.debug("Could not retrieve primary group for user via reflection.", (Throwable)ignored);
            }
        }
        return "";
    }

    public static boolean isAvailable() {
        return LuckPermsUtil.isAvailable();
    }

    public static String getStatus() {
        if (FMLEnvironment.dist.isClient()) {
            return "Client side";
        }
        return LuckPermsUtil.isAvailable() ? "Active" : "Disabled / Not Initialized";
    }
}

