/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.karma;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerSnapshotData
extends SavedData {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlayerSnapshotData.class);
    private static final String DATA_NAME = "landfallessentials_player_snapshots";
    private final Map<UUID, SnapshotEntry> snapshots = new HashMap<UUID, SnapshotEntry>();

    public PlayerSnapshotData() {
    }

    public PlayerSnapshotData(CompoundTag tag, HolderLookup.Provider provider) {
        this();
        this.load(tag);
    }

    private void load(CompoundTag tag) {
        this.snapshots.clear();
        CompoundTag snapshotsTag = tag.getCompound("Snapshots");
        for (String uuidString : snapshotsTag.getAllKeys()) {
            try {
                UUID playerUUID = UUID.fromString(uuidString);
                CompoundTag snapshotTag = snapshotsTag.getCompound(uuidString);
                SnapshotEntry entry = SnapshotEntry.fromNBT(snapshotTag);
                this.snapshots.put(playerUUID, entry);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Invalid UUID in player snapshot data: {}", (Object)uuidString);
            }
        }
        LOGGER.info("Loaded {} player snapshots from disk", (Object)this.snapshots.size());
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag snapshotsTag = new CompoundTag();
        for (Map.Entry<UUID, SnapshotEntry> entry : this.snapshots.entrySet()) {
            snapshotsTag.put(entry.getKey().toString(), (Tag)entry.getValue().toNBT());
        }
        tag.put("Snapshots", (Tag)snapshotsTag);
        return tag;
    }

    public static PlayerSnapshotData get(ServerLevel level) {
        DimensionDataStorage storage = level.getDataStorage();
        return (PlayerSnapshotData)storage.computeIfAbsent(new SavedData.Factory(PlayerSnapshotData::new, PlayerSnapshotData::new, null), DATA_NAME);
    }

    public void setSnapshot(UUID playerUUID, SnapshotEntry snapshot) {
        this.snapshots.put(playerUUID, snapshot);
        this.setDirty();
        LOGGER.info("Saved snapshot for player {} to disk", (Object)playerUUID);
    }

    public SnapshotEntry getSnapshot(UUID playerUUID) {
        return this.snapshots.get(playerUUID);
    }

    public void removeSnapshot(UUID playerUUID) {
        SnapshotEntry removed = this.snapshots.remove(playerUUID);
        if (removed != null) {
            this.setDirty();
            LOGGER.info("Removed snapshot for player {} from disk", (Object)playerUUID);
        }
    }

    public boolean hasSnapshot(UUID playerUUID) {
        return this.snapshots.containsKey(playerUUID);
    }

    public int getSnapshotCount() {
        return this.snapshots.size();
    }

    public static class SnapshotEntry {
        public final ListTag inventoryItems;
        public final CompoundTag curiosItems;
        public final int experienceLevel;
        public final float experienceProgress;
        public final int totalExperience;
        public final int foodLevel;
        public final float saturationLevel;

        public SnapshotEntry(ListTag inventoryItems, CompoundTag curiosItems, int experienceLevel, float experienceProgress, int totalExperience, int foodLevel, float saturationLevel) {
            this.inventoryItems = inventoryItems;
            this.curiosItems = curiosItems;
            this.experienceLevel = experienceLevel;
            this.experienceProgress = experienceProgress;
            this.totalExperience = totalExperience;
            this.foodLevel = foodLevel;
            this.saturationLevel = saturationLevel;
        }

        public static SnapshotEntry fromNBT(CompoundTag tag) {
            ListTag inventoryItems = tag.getList("InventoryItems", 10);
            CompoundTag curiosItems = tag.getCompound("CuriosItems");
            int experienceLevel = tag.getInt("ExperienceLevel");
            float experienceProgress = tag.getFloat("ExperienceProgress");
            int totalExperience = tag.getInt("TotalExperience");
            int foodLevel = tag.getInt("FoodLevel");
            float saturationLevel = tag.getFloat("SaturationLevel");
            return new SnapshotEntry(inventoryItems, curiosItems, experienceLevel, experienceProgress, totalExperience, foodLevel, saturationLevel);
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.put("InventoryItems", (Tag)this.inventoryItems);
            tag.put("CuriosItems", (Tag)this.curiosItems);
            tag.putInt("ExperienceLevel", this.experienceLevel);
            tag.putFloat("ExperienceProgress", this.experienceProgress);
            tag.putInt("TotalExperience", this.totalExperience);
            tag.putInt("FoodLevel", this.foodLevel);
            tag.putFloat("SaturationLevel", this.saturationLevel);
            return tag;
        }
    }
}

