/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.moderation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import world.landfall.landfallessentials.moderation.ModerationManager;

public record ResourcePackListPacket(List<ResourcePackInfo> resourcePacks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ResourcePackListPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"landfallessentials", (String)"resource_pack_list"));
    public static final StreamCodec<FriendlyByteBuf, ResourcePackListPacket> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ResourcePackListPacket>(){

        public ResourcePackListPacket decode(FriendlyByteBuf buffer) {
            int packCount = buffer.readVarInt();
            ArrayList<ResourcePackInfo> resourcePacks = new ArrayList<ResourcePackInfo>();
            for (int i = 0; i < packCount; ++i) {
                resourcePacks.add((ResourcePackInfo)ResourcePackInfo.STREAM_CODEC.decode((Object)buffer));
            }
            return new ResourcePackListPacket(resourcePacks);
        }

        public void encode(FriendlyByteBuf buffer, ResourcePackListPacket packet) {
            buffer.writeVarInt(packet.resourcePacks().size());
            for (ResourcePackInfo pack : packet.resourcePacks()) {
                ResourcePackInfo.STREAM_CODEC.encode((Object)buffer, (Object)pack);
            }
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ResourcePackListPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (context.player() != null) {
                ModerationManager.updatePlayerResourcePackData(context.player().getUUID(), packet.resourcePacks());
            }
        });
    }

    public record ResourcePackInfo(String id, String title, String description, String source) {
        public static final StreamCodec<FriendlyByteBuf, ResourcePackInfo> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ResourcePackInfo>(){

            public ResourcePackInfo decode(FriendlyByteBuf buffer) {
                return new ResourcePackInfo(buffer.readUtf(), buffer.readUtf(), buffer.readUtf(), buffer.readUtf());
            }

            public void encode(FriendlyByteBuf buffer, ResourcePackInfo packInfo) {
                buffer.writeUtf(packInfo.id());
                buffer.writeUtf(packInfo.title());
                buffer.writeUtf(packInfo.description());
                buffer.writeUtf(packInfo.source());
            }
        };
    }
}

