/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.landfallessentials.regions.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import world.landfall.landfallessentials.regions.Cuboid;
import world.landfall.landfallessentials.regions.Region;
import world.landfall.landfallessentials.regions.RegionManager;
import world.landfall.landfallessentials.regions.util.CommandMessageBuilder;
import world.landfall.landfallessentials.regions.util.RegionCommandHelper;

public class RegionAdminCommands {
    private static final int ADMIN_PERMISSION = 2;

    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"admin").requires(source -> source.hasPermission(2))).executes(RegionAdminCommands::executeAdminToggleSelf)).then(((LiteralArgumentBuilder)Commands.literal((String)"toggle").executes(RegionAdminCommands::executeAdminToggleSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionAdminCommands::executeAdminTogglePlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"enable").executes(RegionAdminCommands::executeAdminEnableSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionAdminCommands::executeAdminEnablePlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"disable").executes(RegionAdminCommands::executeAdminDisableSelf)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionAdminCommands::executeAdminDisablePlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"status").executes(RegionAdminCommands::executeAdminStatus)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).executes(RegionAdminCommands::executeAdminStatusPlayer)))).then(Commands.literal((String)"list").executes(RegionAdminCommands::executeAdminList))).then(((LiteralArgumentBuilder)Commands.literal((String)"performance").executes(RegionAdminCommands::executeAdminPerformanceAll)).then(Commands.argument((String)"region", (ArgumentType)StringArgumentType.string()).executes(RegionAdminCommands::executeAdminPerformanceRegion)));
    }

    private static int executeAdminToggleSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        String playerUUID = player.getUUID().toString();
        boolean enabled = RegionManager.toggleAdminBypass(playerUUID);
        if (enabled) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Admin bypass mode ").highlight("ENABLED").build(), true);
            player.displayClientMessage((Component)Component.literal((String)"\u00a76[ADMIN BYPASS MODE ACTIVE]"), true);
        } else {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Admin bypass mode ").error("DISABLED").build(), true);
            player.displayClientMessage((Component)Component.literal((String)"\u00a7aAdmin bypass mode disabled"), true);
        }
        return 1;
    }

    private static int executeAdminTogglePlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetName);
        if (targetPlayer == null) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Player '").highlight(targetName).error("' not found.").build());
            return 0;
        }
        String targetUUID = targetPlayer.getUUID().toString();
        boolean enabled = RegionManager.toggleAdminBypass(targetUUID);
        if (enabled) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Admin bypass mode ").highlight("ENABLED").success(" for ").highlight(targetName).build(), true);
            targetPlayer.displayClientMessage((Component)Component.literal((String)("\u00a76[ADMIN BYPASS MODE ACTIVE] - Granted by " + ((CommandSourceStack)ctx.getSource()).getTextName())), false);
        } else {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Admin bypass mode ").error("DISABLED").success(" for ").highlight(targetName).build(), true);
            targetPlayer.displayClientMessage((Component)Component.literal((String)("\u00a7cAdmin bypass mode disabled by " + ((CommandSourceStack)ctx.getSource()).getTextName())), false);
        }
        return 1;
    }

    private static int executeAdminEnableSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        String playerUUID = player.getUUID().toString();
        if (RegionManager.hasAdminBypass(playerUUID)) {
            RegionCommandHelper.sendSuccess(ctx, CommandMessageBuilder.infoMsg("Admin bypass mode is already enabled."));
        } else {
            RegionManager.enableAdminBypass(playerUUID);
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Admin bypass mode ").highlight("ENABLED").build(), true);
            player.displayClientMessage((Component)Component.literal((String)"\u00a76[ADMIN BYPASS MODE ACTIVE]"), true);
        }
        return 1;
    }

    private static int executeAdminEnablePlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetName);
        if (targetPlayer == null) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Player '").highlight(targetName).error("' not found.").build());
            return 0;
        }
        String targetUUID = targetPlayer.getUUID().toString();
        if (RegionManager.hasAdminBypass(targetUUID)) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().info("Admin bypass mode is already enabled for ").highlight(targetName).build());
        } else {
            RegionManager.enableAdminBypass(targetUUID);
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Admin bypass mode ").highlight("ENABLED").success(" for ").highlight(targetName).build(), true);
            targetPlayer.displayClientMessage((Component)Component.literal((String)("\u00a76[ADMIN BYPASS MODE ACTIVE] - Granted by " + ((CommandSourceStack)ctx.getSource()).getTextName())), false);
        }
        return 1;
    }

    private static int executeAdminDisableSelf(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        String playerUUID = player.getUUID().toString();
        if (!RegionManager.hasAdminBypass(playerUUID)) {
            RegionCommandHelper.sendSuccess(ctx, CommandMessageBuilder.infoMsg("Admin bypass mode is already disabled."));
        } else {
            RegionManager.disableAdminBypass(playerUUID);
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Admin bypass mode ").error("DISABLED").build(), true);
            player.displayClientMessage((Component)Component.literal((String)"\u00a7aAdmin bypass mode disabled"), true);
        }
        return 1;
    }

    private static int executeAdminDisablePlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetName);
        if (targetPlayer == null) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Player '").highlight(targetName).error("' not found.").build());
            return 0;
        }
        String targetUUID = targetPlayer.getUUID().toString();
        if (!RegionManager.hasAdminBypass(targetUUID)) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().info("Admin bypass mode is already disabled for ").highlight(targetName).build());
        } else {
            RegionManager.disableAdminBypass(targetUUID);
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().success("\u2713 Admin bypass mode ").error("DISABLED").success(" for ").highlight(targetName).build(), true);
            targetPlayer.displayClientMessage((Component)Component.literal((String)("\u00a7cAdmin bypass mode disabled by " + ((CommandSourceStack)ctx.getSource()).getTextName())), false);
        }
        return 1;
    }

    private static int executeAdminStatus(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = RegionCommandHelper.getPlayerOrFail(ctx);
        if (player == null) {
            return 0;
        }
        String playerUUID = player.getUUID().toString();
        boolean hasBypass = RegionManager.hasAdminBypass(playerUUID);
        if (hasBypass) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().info("Your admin bypass mode is: ").highlight("ENABLED").build());
        } else {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().info("Your admin bypass mode is: ").error("DISABLED").build());
        }
        return 1;
    }

    private static int executeAdminStatusPlayer(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        String targetName = StringArgumentType.getString(ctx, (String)"player");
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetName);
        if (targetPlayer == null) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Player '").highlight(targetName).error("' not found.").build());
            return 0;
        }
        String targetUUID = targetPlayer.getUUID().toString();
        boolean hasBypass = RegionManager.hasAdminBypass(targetUUID);
        if (hasBypass) {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().info("Admin bypass mode for ").highlight(targetName).info(" is: ").highlight("ENABLED").build());
        } else {
            RegionCommandHelper.sendSuccess(ctx, new CommandMessageBuilder().info("Admin bypass mode for ").highlight(targetName).info(" is: ").error("DISABLED").build());
        }
        return 1;
    }

    private static int executeAdminList(CommandContext<CommandSourceStack> ctx) {
        Set<String> bypassPlayers = RegionManager.getAdminBypassPlayers();
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        if (bypassPlayers.isEmpty()) {
            RegionCommandHelper.sendSuccess(ctx, CommandMessageBuilder.infoMsg("No players have admin bypass mode enabled."));
            return 0;
        }
        StringBuilder info = new StringBuilder();
        info.append("\u00a7b=== Players with Admin Bypass ===\n");
        for (String uuid : bypassPlayers) {
            ServerPlayer player = server.getPlayerList().getPlayer(UUID.fromString(uuid));
            if (player != null) {
                info.append("\u00a7e\u2022 ").append(player.getName().getString());
                info.append("\u00a77 (online)\n");
                continue;
            }
            info.append("\u00a77\u2022 ").append(uuid).append(" (offline - will be cleared)\n");
            RegionManager.disableAdminBypass(uuid);
        }
        RegionCommandHelper.sendSuccess(ctx, (Component)Component.literal((String)info.toString()));
        return bypassPlayers.size();
    }

    private static int executeAdminPerformanceAll(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.sendSuccess(() -> CommandMessageBuilder.infoMsg("===== Region Performance Statistics ====="), false);
        Map<String, Region> regionsMap = RegionManager.getAllRegions();
        Collection<Region> regions = regionsMap.values();
        if (regions.isEmpty()) {
            source.sendSuccess(() -> CommandMessageBuilder.infoMsg("No regions found."), false);
            return 1;
        }
        int smallRegions = 0;
        int mediumRegions = 0;
        int largeRegions = 0;
        for (Region region : regions) {
            int cuboidCount = region.getCuboidCount();
            if (cuboidCount <= 3) {
                ++smallRegions;
                continue;
            }
            if (cuboidCount <= 10) {
                ++mediumRegions;
                continue;
            }
            ++largeRegions;
        }
        int finalSmallRegions = smallRegions;
        int finalMediumRegions = mediumRegions;
        int finalLargeRegions = largeRegions;
        source.sendSuccess(() -> Component.literal((String)("\u00a7bTotal Regions: \u00a7e" + regions.size() + "\u00a7b (Small: \u00a77" + finalSmallRegions + "\u00a7b, Medium: \u00a77" + finalMediumRegions + "\u00a7b, Large: \u00a77" + finalLargeRegions + "\u00a7b)")), false);
        source.sendSuccess(() -> CommandMessageBuilder.infoMsg("Performance optimizations:"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77\u2022 Bounding box optimization for regions with >3 cuboids"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77\u2022 Spatial indexing for regions with >10 cuboids"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77\u2022 Player cuboid caching for all regions"), false);
        if (finalLargeRegions > 0) {
            source.sendSuccess(() -> CommandMessageBuilder.infoMsg("Showing detailed stats for large regions:"), false);
            for (Region region : regions) {
                if (region.getCuboidCount() <= 10) continue;
                source.sendSuccess(() -> Component.literal((String)("\u00a77\u2022 " + region.getPerformanceInfo())), false);
            }
        }
        return 1;
    }

    private static int executeAdminPerformanceRegion(CommandContext<CommandSourceStack> ctx) {
        String regionName = StringArgumentType.getString(ctx, (String)"region");
        Region region = RegionManager.getRegion(regionName);
        if (region == null) {
            RegionCommandHelper.sendFailure(ctx, new CommandMessageBuilder().error("\u2717 Region '").highlight(regionName).error("' not found.").build());
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        source.sendSuccess(() -> new CommandMessageBuilder().info("===== Performance Statistics for '").highlight(regionName).info("' =====").build(), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a77" + region.getPerformanceInfo())), false);
        int cuboidCount = region.getCuboidCount();
        String optimizationLevel = cuboidCount <= 3 ? "Basic (using bounding box check only)" : (cuboidCount <= 10 ? "Medium (using bounding box + player caching)" : "Advanced (using all optimizations: bounding box, spatial indexing, player caching)");
        source.sendSuccess(() -> Component.literal((String)("\u00a7bOptimization Level: \u00a77" + optimizationLevel)), false);
        source.sendSuccess(() -> Component.literal((String)("\u00a7bVolume: \u00a7e" + String.format("%,d", region.getVolume()) + "\u00a7b blocks")), false);
        if (cuboidCount > 1) {
            source.sendSuccess(() -> Component.literal((String)("\u00a7bCuboids: \u00a7e" + cuboidCount)), false);
            for (int i = 0; i < Math.min(5, cuboidCount); ++i) {
                Cuboid cuboid = region.getCuboid(i);
                if (cuboid == null) continue;
                int finalI = i;
                Cuboid finalCuboid = cuboid;
                source.sendSuccess(() -> Component.literal((String)("\u00a77  " + (finalI + 1) + ". " + finalCuboid.toDisplayString() + " (" + String.format("%,d", finalCuboid.getVolume()) + " blocks)")), false);
            }
            if (cuboidCount > 5) {
                source.sendSuccess(() -> Component.literal((String)("\u00a77  ... and " + (cuboidCount - 5) + " more")), false);
            }
        }
        return 1;
    }
}

